/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;

public class IntegerLiteral
extends SimpleLiteral {
    private static final long serialVersionUID = 4199641304079427245L;
    private final BigInteger value;

    protected IntegerLiteral(BigInteger value) {
        this(value, (CoreDatatype)CoreDatatype.XSD.INTEGER);
    }

    protected IntegerLiteral(BigInteger value, IRI datatype) {
        super(value.toString(), datatype);
        this.value = value;
    }

    protected IntegerLiteral(BigInteger value, CoreDatatype datatype) {
        super(value.toString(), datatype);
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.value);
    }
}

