/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public final class InValueEvaluationStep
implements QueryValueEvaluationStep {
    private final In node;
    private final QueryEvaluationStep subquery;
    private final QueryValueEvaluationStep left;

    public InValueEvaluationStep(In node, QueryEvaluationStep subquery, QueryValueEvaluationStep left) {
        this.node = node;
        this.subquery = subquery;
        this.left = left;
    }

    @Override
    public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftValue = this.left.evaluate(bindings);
        boolean result = false;
        String bindingName = this.node.getSubQuery().getBindingNames().iterator().next();
        try (CloseableIteration<BindingSet> iter = this.subquery.evaluate(bindings);){
            while (!result && iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Value rightValue = bindingSet.getValue(bindingName);
                result = leftValue == null && rightValue == null || leftValue != null && leftValue.equals(rightValue);
            }
        }
        return BooleanLiteral.valueOf(result);
    }
}

