/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.event.base;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.repository.event.NotifyingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.RepositoryConnectionListener;

public class NotifyingRepositoryConnectionWrapper
extends RepositoryConnectionWrapper
implements NotifyingRepositoryConnection {
    private boolean activated = false;
    private boolean reportDeltas = false;
    private final Set<RepositoryConnectionListener> listeners = new CopyOnWriteArraySet<RepositoryConnectionListener>();

    public NotifyingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection) {
        super(repository, connection);
    }

    public NotifyingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection, boolean reportDeltas) {
        this(repository, connection);
        this.setReportDeltas(reportDeltas);
    }

    public boolean reportDeltas() {
        return this.reportDeltas;
    }

    public void setReportDeltas(boolean reportDeltas) {
        this.reportDeltas = reportDeltas;
    }

    @Override
    public void addRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.listeners.add(listener);
        this.activated = true;
    }

    @Override
    public void removeRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.listeners.remove(listener);
        this.activated = !this.listeners.isEmpty();
    }

    protected boolean isDelegatingAdd() {
        return !this.activated;
    }

    protected boolean isDelegatingRemove() {
        return !this.activated;
    }

    public void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean reportEvent = this.activated;
        if (reportEvent && this.reportDeltas()) {
            reportEvent = !this.getDelegate().hasStatement(subject, predicate, object, false, contexts);
        }
        this.getDelegate().add(subject, predicate, object, contexts);
        if (reportEvent) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.add(this.getDelegate(), subject, predicate, object, contexts);
            }
        }
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        if (this.activated && this.reportDeltas()) {
            this.removeWithoutCommit(null, null, null, contexts);
        } else if (this.activated) {
            this.getDelegate().clear(contexts);
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.clear(this.getDelegate(), contexts);
            }
        } else {
            this.getDelegate().clear(contexts);
        }
    }

    public void close() throws RepositoryException {
        this.getDelegate().close();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.close(this.getDelegate());
            }
        }
    }

    public void commit() throws RepositoryException {
        this.getDelegate().commit();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.commit(this.getDelegate());
            }
        }
    }

    public void removeWithoutCommit(Resource subj, IRI pred, Value obj, Resource ... ctx) throws RepositoryException {
        if (this.activated && this.reportDeltas()) {
            List list;
            try (Stream stream = this.getDelegate().getStatements(subj, pred, obj, false, ctx).stream();){
                list = stream.collect(Collectors.toList());
            }
            this.getDelegate().remove(subj, pred, obj, ctx);
            for (RepositoryConnectionListener listener : this.listeners) {
                for (Statement stmt : list) {
                    Resource s = stmt.getSubject();
                    IRI p = stmt.getPredicate();
                    Value o = stmt.getObject();
                    Resource c = stmt.getContext();
                    listener.remove(this.getDelegate(), s, p, o, c);
                }
            }
        } else if (this.activated) {
            this.getDelegate().remove(subj, pred, obj, ctx);
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.remove(this.getDelegate(), subj, pred, obj, ctx);
            }
        } else {
            this.getDelegate().remove(subj, pred, obj, ctx);
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.getDelegate().removeNamespace(prefix);
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.removeNamespace(this.getDelegate(), prefix);
            }
        }
    }

    public void clearNamespaces() throws RepositoryException {
        if (this.activated && this.reportDeltas()) {
            List prefix;
            try (Stream stream = this.getDelegate().getNamespaces().stream();){
                prefix = stream.map(Namespace::getPrefix).collect(Collectors.toList());
            }
            this.getDelegate().clearNamespaces();
            for (String p : prefix) {
                this.removeNamespace(p);
            }
        } else if (this.activated) {
            this.getDelegate().clearNamespaces();
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.clearNamespaces(this.getDelegate());
            }
        } else {
            this.getDelegate().clearNamespaces();
        }
    }

    public void begin() throws RepositoryException {
        this.getDelegate().begin();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.begin(this.getDelegate());
            }
        }
    }

    public void rollback() throws RepositoryException {
        this.getDelegate().rollback();
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.rollback(this.getDelegate());
            }
        }
    }

    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        boolean wasAutoCommit = !this.isActive();
        this.getDelegate().setAutoCommit(autoCommit);
        if (this.activated && wasAutoCommit != autoCommit) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.setAutoCommit(this.getDelegate(), autoCommit);
            }
            if (autoCommit) {
                for (RepositoryConnectionListener listener : this.listeners) {
                    listener.commit(this.getDelegate());
                }
            }
        }
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.getDelegate().setNamespace(prefix, name);
        if (this.activated) {
            for (RepositoryConnectionListener listener : this.listeners) {
                listener.setNamespace(this.getDelegate(), prefix, name);
            }
        }
    }

    public Update prepareUpdate(final QueryLanguage ql, final String update, final String baseURI) throws MalformedQueryException, RepositoryException {
        if (this.activated) {
            return new Update(){
                private final RepositoryConnection conn;
                private final Update delegate;
                {
                    this.conn = NotifyingRepositoryConnectionWrapper.this.getDelegate();
                    this.delegate = this.conn.prepareUpdate(ql, update, baseURI);
                }

                public void execute() throws UpdateExecutionException {
                    this.delegate.execute();
                    if (NotifyingRepositoryConnectionWrapper.this.activated) {
                        for (RepositoryConnectionListener listener : NotifyingRepositoryConnectionWrapper.this.listeners) {
                            listener.execute(this.conn, ql, update, baseURI, this.delegate);
                        }
                    }
                }

                public void setBinding(String name, Value value) {
                    this.delegate.setBinding(name, value);
                }

                public void removeBinding(String name) {
                    this.delegate.removeBinding(name);
                }

                public void clearBindings() {
                    this.delegate.clearBindings();
                }

                public BindingSet getBindings() {
                    return this.delegate.getBindings();
                }

                public void setDataset(Dataset dataset) {
                    this.delegate.setDataset(dataset);
                }

                public Dataset getDataset() {
                    return this.delegate.getDataset();
                }

                public void setIncludeInferred(boolean includeInferred) {
                    this.delegate.setIncludeInferred(includeInferred);
                }

                public boolean getIncludeInferred() {
                    return this.delegate.getIncludeInferred();
                }

                public void setMaxExecutionTime(int maxExecutionTimeSeconds) {
                    this.delegate.setMaxExecutionTime(maxExecutionTimeSeconds);
                }

                public int getMaxExecutionTime() {
                    return this.delegate.getMaxExecutionTime();
                }
            };
        }
        return this.getDelegate().prepareUpdate(ql, update, baseURI);
    }
}

