/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import org.eclipse.rdf4j.common.exception.RDF4JException;

public class RDFParseException
extends RDF4JException {
    private static final long serialVersionUID = -4686126837948873012L;
    private final long lineNo;
    private final long columnNo;

    public RDFParseException(String msg) {
        this(msg, -1L, -1L);
    }

    public RDFParseException(String msg, long lineNo, long columnNo) {
        super(msg + RDFParseException.getLocationString(lineNo, columnNo));
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public RDFParseException(Throwable t) {
        this(t, -1L, -1L);
    }

    public RDFParseException(String msg, Throwable t) {
        this(msg, t, -1L, -1L);
    }

    public RDFParseException(Throwable t, long lineNo, long columnNo) {
        super(t.getMessage() + RDFParseException.getLocationString(lineNo, columnNo), t);
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public RDFParseException(String msg, Throwable t, long lineNo, long columnNo) {
        super(msg + RDFParseException.getLocationString(lineNo, columnNo), t);
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public long getLineNumber() {
        return this.lineNo;
    }

    public long getColumnNumber() {
        return this.columnNo;
    }

    public static String getLocationString(long lineNo, long columnNo) {
        if (lineNo < 0L) {
            return "";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(" [line ");
        sb.append(lineNo);
        if (columnNo >= 0L) {
            sb.append(", column ");
            sb.append(columnNo);
        }
        sb.append("]");
        return sb.toString();
    }
}

