/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.processor;

import jakarta.json.JsonArray;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;
import no.hasmac.jsonld.serialization.RdfToJsonld;

public final class FromRdfProcessor {
    private FromRdfProcessor() {
    }

    public static JsonArray fromRdf(Document document, JsonLdOptions options) throws JsonLdError {
        return RdfToJsonld.with(document.getRdfContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Expected RDF document but got [mediaType=" + String.valueOf(document.getContentType()) + ", uri=" + String.valueOf(document.getDocumentUrl()) + "]"))).ordered(options.isOrdered()).rdfDirection(options.getRdfDirection()).useNativeTypes(options.isUseNativeTypes()).useRdfType(options.isUseRdfType()).processingMode(options.getProcessingMode()).uriValidation(options.isUriValidation()).build();
    }

    public static JsonArray fromRdf(URI documentUri, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(documentUri) + "].");
        }
        Document remoteDocument = options.getDocumentLoader().loadDocument(documentUri, new DocumentLoaderOptions());
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return FromRdfProcessor.fromRdf(remoteDocument, options);
    }
}

