/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

@Experimental
public class AsyncIteratorDirect
extends LookAheadIteration<BindingSet> {
    private final CloseableIteration<BindingSet> iteration;
    private final ExecutorService executorService;
    private Future<ArrayDeque<BindingSet>> future;
    ArrayDeque<BindingSet> nextBuffer;
    volatile BindingSet next;

    public AsyncIteratorDirect(CloseableIteration<BindingSet> iteration) throws QueryEvaluationException {
        this.iteration = iteration;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep iterationPrepared, BindingSet bindings, QueryEvaluationContext context) {
        CloseableIteration<BindingSet> iter = iterationPrepared.evaluate(bindings);
        if (iter == QueryEvaluationStep.EMPTY_ITERATION) {
            return iter;
        }
        return new AsyncIteratorDirect(iter);
    }

    void calculateNext() {
        if (this.next != null) {
            return;
        }
        if (this.future == null) {
            try {
                this.async();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        while (!this.future.isDone() && !this.future.isCancelled() && this.next == null) {
            Thread.onSpinWait();
        }
    }

    private void async() throws ExecutionException, InterruptedException {
        this.future = this.executorService.submit(() -> {
            while (this.iteration.hasNext()) {
                while (this.next != null) {
                    Thread.onSpinWait();
                }
                this.next = (BindingSet)this.iteration.next();
            }
            return null;
        });
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        this.calculateNext();
        BindingSet temp = this.next;
        this.next = null;
        return temp;
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
        finally {
            try {
                this.executorService.shutdownNow();
            }
            finally {
                this.iteration.close();
            }
        }
    }
}

