/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResults;

public class SPARQLMinusIteration
extends FilterIteration<BindingSet> {
    private final CloseableIteration<BindingSet> rightArg;
    private boolean initialized;
    private Set<BindingSet> excludeSet;
    private Set<String> excludeSetBindingNames;
    private boolean excludeSetBindingNamesAreAllTheSame;

    public SPARQLMinusIteration(CloseableIteration<BindingSet> leftArg, CloseableIteration<BindingSet> rightArg) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.initialized = false;
    }

    @Override
    protected boolean accept(BindingSet bindingSet) {
        if (!this.initialized) {
            this.excludeSet = this.makeSet(this.getRightArg());
            this.excludeSetBindingNames = this.excludeSet.stream().map(BindingSet::getBindingNames).flatMap(Collection::stream).collect(Collectors.toSet());
            this.excludeSetBindingNamesAreAllTheSame = this.excludeSet.stream().allMatch(b -> {
                Set<String> bindingNames = b.getBindingNames();
                if (bindingNames.size() == this.excludeSetBindingNames.size()) {
                    return bindingNames.containsAll(this.excludeSetBindingNames);
                }
                return false;
            });
            this.initialized = true;
        }
        Set<String> bindingNames = bindingSet.getBindingNames();
        boolean hasSharedBindings = false;
        if (this.excludeSetBindingNamesAreAllTheSame) {
            for (String bindingName : this.excludeSetBindingNames) {
                if (!bindingNames.contains(bindingName)) continue;
                hasSharedBindings = true;
                break;
            }
            if (!hasSharedBindings) {
                return true;
            }
        }
        for (BindingSet excluded : this.excludeSet) {
            if (!this.excludeSetBindingNamesAreAllTheSame) {
                hasSharedBindings = false;
                for (String bindingName : excluded.getBindingNames()) {
                    if (!bindingNames.contains(bindingName)) continue;
                    hasSharedBindings = true;
                    break;
                }
            }
            if (!hasSharedBindings || !QueryResults.bindingSetsCompatible(excluded, bindingSet)) continue;
            return false;
        }
        return true;
    }

    protected Set<BindingSet> makeSet() {
        return new LinkedHashSet<BindingSet>();
    }

    protected Set<String> makeSet(Set<String> set) {
        return new HashSet<String>(set);
    }

    protected Set<BindingSet> makeSet(CloseableIteration<BindingSet> rightArg) {
        return Iterations.asSet(rightArg);
    }

    @Override
    protected void handleClose() {
        if (this.rightArg != null) {
            this.rightArg.close();
        }
    }

    protected CloseableIteration<BindingSet> getRightArg() {
        return this.rightArg;
    }

    protected long clearExcludeSet() {
        int size = this.excludeSet.size();
        this.excludeSet.clear();
        return size;
    }
}

