/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Map;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.Help;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsoleCommand
implements Command,
Help {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    final ConsoleIO consoleIO;
    final ConsoleState state;
    final Map<String, ConsoleSetting> settings;

    public ConsoleIO getConsoleIO() {
        return this.consoleIO;
    }

    public ConsoleState getConsoleState() {
        return this.state;
    }

    public Map<String, ConsoleSetting> getConsoleSettings() {
        return this.settings;
    }

    @Override
    public String getHelpShort() {
        return "No help available";
    }

    @Override
    public String getHelpLong() {
        return "No additional help available";
    }

    @Override
    public String[] usesSettings() {
        return new String[0];
    }

    public ConsoleCommand(ConsoleIO consoleIO) {
        this.consoleIO = consoleIO;
        this.state = null;
        this.settings = null;
    }

    public ConsoleCommand(ConsoleIO consoleIO, ConsoleState state) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.settings = null;
    }

    public ConsoleCommand(ConsoleIO consoleIO, ConsoleState state, Map<String, ConsoleSetting> settings) {
        this.consoleIO = consoleIO;
        this.state = state;
        this.settings = settings;
    }

    @Override
    public void execute(String ... parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void write(String str) {
        this.consoleIO.write(str);
    }

    protected void writeln(String str) {
        this.consoleIO.writeln(str);
    }

    protected void writeInfo(String str) {
        this.consoleIO.writeln(str);
        this.LOGGER.info(str);
    }

    protected void writeError(String str) {
        this.consoleIO.writeError(str);
        this.LOGGER.error(str);
    }

    protected void writeError(String str, Exception e) {
        this.consoleIO.writeError(str + ": " + e.getMessage());
        this.LOGGER.error(str, (Throwable)e);
    }

    protected void writeUnopenedError() {
        this.consoleIO.writeUnopenedError();
    }

    protected boolean askProceed(String str, boolean defVal) {
        return this.consoleIO.askProceed(str, defVal);
    }
}

