/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSDependency;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSIntro;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSOnCompletion;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class CompCSTaskObject
extends CompCSObject
implements ICompCSTaskObject {
    private static final long serialVersionUID = 1L;
    protected String fFieldId;
    protected String fFieldKind;
    protected ICompCSIntro fFieldIntro;
    protected ICompCSOnCompletion fFieldOnCompletion;
    protected String fFieldName;
    protected boolean fFieldSkip;
    protected List<ICompCSDependency> fFieldDependencies;

    public CompCSTaskObject(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
    }

    @Override
    public abstract List<ICompCSTaskObject> getChildren();

    @Override
    public abstract String getName();

    @Override
    public abstract int getType();

    @Override
    public void reset() {
        this.fFieldId = null;
        this.fFieldKind = null;
        this.fFieldIntro = null;
        this.fFieldOnCompletion = null;
        this.fFieldName = null;
        this.fFieldSkip = false;
        this.fFieldDependencies = new ArrayList<ICompCSDependency>();
    }

    @Override
    public void addFieldDependency(ICompCSDependency dependency) {
        this.fFieldDependencies.add(dependency);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)dependency, 1);
        }
    }

    @Override
    public String getFieldId() {
        return this.fFieldId;
    }

    @Override
    public ICompCSIntro getFieldIntro() {
        return this.fFieldIntro;
    }

    @Override
    public String getFieldKind() {
        return this.fFieldKind;
    }

    @Override
    public String getFieldName() {
        return this.fFieldName;
    }

    @Override
    public ICompCSOnCompletion getFieldOnCompletion() {
        return this.fFieldOnCompletion;
    }

    @Override
    public boolean getFieldSkip() {
        return this.fFieldSkip;
    }

    @Override
    public void removeFieldDepedency(ICompCSDependency dependency) {
        this.fFieldDependencies.remove(dependency);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)dependency, 2);
        }
    }

    @Override
    public void setFieldId(String id) {
        String old = this.fFieldId;
        this.fFieldId = id;
        if (this.isEditable()) {
            this.firePropertyChanged("id", old, this.fFieldId);
        }
    }

    @Override
    public void setFieldIntro(ICompCSIntro intro) {
        ICompCSIntro old = this.fFieldIntro;
        this.fFieldIntro = intro;
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)intro, old);
        }
    }

    @Override
    public void setFieldKind(String kind) {
        String old = this.fFieldKind;
        this.fFieldKind = kind;
        if (this.isEditable()) {
            this.firePropertyChanged("kind", old, this.fFieldKind);
        }
    }

    @Override
    public void setFieldName(String name) {
        String old = this.fFieldName;
        this.fFieldName = name;
        if (this.isEditable()) {
            this.firePropertyChanged("name", old, this.fFieldName);
        }
    }

    @Override
    public void setFieldOnCompletion(ICompCSOnCompletion onCompletion) {
        ICompCSOnCompletion old = this.fFieldOnCompletion;
        this.fFieldOnCompletion = onCompletion;
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)onCompletion, old);
        }
    }

    @Override
    public void setFieldSkip(boolean skip) {
        Boolean old = this.fFieldSkip;
        this.fFieldSkip = skip;
        if (this.isEditable()) {
            this.firePropertyChanged("skip", old, this.fFieldSkip);
        }
    }

    @Override
    public ICompCSDependency[] getFieldDependencies() {
        return this.fFieldDependencies.toArray(new ICompCSDependency[this.fFieldDependencies.size()]);
    }

    @Override
    protected void parseText(Text text) {
    }

    @Override
    protected void parseAttributes(Element element) {
        this.fFieldId = element.getAttribute("id").trim();
        this.fFieldKind = element.getAttribute("kind").trim();
        this.fFieldName = element.getAttribute("name").trim();
        if (element.getAttribute("skip").compareTo("true") == 0) {
            this.fFieldSkip = true;
        }
    }

    @Override
    protected void writeAttributes(StringBuilder buffer) {
        if (this.fFieldId != null && this.fFieldId.length() > 0) {
            buffer.append(XMLPrintHandler.wrapAttribute((String)"id", (String)PDETextHelper.translateWriteText((String)this.fFieldId.trim(), (Map)DEFAULT_SUBSTITUTE_CHARS)));
        }
        if (this.fFieldKind != null && this.fFieldKind.length() > 0) {
            buffer.append(XMLPrintHandler.wrapAttribute((String)"kind", (String)this.fFieldKind));
        }
        if (this.fFieldName != null && this.fFieldName.length() > 0) {
            buffer.append(XMLPrintHandler.wrapAttribute((String)"name", (String)PDETextHelper.translateWriteText((String)this.fFieldName.trim(), (Map)DEFAULT_SUBSTITUTE_CHARS)));
        }
        buffer.append(XMLPrintHandler.wrapAttribute((String)"skip", (String)Boolean.toString(this.fFieldSkip)));
    }

    @Override
    protected void parseElement(Element element) {
        String name = element.getNodeName();
        ICompCSModelFactory factory = this.getModel().getFactory();
        switch (name) {
            case "intro": {
                this.fFieldIntro = factory.createCompCSIntro(this);
                this.fFieldIntro.parse(element);
                break;
            }
            case "onCompletion": {
                this.fFieldOnCompletion = factory.createCompCSOnCompletion(this);
                this.fFieldOnCompletion.parse(element);
                break;
            }
            case "dependsOn": {
                ICompCSDependency dependency = factory.createCompCSDependency(this);
                this.fFieldDependencies.add(dependency);
                dependency.parse(element);
                break;
            }
        }
    }

    @Override
    protected void writeElements(String indent, PrintWriter writer) {
        String newIndent = indent + "   ";
        if (this.fFieldIntro != null) {
            this.fFieldIntro.write(newIndent, writer);
        }
        if (this.fFieldOnCompletion != null) {
            this.fFieldOnCompletion.write(newIndent, writer);
        }
        for (ICompCSDependency dependency : this.fFieldDependencies) {
            dependency.write(newIndent, writer);
        }
    }

    @Override
    public abstract String getElement();
}

