/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class WorkingSetScope
extends AbstractSynchronizeScope
implements IPropertyChangeListener {
    private static final String CTX_SETS = "workingset_scope_sets";
    private static final String CTX_SET_NAME = "workingset_scope_name";
    private IWorkingSet[] sets;

    public WorkingSetScope(IWorkingSet[] sets) {
        this.setWorkingSets(sets);
    }

    protected WorkingSetScope(IMemento memento) {
        super(memento);
    }

    protected void setWorkingSets(IWorkingSet[] sets) {
        this.sets = sets;
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public String getName() {
        if (this.sets.length == 0) {
            return TeamUIMessages.WorkingSetScope_0;
        }
        StringBuilder name = new StringBuilder();
        int i = 0;
        while (i < this.sets.length) {
            IWorkingSet set = this.sets[i];
            name.append(set.getName());
            if (i < this.sets.length - 1) {
                name.append(", ");
            }
            ++i;
        }
        return name.toString();
    }

    @Override
    public IResource[] getRoots() {
        if (this.sets.length == 0) {
            return null;
        }
        HashSet<IResource> roots = new HashSet<IResource>();
        IWorkingSet[] iWorkingSetArray = this.sets;
        int n = this.sets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            IResource[] resources = Utils.getResources(set.getElements());
            this.addNonOverlapping(roots, resources);
            ++n2;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    private void addNonOverlapping(HashSet<IResource> roots, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource newResource = iResourceArray[n2];
            boolean add = true;
            Iterator<IResource> iter = roots.iterator();
            while (iter.hasNext()) {
                IResource existingResource = iter.next();
                if (existingResource.equals((Object)newResource)) {
                    add = false;
                    break;
                }
                if (existingResource.getFullPath().isPrefixOf(newResource.getFullPath())) {
                    add = false;
                    break;
                }
                if (!newResource.getFullPath().isPrefixOf(existingResource.getFullPath())) continue;
                iter.remove();
            }
            if (add) {
                roots.add(newResource);
            }
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "workingSetContentChange") {
            IWorkingSet newSet = (IWorkingSet)event.getNewValue();
            IWorkingSet[] iWorkingSetArray = this.sets;
            int n = this.sets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet set = iWorkingSetArray[n2];
                if (newSet == set) {
                    this.fireRootsChanges();
                    return;
                }
                ++n2;
            }
        } else if (event.getProperty() == "workingSetNameChange") {
            this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "prop_name", null, event.getNewValue()));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        IWorkingSet[] iWorkingSetArray = this.sets;
        int n = this.sets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            IMemento rootNode = memento.createChild(CTX_SETS);
            rootNode.putString(CTX_SET_NAME, set.getName());
            ++n2;
        }
    }

    @Override
    protected void init(IMemento memento) {
        super.init(memento);
        IMemento[] rootNodes = memento.getChildren(CTX_SETS);
        if (rootNodes != null) {
            ArrayList<IWorkingSet> sets = new ArrayList<IWorkingSet>();
            IMemento[] iMementoArray = rootNodes;
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento rootNode = iMementoArray[n2];
                String setName = rootNode.getString(CTX_SET_NAME);
                IWorkingSet set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setName);
                if (set != null) {
                    sets.add(set);
                }
                ++n2;
            }
            this.setWorkingSets(sets.toArray(new IWorkingSet[sets.size()]));
        }
    }
}

