/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.internal.ui.launchConfigurations.SelectFavoritesDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FavoritesDialog
extends TrayDialog {
    private TableViewer fFavoritesTable;
    private final LaunchHistory fHistory;
    private List<ILaunchConfiguration> fFavorites;
    protected Button fAddFavoriteButton;
    protected Button fRemoveFavoritesButton;
    protected Button fMoveUpButton;
    protected Button fMoveDownButton;
    private final SelectionAdapter fButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == FavoritesDialog.this.fAddFavoriteButton) {
                FavoritesDialog.this.handleAddConfigButtonSelected();
            } else if (button == FavoritesDialog.this.fRemoveFavoritesButton) {
                FavoritesDialog.this.removeSelectedFavorites();
            } else if (button == FavoritesDialog.this.fMoveUpButton) {
                FavoritesDialog.this.handleMoveUpButtonSelected();
            } else if (button == FavoritesDialog.this.fMoveDownButton) {
                FavoritesDialog.this.handleMoveDownButtonSelected();
            }
        }
    };
    private final ISelectionChangedListener fSelectionChangedListener = event -> this.handleFavoriteSelectionChanged();
    private final KeyListener fKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.character == '\u007f' && event.stateMask == 0) {
                FavoritesDialog.this.removeSelectedFavorites();
            }
        }
    };

    public FavoritesDialog(Shell parentShell, LaunchHistory history) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fHistory = history;
    }

    protected void handleAddConfigButtonSelected() {
        SelectFavoritesDialog sfd = new SelectFavoritesDialog(this.fFavoritesTable.getControl().getShell(), this.getLaunchHistory(), this.getFavorites());
        sfd.open();
        Object[] selection = sfd.getResult();
        if (selection != null) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                this.getFavorites().add((ILaunchConfiguration)s);
                ++n2;
            }
            this.updateStatus();
        }
    }

    protected void removeSelectedFavorites() {
        IStructuredSelection sel = this.getFavoritesTable().getStructuredSelection();
        for (Object config : sel) {
            this.getFavorites().remove(config);
        }
        this.getFavoritesTable().refresh();
    }

    protected void handleMoveUpButtonSelected() {
        this.handleMove(-1);
    }

    protected Point getInitialSize() {
        return new Point(450, 500);
    }

    protected void handleMoveDownButtonSelected() {
        this.handleMove(1);
    }

    protected void handleMove(int direction) {
        IStructuredSelection sel = this.getFavoritesTable().getStructuredSelection();
        List selList = sel.toList();
        Object[] movedFavs = new Object[this.getFavorites().size()];
        for (Object config : selList) {
            int i = this.getFavorites().indexOf(config);
            movedFavs[i + direction] = config;
        }
        this.getFavorites().removeAll(selList);
        int j = 0;
        while (j < movedFavs.length) {
            Object config = movedFavs[j];
            if (config != null) {
                this.getFavorites().add(j, (ILaunchConfiguration)config);
            }
            ++j;
        }
        this.getFavoritesTable().refresh();
        this.handleFavoriteSelectionChanged();
    }

    protected TableViewer getFavoritesTable() {
        return this.fFavoritesTable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(MessageFormat.format(LaunchConfigurationsMessages.FavoritesDialog_1, this.getModeLabel()));
        this.createFavoritesArea(composite);
        this.handleFavoriteSelectionChanged();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getDialogArea(), "org.eclipse.debug.ui.organize_favorites_dialog_context");
        return contents;
    }

    private String getModeLabel() {
        return DebugUIPlugin.removeAccelerators(this.fHistory.getLaunchGroup().getLabel());
    }

    protected void createFavoritesArea(Composite parent) {
        Composite topComp = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 1808, 0, 0);
        SWTFactory.createLabel(topComp, LaunchConfigurationsMessages.FavoritesDialog_2, 2);
        this.fFavoritesTable = this.createTable(topComp, (IContentProvider)new FavoritesContentProvider());
        Composite buttonComp = SWTFactory.createComposite(topComp, topComp.getFont(), 1, 1, 2, 0, 0);
        this.fAddFavoriteButton = SWTFactory.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_3, null);
        this.fAddFavoriteButton.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fAddFavoriteButton.setEnabled(true);
        this.fRemoveFavoritesButton = SWTFactory.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_4, null);
        this.fRemoveFavoritesButton.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fMoveUpButton = SWTFactory.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_5, null);
        this.fMoveUpButton.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fMoveDownButton = SWTFactory.createPushButton(buttonComp, LaunchConfigurationsMessages.FavoritesDialog_6, null);
        this.fMoveDownButton.addSelectionListener((SelectionListener)this.fButtonListener);
    }

    private TableViewer createTable(Composite parent, IContentProvider contentProvider) {
        TableViewer tableViewer = new TableViewer(parent, 67586);
        tableViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        tableViewer.setContentProvider(contentProvider);
        tableViewer.setInput((Object)DebugUIPlugin.getDefault());
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 100;
        tableViewer.getTable().setLayoutData((Object)gd);
        tableViewer.getTable().setFont(parent.getFont());
        tableViewer.addSelectionChangedListener(this.fSelectionChangedListener);
        tableViewer.getControl().addKeyListener(this.fKeyListener);
        return tableViewer;
    }

    protected List<ILaunchConfiguration> getFavorites() {
        if (this.fFavorites == null) {
            ILaunchConfiguration[] favs = this.getInitialFavorites();
            this.fFavorites = new ArrayList<ILaunchConfiguration>(favs.length);
            this.addAll(favs, this.fFavorites);
        }
        return this.fFavorites;
    }

    protected LaunchHistory getLaunchHistory() {
        return this.fHistory;
    }

    protected ILaunchConfiguration[] getInitialFavorites() {
        return this.getLaunchHistory().getFavorites();
    }

    protected String getMode() {
        return this.getLaunchHistory().getLaunchGroup().getMode();
    }

    protected void addAll(ILaunchConfiguration[] array, List<ILaunchConfiguration> list) {
        Collections.addAll(list, array);
    }

    protected void updateStatus() {
        this.getFavoritesTable().refresh();
        this.handleFavoriteSelectionChanged();
    }

    protected void handleFavoriteSelectionChanged() {
        IStructuredSelection selection = this.getFavoritesTable().getStructuredSelection();
        List<ILaunchConfiguration> favs = this.getFavorites();
        boolean notEmpty = !selection.isEmpty();
        Iterator elements = selection.iterator();
        boolean first = false;
        boolean last = false;
        int lastFav = favs.size() - 1;
        while (elements.hasNext()) {
            Object element = elements.next();
            if (!first && favs.indexOf(element) == 0) {
                first = true;
            }
            if (last || favs.indexOf(element) != lastFav) continue;
            last = true;
        }
        this.fRemoveFavoritesButton.setEnabled(notEmpty);
        this.fMoveUpButton.setEnabled(notEmpty && !first);
        this.fMoveDownButton.setEnabled(notEmpty && !last);
    }

    public void saveFavorites() {
        Job job = new Job(LaunchConfigurationsMessages.FavoritesDialog_8){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunchConfiguration[] initial = FavoritesDialog.this.getInitialFavorites();
                List<ILaunchConfiguration> current = FavoritesDialog.this.getFavorites();
                String groupId = FavoritesDialog.this.getLaunchHistory().getLaunchGroup().getIdentifier();
                int taskSize = Math.abs(initial.length - current.size());
                monitor.beginTask(LaunchConfigurationsMessages.FavoritesDialog_8, taskSize);
                ILaunchConfiguration[] iLaunchConfigurationArray = initial;
                int n = initial.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    if (!current.contains(configuration)) {
                        try {
                            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                            workingCopy.setAttribute("org.eclipse.debug.ui.debugFavorite", null);
                            workingCopy.setAttribute("org.eclipse.debug.ui.debugFavorite", null);
                            List groups = workingCopy.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                            if (groups != null) {
                                groups.remove(groupId);
                                if (groups.isEmpty()) {
                                    groups = null;
                                }
                                workingCopy.setAttribute("org.eclipse.debug.ui.favoriteGroups", groups);
                            }
                            workingCopy.doSave();
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
                for (ILaunchConfiguration configuration : current) {
                    try {
                        ArrayList<String> groups = configuration.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                        if (groups == null) {
                            groups = new ArrayList<String>();
                        }
                        if (!groups.contains(groupId)) {
                            groups.add(groupId);
                            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                            workingCopy.setAttribute("org.eclipse.debug.ui.favoriteGroups", groups);
                            workingCopy.doSave();
                        }
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(1);
                }
                FavoritesDialog.this.fHistory.setFavorites(FavoritesDialog.this.getArray(current));
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        PlatformUI.getWorkbench().getProgressService().showInDialog(this.getParentShell(), job);
        job.schedule();
    }

    protected ILaunchConfiguration[] getArray(List<ILaunchConfiguration> list) {
        return list.toArray(new ILaunchConfiguration[list.size()]);
    }

    protected void okPressed() {
        this.saveFavorites();
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FavoritesDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    private String getDialogSettingsSectionName() {
        return "FAVORITES_DIALOG_SECTION";
    }

    protected class FavoritesContentProvider
    implements IStructuredContentProvider {
        protected FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchConfiguration[] favorites = FavoritesDialog.this.getFavorites().toArray(new ILaunchConfiguration[0]);
            return LaunchConfigurationManager.filterConfigs(favorites);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

