/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.AbstractNLModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.IHeader;
import org.eclipse.pde.internal.core.builders.IncrementalErrorReporter;
import org.eclipse.pde.internal.core.builders.JarManifestErrorReporter;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;

public class BundleErrorReporter
extends JarManifestErrorReporter {
    private boolean fOsgiR4;
    private IPluginModelBase fModel;
    private Set<String> fProjectPackages;
    private static final List<String> EXECUTION_ENVIRONMENT_NAMES = List.of("OSGi/Minimum", "CDC-1.0/Foundation", "CDC-1.1/Foundation", "JRE", "J2SE", "JavaSE");
    private static final Pattern EE_PATTERN = Pattern.compile("(.*)-(\\d+)\\.?(\\d+)?(.*)?");

    public BundleErrorReporter(IFile file) {
        super(file);
    }

    @Override
    protected void validate(IProgressMonitor monitor) {
        super.validate(monitor);
        if (this.fHeaders == null || this.getErrorCount() > 0) {
            return;
        }
        this.fModel = PluginRegistry.findModel(this.fProject);
        if (this.fModel == null || !this.validateBundleSymbolicName()) {
            return;
        }
        if (PluginProject.isJavaProject(this.fProject)) {
            this.validateAutomaticModuleName();
        }
        if (!this.validateVersionOfRequireBundle()) {
            return;
        }
        if (!this.validateVersionOfImportPackage()) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null && this.fModel.getInstallLocation() != null) {
            try {
                StateObjectFactory stateObjectFactory = BundleHelper.getPlatformAdmin().getFactory();
                File bundleLocation = new File(this.fModel.getInstallLocation());
                Map<String, String> manifest = ManifestUtils.loadManifest(bundleLocation);
                TargetWeaver.weaveManifest(manifest, bundleLocation);
                Hashtable<String, String> dictionaryManifest = new Hashtable<String, String>(manifest);
                stateObjectFactory.createBundleDescription(null, dictionaryManifest, null, 1L);
            }
            catch (BundleException e) {
                if (e.getType() == 3) {
                    String msg = e.getMessage();
                    String[] splitArray = msg.split(":");
                    String firstString = splitArray[0];
                    String[] splitToken = firstString.split(" ");
                    String lastString = splitToken[splitToken.length - 1];
                    IHeader header = null;
                    header = this.getHeader(lastString);
                    int line = header == null ? 1 : header.getLineNumber();
                    this.report(e.getMessage(), line, 0, "fatal");
                    return;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.validateFragmentHost();
        this.validateBundleVersion();
        this.validateRequiredExecutionEnvironment();
        this.validateEclipsePlatformFilter();
        this.validateBundleActivator();
        this.validateBundleClasspath();
        this.validateRequireBundle(monitor);
        this.validateImportPackage(monitor);
        this.validateExportPackage(monitor);
        this.validateExportPackages();
        this.validateAutoStart();
        this.validateLazyStart();
        this.validateBundleActivatorPolicy();
        this.validateExtensibleAPI();
        this.validateTranslatableHeaders();
        this.validateImportExportServices();
        this.validateBundleLocalization();
        this.validateProvidePackage();
        this.validateEclipseBundleShape();
        this.validateEclipseGenericCapability();
        this.validateEclipseGenericRequire();
        this.validateServiceComponent();
        if (this.isCheckDeprecated()) {
            this.validateDeprecated();
        }
    }

    private void validateDeprecated() {
        BundleSpecification[] requiredBundles;
        IHeader header = this.getHeader("Require-Bundle");
        if (header == null) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            return;
        }
        BundleSpecification[] bundleSpecificationArray = requiredBundles = desc.getRequiredBundles();
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String deprecatedDirective;
            BundleCapability capability;
            BundleSpecification bundleSpecification = bundleSpecificationArray[n2];
            BaseDescription bundle = bundleSpecification.getSupplier();
            if (bundle != null && (capability = bundle.getCapability()) != null && (deprecatedDirective = (String)capability.getDirectives().get("deprecated")) != null) {
                this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecatedBundle, (Object)bundle.getName(), (Object)deprecatedDirective), header.getLineNumber(), 1, "deprecation");
            }
            ++n2;
        }
    }

    private void validateAutomaticModuleName() {
        IHeader header;
        int compilerFlag = CompilerFlags.getFlag(this.fProject, "compilers.p.no.automatic.module");
        if (compilerFlag == 2) {
            return;
        }
        IJavaProject jp = JavaCore.create((IProject)this.fProject);
        IModuleDescription moduleDescription = null;
        if (jp != null) {
            try {
                moduleDescription = jp.getModuleDescription();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        if (moduleDescription == null && (header = (IHeader)this.fHeaders.get("Automatic-Module-Name".toLowerCase())) == null) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_headerMissingAutoModule, (Object)"Automatic-Module-Name"), 1, "compilers.p.no.automatic.module", 4136, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.no.automatic.module");
        }
        if (moduleDescription != null && (header = (IHeader)this.fHeaders.get("Automatic-Module-Name".toLowerCase())) != null) {
            this.report(PDECoreMessages.BundleErrorReporter_ConflictingAutoModule, header.getLineNumber(), 1, 4144, "");
        }
    }

    private boolean validateBundleManifestVersion() {
        String version;
        IHeader header = this.getHeader("Bundle-ManifestVersion");
        if (header != null && !(this.fOsgiR4 = "2".equals(version = header.getValue())) && !"1".equals(version)) {
            this.report(PDECoreMessages.BundleErrorReporter_illegalManifestVersion, header.getLineNumber(), 0, "fatal");
            return false;
        }
        return true;
    }

    private void validateExportPackages() {
        IHeader header = this.getHeader("Export-Package");
        IPluginModelBase iPluginModelBase = this.fModel;
        if (iPluginModelBase instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase bundleModel = (IBundlePluginModelBase)iPluginModelBase;
            IBundle bundle = bundleModel.getBundleModel().getBundle();
            IManifestHeader bundleClasspathheader = bundle.getManifestHeader("Bundle-ClassPath");
            IPackageFragmentRoot[] roots = ManifestUtils.findPackageFragmentRoots(bundleClasspathheader, this.fProject);
            StringBuilder packages = new StringBuilder();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    try {
                        if (!ManifestUtils.isImmediateRoot(root)) break block9;
                        IJavaElement[] javaElements = root.getChildren();
                        int j = 0;
                        while (j < javaElements.length) {
                            IPackageFragment fragment;
                            String name;
                            IJavaElement iJavaElement = javaElements[j];
                            if (iJavaElement instanceof IPackageFragment && (name = (fragment = (IPackageFragment)iJavaElement).getElementName()).length() != 0 && (fragment.containsJavaResources() || fragment.getNonJavaResources().length > 0) && !this.isInternalPackage(name) && !this.containsPackage(header, name)) {
                                packages.append(name);
                                packages.append(",");
                                byte[] bytes = packages.toString().getBytes(StandardCharsets.UTF_8);
                                if (bytes.length > 65535) {
                                    packages.delete(packages.lastIndexOf(name), packages.length());
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (packages.toString().length() > 0 && packages.substring(packages.length() - 1).equals(",")) {
                packages.setLength(packages.length() - 1);
            }
            if (packages.toString().length() > 0) {
                IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_missingPackagesInProject, header == null ? 1 : header.getLineNumber(), "compilers.p.missing-packages", 4120, "");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.missing-packages");
                this.addMarkerAttribute(marker, "packages", packages.toString());
            }
        }
    }

    private boolean isInternalPackage(String name) {
        String[] split;
        String[] stringArray = split = name.split("\\.");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            if (section.equals("internal") || section.equals("impl")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean validateBundleSymbolicName() {
        String id;
        IHeader header = this.validateRequiredHeader("Bundle-SymbolicName");
        if (header == null) {
            return false;
        }
        ManifestElement[] elements = header.getElements();
        String string = id = elements.length > 0 ? elements[0].getValue() : null;
        if (id == null || id.length() == 0) {
            this.report(PDECoreMessages.BundleErrorReporter_NoSymbolicName, header.getLineNumber(), 0, "fatal");
            return false;
        }
        if (!this.validateBundleManifestVersion()) {
            return false;
        }
        this.validatePluginId(header, id);
        this.validateSingleton(header, elements[0]);
        if (!this.fOsgiR4) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_R4SyntaxInR3Bundle, (Object)"Bundle-SymbolicName"), header.getLineNumber(), 1, 4133, "");
        }
        return true;
    }

    private boolean validateVersionOfRequireBundle() {
        ManifestElement[] required;
        IHeader header = this.getHeader("Require-Bundle");
        if (header == null) {
            return true;
        }
        ManifestElement[] manifestElementArray = required = header.getElements();
        int n = required.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            String versionRange = element.getAttribute("bundle-version");
            if (versionRange != null) {
                try {
                    new VersionRange(versionRange);
                }
                catch (IllegalArgumentException e) {
                    this.report(e.getMessage(), this.getLine(header, element.getValue()), 0, "fatal");
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean validateVersionOfImportPackage() {
        ManifestElement[] importPackages;
        IHeader header = this.getHeader("Import-Package");
        if (header == null) {
            return true;
        }
        ManifestElement[] manifestElementArray = importPackages = header.getElements();
        int n = importPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            String versionRange = element.getAttribute("version");
            if (versionRange != null) {
                try {
                    new VersionRange(versionRange);
                }
                catch (IllegalArgumentException e) {
                    this.report(e.getMessage(), this.getLine(header, element.getValue()), 0, "fatal");
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean validatePluginId(IHeader header, String value) {
        if (!IdUtil.isValidCompositeID3_0(value)) {
            String message = PDECoreMessages.BundleErrorReporter_InvalidSymbolicName;
            this.report(message, this.getLine(header, value), 0, "fatal");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void validateSingleton(IHeader header, ManifestElement element) {
        block8: {
            block9: {
                block10: {
                    singletonAttr = element.getAttribute("singleton");
                    singletonDir = element.getDirective("singleton");
                    base = this.fModel.getPluginBase();
                    v0 = hasExtensions = base != null && PDEProject.getPluginXml(this.fProject).exists() != false;
                    if (!hasExtensions) break block8;
                    if (!(TargetPlatformHelper.getTargetVersion() >= 3.1)) break block9;
                    if ("true".equals(singletonDir)) break block8;
                    if (!"true".equals(singletonAttr)) break block10;
                    if (this.isCheckDeprecated() && this.fOsgiR4) {
                        message = PDECoreMessages.BundleErrorReporter_deprecated_attribute_singleton;
                        marker = this.report(message, this.getLine(header, "singleton="), "compilers.p.deprecated", 4099, "deprecation");
                        this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
                        return;
                    }
                    break block8;
                }
                attrKeys = element.getDirectiveKeys();
                length = 0;
                key = null;
                if (true) ** GOTO lbl43
            }
            if (!"true".equals(singletonAttr)) {
                message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonAttrRequired, (Object)"singleton");
                this.report(message, header.getLineNumber(), 0, 4100, "");
                return;
            }
        }
        if (this.fOsgiR4) {
            if (singletonAttr != null && this.isCheckDeprecated()) {
                message = PDECoreMessages.BundleErrorReporter_deprecated_attribute_singleton;
                marker = this.report(message, this.getLine(header, "singleton="), "compilers.p.deprecated", 4099, "");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            }
        } else if (singletonDir != null && this.isCheckDeprecated()) {
            message = PDECoreMessages.BundleErrorReporter_unsupportedSingletonDirective;
            marker = this.report(message, this.getLine(header, "singleton:="), "compilers.p.deprecated", 4113, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
        }
        this.validateBooleanAttributeValue(header, element, "singleton");
        this.validateBooleanDirectiveValue(header, element, "singleton");
        return;
        do {
            key = (String)attrKeys.nextElement();
            ++length;
lbl43:
            // 2 sources

        } while (attrKeys.hasMoreElements());
        if (length == 1) {
            message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonRequired, (Object)"singleton");
            marker = this.report(message, header.getLineNumber(), 0, 4147, "fatal");
            this.addMarkerAttribute(marker, "userDirective", key);
            return;
        }
        message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_singletonRequired, (Object)"singleton");
        this.report(message, header.getLineNumber(), 0, 4099, "fatal");
    }

    private void validateFragmentHost() {
        IPluginModelBase model;
        IHeader header = this.getHeader("Fragment-Host");
        if (header == null) {
            if (this.isCheckNoRequiredAttr() && PDEProject.getFragmentXml(this.fProject).exists()) {
                IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_HostNeeded, 1, "compilers.p.no-required-att", "fatal");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.no-required-att");
            }
            return;
        }
        if (header.getElements().length == 0) {
            if (this.isCheckNoRequiredAttr()) {
                IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_HostNeeded, 1, "compilers.p.no-required-att", "fatal");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.no-required-att");
            }
            return;
        }
        if (!this.fOsgiR4) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_R4SyntaxInR3Bundle, (Object)"Fragment-Host"), header.getLineNumber(), 1, 4133, "");
        }
        if (!this.isCheckUnresolvedImports()) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            ManifestElement[] elems = header.getElements();
            if (elems.length > 0 && !VersionUtil.validateVersionRange(elems[0].getAttribute("bundle-version")).isOK()) {
                int line = this.getLine(header, header.getValue());
                IncrementalErrorReporter.VirtualMarker marker = this.report(UtilMessages.BundleErrorReporter_InvalidFormatInBundleVersion, line, 0, "fatal");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
            }
            return;
        }
        HostSpecification host = desc.getHost();
        if (host == null) {
            return;
        }
        String name = host.getName();
        if (host.getSupplier() == null) {
            ResolverError[] errors;
            boolean missingHost = false;
            ResolverError[] resolverErrorArray = errors = desc.getContainingState().getResolverErrors(desc);
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverError error = resolverErrorArray[n2];
                if (error.getType() == 4) {
                    missingHost = true;
                    break;
                }
                ++n2;
            }
            if (missingHost) {
                BundleDescription[] suppliers = desc.getContainingState().getBundles(name);
                boolean resolved = true;
                BundleDescription[] bundleDescriptionArray = suppliers;
                int n3 = suppliers.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription supplier = bundleDescriptionArray[n4];
                    if (supplier.getHost() == null) {
                        if (supplier.isResolved()) {
                            Version version = supplier.getVersion();
                            if (!host.getVersionRange().includes(version)) {
                                String versionRange = host.getVersionRange().toString();
                                this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_BundleRangeInvalidInBundleVersion, (Object)versionRange), this.getLine(header, versionRange), "compilers.p.unresolved-import", "fatal");
                                return;
                            }
                        } else {
                            resolved = false;
                        }
                    }
                    ++n4;
                }
                if (!resolved) {
                    IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unresolvedHost, (Object)name), this.getLine(header, name), "compilers.p.unresolved-import", "fatal");
                    this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
                    return;
                }
            }
        }
        if ((model = PluginRegistry.findModel(name)) == null || model instanceof IFragmentModel || !model.isEnabled()) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_HostNotExistPDE, (Object)name), this.getLine(header, name), "compilers.p.unresolved-import", "fatal");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
        }
    }

    private void validateBundleVersion() {
        IHeader header = this.validateRequiredHeader("Bundle-Version");
        if (header == null) {
            return;
        }
        IStatus status = VersionUtil.validateVersion(header.getValue());
        if (!status.isOK()) {
            int line = this.getLine(header, header.getValue());
            this.report(status.getMessage(), line, 0, "fatal");
        }
    }

    private void validateRequiredExecutionEnvironment() {
        IncrementalErrorReporter.VirtualMarker marker;
        int n;
        int currentPath2;
        String[] marker22;
        int sev = CompilerFlags.getFlag(this.fProject, "compilers.incompatible-environment");
        if (sev == 2) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            return;
        }
        if (!PluginProject.isJavaProject(this.fProject)) {
            return;
        }
        String[] bundleEnvs = desc.getExecutionEnvironments();
        if (bundleEnvs == null || bundleEnvs.length == 0) {
            IPath currentPath2;
            int n2;
            IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
            if (javaProject.exists()) {
                try {
                    IClasspathEntry[] entries;
                    IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
                    n2 = entries.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IClasspathEntry entry = iClasspathEntryArray[n3];
                        if (entry.getEntryKind() == 5) {
                            String eeId;
                            currentPath2 = entry.getPath();
                            if (JavaRuntime.newDefaultJREContainerPath().matchingFirstSegments(currentPath2) > 0 && (eeId = JavaRuntime.getExecutionEnvironmentId((IPath)currentPath2)) != null) {
                                IncrementalErrorReporter.VirtualMarker marker3 = this.report(PDECoreMessages.BundleErrorReporter_noExecutionEnvironmentSet, 1, sev, 4128, "ee");
                                this.addMarkerAttribute(marker3, "ee_id", eeId);
                                this.addMarkerAttribute(marker3, "compilerKey", "compilers.incompatible-environment");
                                return;
                            }
                        }
                        ++n3;
                    }
                }
                catch (JavaModelException e) {
                    PDECore.log(e);
                }
            }
            IPath systemEnvs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            IVMInstall vm = JavaRuntime.getDefaultVMInstall();
            if (javaProject.exists()) {
                try {
                    vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
            }
            if (vm != null) {
                currentPath2 = systemEnvs;
                int n4 = ((IExecutionEnvironment[])currentPath2).length;
                n2 = 0;
                while (n2 < n4) {
                    IExecutionEnvironment systemEnv = currentPath2[n2];
                    if (systemEnv.isStrictlyCompatible(vm)) {
                        IncrementalErrorReporter.VirtualMarker marker22 = this.report(PDECoreMessages.BundleErrorReporter_noExecutionEnvironmentSet, 1, sev, 4128, "ee");
                        this.addMarkerAttribute(marker22, "ee_id", systemEnv.getId());
                        this.addMarkerAttribute(marker22, "compilerKey", "compilers.incompatible-environment");
                        break;
                    }
                    ++n2;
                }
            }
            return;
        }
        IHeader header = this.getHeader("Bundle-RequiredExecutionEnvironment");
        if (header == null) {
            return;
        }
        IExecutionEnvironment env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(bundleEnvs[0]);
        if (env != null) {
            IJavaProject jproject = JavaCore.create((IProject)this.fProject);
            try {
                IClasspathEntry[] entries = jproject.getRawClasspath();
                marker22 = entries;
                currentPath2 = entries.length;
                n = 0;
                while (n < currentPath2) {
                    String entry = marker22[n];
                    if (entry.getEntryKind() == 5) {
                        IVMInstall vm;
                        IPath validPath;
                        IPath currentPath3 = entry.getPath();
                        if (!(JavaRuntime.newDefaultJREContainerPath().matchingFirstSegments(currentPath3) == 0 || (validPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env)).equals((Object)currentPath3) || (vm = JavaRuntime.getVMInstall((IPath)currentPath3)) != null && env.isStrictlyCompatible(vm))) {
                            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                            IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
                            String systemEE = null;
                            IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
                            int n5 = environments.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IExecutionEnvironment environment = iExecutionEnvironmentArray[n6];
                                if (environment.isStrictlyCompatible(vm)) {
                                    systemEE = environment.getId();
                                    break;
                                }
                                ++n6;
                            }
                            IncrementalErrorReporter.VirtualMarker marker4 = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_reqExecEnv_conflict, (Object)bundleEnvs[0]), this.getLine(header, bundleEnvs[0]), sev, 4115, "ee");
                            this.addMarkerAttribute(marker4, "compilerKey", "compilers.incompatible-environment");
                            if (systemEE != null) {
                                this.addMarkerAttribute(marker4, "BREE", systemEE);
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (JavaModelException entry) {
                // empty catch block
            }
        }
        IExecutionEnvironment[] systemEnvs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int numInvalidExecEnv = 0;
        marker22 = bundleEnvs;
        currentPath2 = bundleEnvs.length;
        n = 0;
        while (n < currentPath2) {
            String bundleEnv = marker22[n];
            boolean found = false;
            IExecutionEnvironment[] iExecutionEnvironmentArray = systemEnvs;
            int n7 = systemEnvs.length;
            int n8 = 0;
            while (n8 < n7) {
                IExecutionEnvironment systemEnv = iExecutionEnvironmentArray[n8];
                if (bundleEnv.equals(systemEnv.getId())) {
                    found = true;
                    break;
                }
                ++n8;
            }
            if (!found) {
                ++numInvalidExecEnv;
                marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_reqExecEnv_unknown, (Object)bundleEnv), this.getLine(header, bundleEnv), sev, 4116, "ee");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.incompatible-environment");
                break;
            }
            ++n;
        }
        if (numInvalidExecEnv == bundleEnvs.length) {
            return;
        }
        int compilerFlag = CompilerFlags.getFlag(this.fProject, "compilers.p.exec-env-too-low");
        if (compilerFlag != 2) {
            ArrayList<Object> checkBREE = this.checkBREE(desc);
            String highestDependencyEE = checkBREE.size() > 0 ? (String)checkBREE.get(0) : "";
            String highestBundleEE = this.getHighestBREE(bundleEnvs);
            try {
                if (highestBundleEE != BundleErrorReporter.getHighestEE(highestDependencyEE, highestBundleEE)) {
                    BundleDescription object = null;
                    if (checkBREE.size() == 2) {
                        object = (BundleDescription)checkBREE.get(1);
                    }
                    marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_ExecEnv_tooLow, (Object)highestDependencyEE, (Object)(object != null ? object.getName() : "")), this.getLine(header, highestBundleEE), compilerFlag, 4137, "ee");
                    this.addMarkerAttribute(marker, "compilerKey", "compilers.p.exec-env-too-low");
                    this.addMarkerAttribute(marker, "executionEnvironment.key", highestDependencyEE);
                }
            }
            catch (Exception e) {
                PDECore.log(e);
            }
            checkBREE.clear();
        }
    }

    private static String getHighestEE(String execEnv1, String execEnv2) throws IllegalArgumentException {
        if (execEnv1 == null) {
            return execEnv2;
        }
        if (execEnv2 == null) {
            return execEnv1;
        }
        Matcher eeMatcher1 = EE_PATTERN.matcher(execEnv1);
        Matcher eeMatcher2 = EE_PATTERN.matcher(execEnv2);
        if (!eeMatcher1.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid Execution Environment", execEnv1));
        }
        if (!eeMatcher2.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid Execution Environment", execEnv2));
        }
        String eeName1 = eeMatcher1.group(1);
        String eeName2 = eeMatcher2.group(1);
        int eeNameIndex1 = EXECUTION_ENVIRONMENT_NAMES.indexOf(eeName1);
        int eeNameIndex2 = EXECUTION_ENVIRONMENT_NAMES.indexOf(eeName2);
        int eeMajorVersion1 = Integer.parseInt(eeMatcher1.group(2));
        int eeMajorVersion2 = Integer.parseInt(eeMatcher2.group(2));
        Integer eeMinorVersion1 = null;
        Integer eeMinorVersion2 = null;
        if (eeMatcher1.groupCount() > 2 && eeMatcher1.group(3) != null) {
            eeMinorVersion1 = Integer.valueOf(eeMatcher1.group(3));
        }
        if (eeMatcher2.groupCount() > 2 && eeMatcher2.group(3) != null) {
            eeMinorVersion2 = Integer.valueOf(eeMatcher2.group(3));
        }
        if (eeNameIndex1 > eeNameIndex2) {
            return execEnv1;
        }
        if (eeNameIndex1 < eeNameIndex2) {
            return execEnv2;
        }
        if (eeMajorVersion1 > eeMajorVersion2) {
            return execEnv1;
        }
        if (eeMajorVersion1 < eeMajorVersion2) {
            return execEnv2;
        }
        if (eeMinorVersion1 != null && eeMinorVersion2 != null) {
            if (eeMinorVersion1 > eeMinorVersion2) {
                return execEnv1;
            }
            if (eeMinorVersion1 < eeMinorVersion2) {
                return execEnv2;
            }
        }
        return execEnv1;
    }

    private String getHighestBREE(String[] executionEnvironments) {
        if (executionEnvironments.length == 0) {
            return null;
        }
        String highestExecEnv = executionEnvironments[0];
        if (executionEnvironments.length > 1) {
            String[] stringArray = executionEnvironments;
            int n = executionEnvironments.length;
            int n2 = 0;
            while (n2 < n) {
                String execEnv = stringArray[n2];
                try {
                    highestExecEnv = BundleErrorReporter.getHighestEE(highestExecEnv, execEnv);
                }
                catch (Exception e) {
                    PDECore.log(e);
                    return null;
                }
                ++n2;
            }
        }
        return highestExecEnv;
    }

    private ArrayList<Object> checkBREE(BundleDescription desc) {
        ArrayList<Object> ret = new ArrayList<Object>();
        String highestBREE = this.getHighestBREE(desc.getExecutionEnvironments());
        ret.add(highestBREE);
        HashSet<BundleDescription> visitedBundles = new HashSet<BundleDescription>();
        ArrayDeque<BundleDescription> bundleDescriptions = new ArrayDeque<BundleDescription>();
        bundleDescriptions.push(desc);
        while (!bundleDescriptions.isEmpty()) {
            BundleDescription dependencyDesc = (BundleDescription)bundleDescriptions.pop();
            visitedBundles.add(dependencyDesc);
            BundleSpecification[] bundleSpecificationArray = dependencyDesc.getRequiredBundles();
            int n = bundleSpecificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification transitiveDependencyDesc = bundleSpecificationArray[n2];
                if (!transitiveDependencyDesc.isOptional() && !visitedBundles.contains(transitiveDependencyDesc.getSupplier()) && transitiveDependencyDesc.getSupplier() instanceof BundleDescription) {
                    bundleDescriptions.push((BundleDescription)transitiveDependencyDesc.getSupplier());
                }
                ++n2;
            }
            try {
                String high = BundleErrorReporter.getHighestEE(highestBREE, this.getHighestBREE(dependencyDesc.getExecutionEnvironments()));
                if (high.equals(highestBREE)) continue;
                highestBREE = high;
                ret.clear();
                ret.add(highestBREE);
                ret.add(dependencyDesc);
            }
            catch (Exception e) {
                PDECore.log(e);
            }
        }
        return ret;
    }

    private void validateEclipseBundleShape() {
        IHeader header = this.getHeader("Eclipse-BundleShape");
        if (header == null) {
            return;
        }
        String value = header.getValue();
        if (value != null) {
            this.validateHeaderValue(header, ICoreConstants.SHAPE_VALUES);
        }
    }

    private void validateEclipsePlatformFilter() {
        IHeader header = this.getHeader("Eclipse-PlatformFilter");
        if (header == null) {
            return;
        }
        try {
            PDECore.getDefault().getBundleContext().createFilter(header.getValue());
            int severity = CompilerFlags.getFlag(this.fProject, "compilers.incompatible-environment");
            if (severity == 2) {
                return;
            }
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc != null && !desc.isResolved()) {
                ResolverError[] errors;
                ResolverError[] resolverErrorArray = errors = desc.getContainingState().getResolverErrors(desc);
                int n = errors.length;
                int n2 = 0;
                while (n2 < n) {
                    ResolverError error = resolverErrorArray[n2];
                    if (error.getType() == 8192) {
                        IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_badFilter, header.getLineNumber(), severity, "");
                        this.addMarkerAttribute(marker, "compilerKey", "compilers.incompatible-environment");
                    }
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException ise) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_invalidFilterSyntax, header.getLineNumber(), 0, "fatal");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.incompatible-environment");
        }
    }

    private void validateEclipseGenericCapability() {
        IHeader header = this.getHeader("Eclipse-GenericCapability");
        if (header == null) {
            return;
        }
        if (TargetPlatformHelper.getTargetVersion() >= 3.7 && this.isCheckDeprecated()) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_eclipse_genericCapabilityDeprecated, (Object)"Eclipse-GenericCapability", (Object)"Provide-Capability");
            IncrementalErrorReporter.VirtualMarker marker = this.report(message, header.getLineNumber(), "compilers.p.deprecated", "deprecation");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
        }
    }

    private void validateEclipseGenericRequire() {
        IHeader header = this.getHeader("Eclipse-GenericRequire");
        if (header == null) {
            return;
        }
        if (TargetPlatformHelper.getTargetVersion() >= 3.7 && this.isCheckDeprecated()) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_eclipse_genericRequireDeprecated, (Object)"Eclipse-GenericRequire", (Object)"Require-Capability");
            IncrementalErrorReporter.VirtualMarker marker = this.report(message, header.getLineNumber(), "compilers.p.deprecated", "deprecation");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
        }
    }

    private void validateBundleActivator() {
        IHeader header = this.getHeader("Bundle-Activator");
        if (header == null) {
            return;
        }
        String activator = header.getValue();
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc != null && desc.getHost() != null) {
            this.report(PDECoreMessages.BundleErrorReporter_fragmentActivator, header.getLineNumber(), 0, "fatal");
            return;
        }
        if (this.isCheckUnknownClass() && PluginProject.isJavaProject(this.fProject) && !PDEJavaHelper.isOnClasspath(activator, JavaCore.create((IProject)this.fProject))) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_NoExist, (Object)activator), this.getLine(header, activator), "compilers.p.unknown-class", 4112, "fatal");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unknown-class");
        }
    }

    private void validateBundleClasspath() {
        IHeader header = this.getHeader("Bundle-ClassPath");
        if (header != null && header.getElements().length == 0) {
            this.report(PDECoreMessages.BundleErrorReporter_ClasspathNotEmpty, header.getLineNumber(), 0, "fatal");
        }
    }

    private void validateRequireBundle(IProgressMonitor monitor) {
        if (!this.isCheckUnresolvedImports()) {
            return;
        }
        IHeader header = this.getHeader("Require-Bundle");
        if (header == null) {
            return;
        }
        ManifestElement[] required = header.getElements();
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            ManifestElement[] manifestElementArray = required;
            int n = required.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                this.validateBundleVersionAttribute(header, element);
                ++n2;
            }
            return;
        }
        BundleSpecification[] specs = desc.getRequiredBundles();
        if (specs.length != required.length) {
            specs = null;
        }
        int i = 0;
        while (i < required.length) {
            this.checkCanceled(monitor);
            String bundleID = required[i].getValue();
            this.validateBundleVersionAttribute(header, required[i]);
            this.validateVisibilityDirective(header, required[i]);
            this.validateReprovideAttribute(header, required[i]);
            this.validateResolutionDirective(header, required[i]);
            this.validateOptionalAttribute(header, required[i]);
            this.validateFragmentHost(header, required[i]);
            boolean optional = this.isOptional(required[i]);
            int severity = this.getRequireBundleSeverity(required[i], optional);
            if (specs != null && specs[i].getSupplier() == null) {
                if (desc.getContainingState().getBundle(specs[i].getName(), null) == null) {
                    IPluginModelBase[] targetModels;
                    PDEState pdeState = TargetPlatformHelper.getPDEState();
                    if (pdeState != null && (targetModels = pdeState.getTargetModels()) != null && targetModels.length == 0) {
                        IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_EmptyTargetPlatform, 1, severity, 4104, "fatal");
                        this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
                        return;
                    }
                    IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistPDE, (Object)bundleID), this.getPackageLine(header, required[i]), severity, 4104, "fatal");
                    this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
                    if (marker != null) {
                        marker.setAttribute("bundleId", required[i].getValue());
                        if (optional) {
                            marker.setAttribute("optional", true);
                        }
                    }
                } else {
                    this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_BundleRangeInvalidInBundleVersion, (Object)(bundleID + ": " + String.valueOf(specs[i].getVersionRange()))), this.getPackageLine(header, required[i]), severity, "fatal");
                }
            }
            ++i;
        }
        if (!this.fOsgiR4) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_R4SyntaxInR3Bundle, (Object)"Require-Bundle"), header.getLineNumber(), 1, 4133, "");
        }
    }

    private void validateBundleVersionAttribute(IHeader header, ManifestElement element) {
        IncrementalErrorReporter.VirtualMarker marker;
        String versionRange = element.getAttribute("bundle-version");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.missing-version-require-bundle");
        if (severity != 2 && versionRange == null) {
            marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_MissingVersion, (Object)element.getValue()), this.getPackageLine(header, element), severity, 4148, "");
            marker.setAttribute("bundleId", element.getValue());
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.missing-version-require-bundle");
        }
        if (versionRange != null && !VersionUtil.validateVersionRange(versionRange).isOK()) {
            marker = this.report(NLS.bind((String)UtilMessages.BundleErrorReporter_InvalidFormatInBundleVersion, (Object)element.getValue()), this.getPackageLine(header, element), 0, "fatal");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.missing-version-require-bundle");
        }
    }

    private void validateVisibilityDirective(IHeader header, ManifestElement element) {
        String visibility = element.getDirective("visibility");
        if (visibility != null) {
            this.validateDirectiveValue(header, element, "visibility", new String[]{"private", "reexport"});
        }
    }

    private void validateReprovideAttribute(IHeader header, ManifestElement element) {
        String rexport = element.getAttribute("reprovide");
        if (rexport != null) {
            this.validateBooleanAttributeValue(header, element, "reprovide");
            if (this.fOsgiR4 && this.isCheckDeprecated()) {
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_reprovide, (Object)"reprovide");
                IncrementalErrorReporter.VirtualMarker marker = this.report(message, this.getLine(header, "reprovide="), "compilers.p.deprecated", "deprecation");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            }
        }
    }

    private boolean isOptional(ManifestElement element) {
        return "optional".equals(element.getDirective("resolution")) || "true".equals(element.getAttribute("optional"));
    }

    private int getRequireBundleSeverity(ManifestElement requireBundleElement, boolean optional) {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-import");
        if (optional && severity == 0) {
            severity = 1;
        }
        return severity;
    }

    private void validateResolutionDirective(IHeader header, ManifestElement requireBundleElement) {
        String resolution = requireBundleElement.getDirective("resolution");
        if (resolution != null) {
            this.validateDirectiveValue(header, requireBundleElement, "resolution", new String[]{"mandatory", "optional"});
        }
    }

    private void validateOptionalAttribute(IHeader header, ManifestElement element) {
        String rexport = element.getAttribute("optional");
        if (rexport != null) {
            this.validateBooleanAttributeValue(header, element, "optional");
            if (this.fOsgiR4 && this.isCheckDeprecated()) {
                IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_optional, (Object)"optional"), this.getLine(header, "optional="), "compilers.p.deprecated", "deprecation");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            }
        }
    }

    private void validateImportPackage(IProgressMonitor monitor) {
        VersionConstraint[] constraints;
        IHeader header = this.getHeader("Import-Package");
        if (header == null) {
            return;
        }
        BundleDescription desc = this.fModel.getBundleDescription();
        if (desc == null) {
            ManifestElement[] elements;
            ManifestElement[] manifestElementArray = elements = header.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                this.validateSpecificationVersionAttribute(header, element);
                this.validateImportPackageVersion(header, element);
                ++n2;
            }
            return;
        }
        boolean hasUnresolved = false;
        VersionConstraint[] versionConstraintArray = constraints = desc.getContainingState().getStateHelper().getUnsatisfiedConstraints(desc);
        int n = constraints.length;
        int n3 = 0;
        while (n3 < n) {
            VersionConstraint constraint = versionConstraintArray[n3];
            if (constraint instanceof ImportPackageSpecification) {
                hasUnresolved = true;
                break;
            }
            ++n3;
        }
        HashMap<String, ExportPackageDescription> exported = this.getAvailableExportedPackages(desc.getContainingState());
        ImportPackageSpecification[] imports = desc.getImportPackages();
        if (desc.hasDynamicImports()) {
            ArrayList<ImportPackageSpecification> staticImportsList = new ArrayList<ImportPackageSpecification>();
            int i = 0;
            while (i < imports.length) {
                if (!imports[i].getDirective("resolution").equals("dynamic")) {
                    staticImportsList.add(imports[i]);
                }
                ++i;
            }
            imports = staticImportsList.toArray(new ImportPackageSpecification[staticImportsList.size()]);
        }
        ManifestElement[] elements = header.getElements();
        int index = 0;
        ManifestElement[] manifestElementArray = elements;
        int n4 = elements.length;
        int n5 = 0;
        while (n5 < n4) {
            ManifestElement element = manifestElementArray[n5];
            this.checkCanceled(monitor);
            this.validateSpecificationVersionAttribute(header, element);
            this.validateResolutionDirective(header, element);
            this.validateImportPackageVersion(header, element);
            if (hasUnresolved) {
                int length = element.getValueComponents().length;
                int j = 0;
                while (j < length) {
                    ImportPackageSpecification importSpec;
                    if (!(importSpec = imports[index++]).isResolved() && this.isCheckUnresolvedImports()) {
                        IncrementalErrorReporter.VirtualMarker marker;
                        String name = importSpec.getName();
                        boolean optional = this.isOptional(element);
                        int severity = this.getRequireBundleSeverity(element, optional);
                        ExportPackageDescription export = exported.get(name);
                        if (export != null) {
                            if (export.getSupplier().isResolved()) {
                                Version version = export.getVersion();
                                org.eclipse.osgi.service.resolver.VersionRange range = importSpec.getVersionRange();
                                if (range != null && !range.includes(version)) {
                                    IncrementalErrorReporter.VirtualMarker marker2 = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unsatisfiedConstraint, (Object)importSpec.toString()), this.getPackageLine(header, element), severity, "fatal");
                                    this.addMarkerAttribute(marker2, "compilerKey", "compilers.p.unresolved-import");
                                    return;
                                }
                            } else {
                                marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unresolvedExporter, (Object[])new String[]{export.getSupplier().getSymbolicName(), name}), this.getPackageLine(header, element), severity, "");
                                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
                                return;
                            }
                        }
                        marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_PackageNotExported, (Object)name), this.getPackageLine(header, element), severity, 4103, "fatal");
                        this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
                        if (marker != null) {
                            marker.setAttribute("packageName", name);
                            if (optional) {
                                marker.setAttribute("optional", true);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++n5;
        }
    }

    private HashMap<String, ExportPackageDescription> getAvailableExportedPackages(State state) {
        BundleDescription[] bundles = state.getBundles();
        HashMap<String, ExportPackageDescription> exported = new HashMap<String, ExportPackageDescription>();
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription[] exports;
            BundleDescription bundle = bundleDescriptionArray[n2];
            ExportPackageDescription[] exportPackageDescriptionArray = exports = bundle.getExportPackages();
            int n3 = exports.length;
            int n4 = 0;
            while (n4 < n3) {
                ExportPackageDescription export = exportPackageDescriptionArray[n4];
                String name = export.getName();
                if (exported.containsKey(name)) {
                    if (export.getSupplier().isResolved()) {
                        exported.put(name, export);
                    }
                } else {
                    exported.put(name, export);
                }
                ++n4;
            }
            ++n2;
        }
        return exported;
    }

    protected void validateExportPackage(IProgressMonitor monitor) {
        ManifestElement[] elements;
        IHeader header = this.getHeader("Export-Package");
        if (header == null) {
            return;
        }
        String message = null;
        ManifestElement[] manifestElementArray = elements = header.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String[] valueComps;
            ManifestElement element = manifestElementArray[n2];
            this.checkCanceled(monitor);
            this.validateExportPackageVersion(header, element);
            this.validateSpecificationVersionAttribute(header, element);
            this.validateX_InternalDirective(header, element);
            this.validateX_FriendsDirective(header, element);
            String[] stringArray = valueComps = element.getValueComponents();
            int n3 = valueComps.length;
            int n4 = 0;
            while (n4 < n3) {
                block11: {
                    String name;
                    block10: {
                        block9: {
                            String valueComp = stringArray[n4];
                            name = valueComp;
                            if (!name.equals("java") && !name.startsWith("java.")) break block9;
                            IHeader jreHeader = this.getHeader("Eclipse-JREBundle");
                            if (jreHeader == null || !"true".equals(jreHeader.getValue())) {
                                message = PDECoreMessages.BundleErrorReporter_exportNoJRE;
                                this.report(message, this.getPackageLine(header, element), 0, 4098, "fatal");
                            }
                            break block10;
                        }
                        if (".".equals(name.trim())) break block11;
                    }
                    if (this.isCheckUnresolvedImports() && !this.getExportedPackages().contains(name) && !this.isFolderOnClasspath(name)) {
                        message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)name);
                        IncrementalErrorReporter.VirtualMarker marker = this.report(message, this.getPackageLine(header, element), "compilers.p.unresolved-import", 4102, "");
                        this.addMarkerAttribute(marker, "packageName", name);
                        this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private boolean isFolderOnClasspath(String name) {
        if (name.contains("/") || name.contains("\\")) {
            return false;
        }
        String folderName = name.replace('.', '/');
        if (this.fProject.getFolder(folderName).exists()) {
            return true;
        }
        IHeader bundleClasspath = this.getHeader("Bundle-ClassPath");
        if (bundleClasspath != null) {
            if (Arrays.stream(bundleClasspath.getElements()).map(e -> e.getValue().strip()).filter(e -> e.endsWith(".jar")).map(arg_0 -> ((IProject)this.fProject).getFile(arg_0)).filter(IResource::exists).anyMatch(f -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (JarFile jar = new JarFile(new File(f.getLocationURI()));){
                        boolean bl = jar.getJarEntry(folderName) != null;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            })) {
                return true;
            }
        }
        return false;
    }

    private boolean containsPackage(IHeader header, String name) {
        if (header != null) {
            ManifestElement[] elements;
            ManifestElement[] manifestElementArray = elements = header.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                if (element.getValue().equals(name)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Set<String> getExportedPackages() {
        if (this.fProjectPackages == null) {
            this.fProjectPackages = new HashSet<String>();
            this.addProjectPackages(this.fProject);
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc != null) {
                HostSpecification host = desc.getHost();
                if (host != null) {
                    this.addHostPackages(host.getName());
                } else {
                    this.addFragmentPackages(desc.getFragments());
                }
            }
        }
        return this.fProjectPackages;
    }

    private void addHostPackages(String hostID) {
        IPluginModelBase model = PluginRegistry.findModel(hostID);
        if (model != null) {
            IResource resource = model.getUnderlyingResource();
            if (resource != null) {
                this.addProjectPackages(resource.getProject());
            } else if (PluginProject.isJavaProject(this.fProject)) {
                try {
                    IPackageFragment[] fragments;
                    IPackageFragment[] iPackageFragmentArray = fragments = PluginJavaSearchUtil.collectPackageFragments(new IPluginModelBase[]{model}, JavaCore.create((IProject)this.fProject), false);
                    int n = fragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment fragment = iPackageFragmentArray[n2];
                        this.fProjectPackages.add(fragment.getElementName());
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private void addFragmentPackages(BundleDescription[] fragments) {
        BundleDescription[] bundleDescriptionArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            BundleDescription fragment = bundleDescriptionArray[n2];
            String id = fragment.getSymbolicName();
            IPluginModelBase model = PluginRegistry.findModel(id);
            IResource iResource = resource = model instanceof IFragmentModel ? model.getUnderlyingResource() : null;
            if (resource != null) {
                this.addProjectPackages(resource.getProject());
            }
            ++n2;
        }
    }

    private void addProjectPackages(IProject proj) {
        if (PluginProject.isJavaProject(proj)) {
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = JavaCore.create((IProject)proj).getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 || root.getKind() == 2 && !root.isExternal()) {
                        IJavaElement[] children;
                        IJavaElement[] iJavaElementArray = children = root.getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement element = iJavaElementArray[n4];
                            IPackageFragment f = (IPackageFragment)element;
                            String name = f.getElementName();
                            if (name.equals("")) {
                                name = ".";
                            }
                            if (f.hasChildren() || f.getNonJavaResources().length > 0) {
                                this.fProjectPackages.add(name);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    protected boolean isCheckDeprecated() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated") != 2;
    }

    protected boolean isCheckNoRequiredAttr() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.no-required-att") != 2;
    }

    protected boolean isCheckUnknownClass() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-class") != 2;
    }

    protected boolean isCheckUnresolvedImports() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.unresolved-import") != 2;
    }

    protected boolean isCheckMissingExportPackageVersion() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.missing-version-export-package") != 2;
    }

    protected boolean isCheckMissingImportPackageVersion() {
        return CompilerFlags.getFlag(this.fProject, "compilers.p.missing-version-import-package") != 2;
    }

    private void validateTranslatableHeaders() {
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.not-externalized-att");
        if (severity == 2) {
            return;
        }
        String[] stringArray = ICoreConstants.TRANSLATABLE_HEADERS;
        int n = ICoreConstants.TRANSLATABLE_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            IHeader header = this.getHeader(element);
            if (header != null) {
                NLResourceHelper helper;
                String value = header.getValue();
                if (!value.startsWith("%")) {
                    IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_non_ext_attribute, (Object)header.getName()), this.getLine(header, value), severity, 12290, header.getName(), "nls");
                    this.addMarkerAttribute(marker, "compilerKey", "compilers.p.not-externalized-att");
                } else if (this.fModel instanceof AbstractNLModel && ((helper = ((AbstractNLModel)((Object)this.fModel)).getNLResourceHelper()) == null || !helper.resourceExists(value))) {
                    IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.Builders_Manifest_key_not_found, (Object)value.substring(1), (Object)PDEManager.getBundleLocalization(this.fModel).concat(".properties")), this.getLine(header, value), severity, "nls");
                    this.addMarkerAttribute(marker, "compilerKey", "compilers.p.not-externalized-att");
                }
            }
            ++n2;
        }
    }

    private void validateSpecificationVersionAttribute(IHeader header, ManifestElement element) {
        String version = element.getAttribute("specification-version");
        IStatus status = VersionUtil.validateVersion(version);
        if (!status.isOK()) {
            this.report(status.getMessage(), this.getPackageLine(header, element), 0, "fatal");
        }
        if (this.isCheckDeprecated() && this.fOsgiR4 && version != null) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_deprecated_attribute_specification_version, (Object)"specification-version"), this.getPackageLine(header, element), "compilers.p.deprecated", "deprecation");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
        }
    }

    private void validateImportPackageVersion(IHeader header, ManifestElement element) {
        String version = element.getAttribute("version");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.missing-version-import-package");
        if (severity != 2 && version == null) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_MissingVersion, (Object)element.getValue()), this.getPackageLine(header, element), severity, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.missing-version-import-package");
        }
        this.validateVersionAttribute(header, element, true);
    }

    private void validateExportPackageVersion(IHeader header, ManifestElement element) {
        String version = element.getAttribute("version");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.missing-version-export-package");
        if (severity != 2 && version == null) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_MissingVersion, (Object)element.getValue()), this.getPackageLine(header, element), severity, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.missing-version-export-package");
        }
        this.validateVersionAttribute(header, element, false);
    }

    private void validateVersionAttribute(IHeader header, ManifestElement element, boolean range) {
        String version = element.getAttribute("version");
        if (version != null) {
            IStatus status;
            IStatus iStatus = status = range ? VersionUtil.validateVersionRange(version) : VersionUtil.validateVersion(version);
            if (!status.isOK()) {
                this.report(status.getMessage(), this.getPackageLine(header, element), 0, "fatal");
            }
        }
    }

    private void validateX_InternalDirective(IHeader header, ManifestElement element) {
        String internal = element.getDirective("x-internal");
        if (internal == null) {
            return;
        }
        String[] stringArray = BOOLEAN_VALUES;
        int n = BOOLEAN_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.equals(internal)) {
                return;
            }
            ++n2;
        }
        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_dir_value, (Object[])new String[]{internal, "x-internal"});
        this.report(message, this.getPackageLine(header, element), 0, "fatal");
    }

    private void validateX_FriendsDirective(IHeader header, ManifestElement element) {
        String friends = element.getDirective("x-friends");
        String internal = element.getDirective("x-internal");
        if (friends != null && internal != null) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_directive_hasNoEffectWith_, (Object[])new String[]{"x-friends", "x-internal"});
            IncrementalErrorReporter.VirtualMarker marker = this.report(message, this.getPackageLine(header, element), 1, 4114, "");
            this.addMarkerAttribute(marker, "packageName", element.getValue());
        }
    }

    private void validateBundleActivatorPolicy() {
        IHeader header = this.getHeader("Bundle-ActivationPolicy");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (header == null) {
            return;
        }
        if (!this.fOsgiR4) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_R4SyntaxInR3Bundle, (Object)"Bundle-ActivationPolicy"), header.getLineNumber(), 1, 4133, "");
        }
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            this.validateHeaderValue(header, new String[]{"lazy"});
        } else if (severity != 2 && !this.containsValidActivationHeader()) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_bundleActivationPolicy_unsupported, header.getLineNumber(), severity, -1, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
        }
    }

    private void validateAutoStart() {
        IHeader header = this.getHeader("Eclipse-AutoStart");
        if (!this.validateStartHeader(header)) {
            return;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        if (severity != 2 && TargetPlatformHelper.getTargetVersion() >= 3.2 && !this.containsValidActivationHeader()) {
            String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_startHeader_autoStartDeprecated, (Object[])new Object[]{"Eclipse-AutoStart", this.getCurrentActivationHeader()});
            IncrementalErrorReporter.VirtualMarker marker = this.report(message, header.getLineNumber(), severity, 4097, "deprecation");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            if (marker != null) {
                marker.setAttribute("deprecatedAutostart.header", "Eclipse-AutoStart");
                ManifestElement elem = header.getElements()[0];
                boolean unnecessary = elem.getValue().equals("false") && elem.getAttribute("excludes") == null;
                marker.setAttribute("deprecatedAutostart.canAdd", !unnecessary);
            }
        }
    }

    private void validateLazyStart() {
        IHeader header = this.getHeader("Eclipse-LazyStart");
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
        this.validateStartHeader(header);
        if (header != null) {
            if (severity == 2 || this.containsValidActivationHeader()) {
                return;
            }
            double targetVersion = TargetPlatformHelper.getTargetVersion();
            if (targetVersion < 3.2) {
                IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_lazyStart_unsupported, header.getLineNumber(), severity, -1, "");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            } else if (targetVersion > 3.3) {
                int line = header.getLineNumber();
                String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_startHeader_autoStartDeprecated, (Object[])new Object[]{"Eclipse-LazyStart", this.getCurrentActivationHeader()});
                IncrementalErrorReporter.VirtualMarker marker = this.report(message, line, severity, 4097, "deprecation");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
                if (marker != null) {
                    marker.setAttribute("deprecatedAutostart.header", "Eclipse-LazyStart");
                    ManifestElement elem = header.getElements()[0];
                    boolean unnecessary = elem.getValue().equals("false") && elem.getAttribute("excludes") == null;
                    marker.setAttribute("deprecatedAutostart.canAdd", !unnecessary);
                }
            }
        }
    }

    private boolean containsValidActivationHeader() {
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        String header = targetVersion < 3.2 ? "Eclipse-AutoStart" : (targetVersion < 3.4 ? "Eclipse-LazyStart" : "Bundle-ActivationPolicy");
        return this.getHeader(header) != null;
    }

    private String getCurrentActivationHeader() {
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        if (targetVersion < 3.2) {
            return "Eclipse-AutoStart";
        }
        if (targetVersion < 3.4) {
            return "Eclipse-LazyStart";
        }
        return "Bundle-ActivationPolicy";
    }

    private boolean validateStartHeader(IHeader header) {
        if (header == null) {
            return false;
        }
        this.validateBooleanValue(header);
        return this.exceptionsAttributesValid(header, header.getElements());
    }

    private boolean exceptionsAttributesValid(IHeader header, ManifestElement[] elements) {
        String key;
        if (elements == null || elements.length == 0) {
            return true;
        }
        int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-attribute");
        if (severity == 2) {
            return true;
        }
        Enumeration keys = elements[0].getKeys();
        if (keys != null && keys.hasMoreElements() && "exceptions".equals(key = (String)keys.nextElement())) {
            String[] values;
            String[] stringArray = values = elements[0].getAttributes(key);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken().trim();
                    if (this.getExportedPackages().contains(name)) continue;
                    String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_NotExistInProject, (Object)name);
                    IncrementalErrorReporter.VirtualMarker marker = this.report(message, this.getLine(header, name), "compilers.p.unresolved-import", "");
                    this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unknown-attribute");
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private void validateExtensibleAPI() {
        IHeader header = this.getHeader("Eclipse-ExtensibleAPI");
        if (header != null) {
            this.validateBooleanValue(header);
        }
    }

    public IncrementalErrorReporter.VirtualMarker report(String message, int line, int severity, int problemID, String headerName, String category) {
        IncrementalErrorReporter.VirtualMarker marker = this.report(message, line, severity, problemID, category);
        if (marker != null) {
            marker.setAttribute("xmlTree.locationPath", headerName);
        }
        return marker;
    }

    private void validateImportExportServices() {
        if (this.fOsgiR4) {
            IncrementalErrorReporter.VirtualMarker marker;
            int line;
            IHeader importHeader = this.getHeader("Import-Service");
            IHeader exportHeader = this.getHeader("Export-Service");
            int severity = CompilerFlags.getFlag(this.fProject, "compilers.p.deprecated");
            if (severity == 2) {
                return;
            }
            if (importHeader != null) {
                line = importHeader.getLineNumber();
                marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_importexport_servicesDeprecated, (Object)"Import-Service"), line, severity, 4117, "deprecation");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            }
            if (exportHeader != null) {
                line = exportHeader.getLineNumber();
                marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_importexport_servicesDeprecated, (Object)"Export-Service"), line, severity, 4118, "deprecation");
                this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateBundleLocalization() {
        IResource res;
        IHeader header = this.getHeader("Bundle-Localization");
        if (header == null) {
            return;
        }
        String location = header.getValue();
        String fileName = null;
        int index = location.lastIndexOf(47);
        if (index > 0) {
            fileName = location.substring(index + 1);
            location = location.substring(0, index);
        } else {
            fileName = location;
            location = "";
        }
        if (!this.fOsgiR4) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_R4SyntaxInR3Bundle, (Object)"Bundle-Localization"), header.getLineNumber(), 1, 4133, "");
        }
        if ((res = PDEProject.getBundleRoot(this.fProject).findMember(location)) == null || !(res instanceof IContainer)) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_localization_folder_not_exist, header.getLineNumber(), CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-resource"), "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unknown-resource");
            return;
        }
        IContainer iContainer = (IContainer)res;
        try {
            void folder;
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                String childName;
                if (children[i] instanceof IFile && (childName = children[i].getName()).endsWith(".properties") && childName.startsWith(fileName)) {
                    return;
                }
                ++i;
            }
        }
        catch (CoreException children) {
            // empty catch block
        }
        IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_localization_properties_file_not_exist, header.getLineNumber(), CompilerFlags.getFlag(this.fProject, "compilers.p.unknown-resource"), "");
        this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unknown-resource");
    }

    private void validateFragmentHost(IHeader requireBundleHeader, ManifestElement element) {
        IHeader header = this.getHeader("Fragment-Host");
        if (header == null) {
            return;
        }
        ManifestElement[] elements = header.getElements();
        if (elements[0] != null && elements[0].getValue().equals(element.getValue())) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_unecessaryDependencyDueToFragmentHost, (Object)element.getValue()), this.getPackageLine(requireBundleHeader, element), 1, 4119, "");
            this.addMarkerAttribute(marker, "bundleId", element.getValue());
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.unresolved-import");
        }
    }

    private void validateProvidePackage() {
        IHeader header = this.getHeader("Provide-Package");
        if (header == null) {
            return;
        }
        if (this.fOsgiR4 && this.isCheckDeprecated()) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_providePackageHeaderDeprecated, header.getLineNumber(), "compilers.p.deprecated", 4121, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.deprecated");
        }
    }

    private void addMarkerAttribute(IncrementalErrorReporter.VirtualMarker marker, String attr, String value) {
        if (marker != null) {
            marker.setAttribute(attr, value);
        }
    }

    private void validateServiceComponent() {
        IHeader header = this.getHeader("Service-Component");
        if (header == null) {
            return;
        }
        if (this.getHeader("Bundle-ActivationPolicy") != null) {
            return;
        }
        int compilerFlag = CompilerFlags.getFlag(this.fProject, "compilers.p.service.component.without.lazyactivation");
        if (compilerFlag != 2) {
            IncrementalErrorReporter.VirtualMarker marker = this.report(PDECoreMessages.BundleErrorReporter_serviceComponentLazyStart, header.getLineNumber(), "compilers.p.service.component.without.lazyactivation", 4134, "");
            this.addMarkerAttribute(marker, "compilerKey", "compilers.p.service.component.without.lazyactivation");
        }
    }
}

