/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.Q7ElementLabelProvider;
import org.eclipse.rcptt.ui.commons.ModernElementListSelectionDialog;
import org.eclipse.rcptt.ui.dialogs.DialogUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public abstract class ContextSelectionDialog
extends ModernElementListSelectionDialog {
    private static final int NEW_ID = 1025;
    private static final int CAPTURE_ID = 1026;
    private IContext[] allContexts;
    private IContext[] fromRequiredProjects;
    private final IProject project;
    private final IQ7NamedElement element;
    private Label filterTextLabel;
    ContextType type = null;

    public ContextSelectionDialog(Shell parent, IQ7NamedElement element, IProject project) {
        super(parent, ContextSelectionDialog.createLabelProvider(element, project));
        this.project = project;
        this.element = element;
        try {
            if (element != null && element.getNamedElement() instanceof SuperContext) {
                String child = ((SuperContext)element.getNamedElement()).getChildType();
                this.type = ContextTypeManager.getInstance().getTypeById(child);
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.setTitle(Messages.ContextSelectionDialog_Title);
        this.setMessage(Messages.ContextSelectionDialog_Msg);
        this.setMultipleSelection(true);
        this.setElements(this.hasProject() ? this.getFromRequiredProjects() : this.getAllContexts());
    }

    private static ILabelProvider createLabelProvider(IQ7NamedElement element, IProject project) {
        return new Q7ElementLabelProvider(false);
    }

    private boolean hasProject() {
        return this.element != null && this.element.getQ7Project() != null && this.element.getQ7Project().exists() || this.project != null;
    }

    private IContext[] getAllContexts() {
        if (this.allContexts == null) {
            IQ7NamedElement[] elements = Q7SearchCore.findAllElements((ISearchScope)new AllProjectScope());
            HashSet<IContext> result = new HashSet<IContext>();
            IQ7NamedElement[] iQ7NamedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement context = iQ7NamedElementArray[n2];
                if (context instanceof IContext && this.isValidToAdd((IContext)context)) {
                    result.add((IContext)context);
                }
                ++n2;
            }
            this.allContexts = result.toArray(new IContext[result.size()]);
        }
        return this.allContexts;
    }

    private IContext[] getFromRequiredProjects() {
        if (this.fromRequiredProjects == null) {
            IQ7NamedElement[] elements = null;
            elements = this.project == null ? Q7SearchCore.findAllElements((ISearchScope)new ReferencedProjectScope(this.element.getQ7Project())) : Q7SearchCore.findAllElements((ISearchScope)new ReferencedProjectScope(RcpttCore.create((IProject)this.project)));
            HashSet<IContext> result = new HashSet<IContext>();
            IQ7NamedElement[] iQ7NamedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement context = iQ7NamedElementArray[n2];
                if (context instanceof IContext && this.isValidToAdd((IContext)context)) {
                    result.add((IContext)context);
                }
                ++n2;
            }
            this.fromRequiredProjects = result.toArray(new IContext[result.size()]);
        }
        return this.fromRequiredProjects;
    }

    protected abstract boolean isValidToAdd(IContext var1);

    public boolean isHelpAvailable() {
        return false;
    }

    private void updateFilteredList(boolean checked) {
        Object[] newElements = checked ? this.getFromRequiredProjects() : this.getAllContexts();
        this.setListElements(newElements);
    }

    @Override
    protected void handleEmptyList() {
        this.filterTextLabel.setEnabled(false);
        super.handleEmptyList();
    }

    @Override
    protected void handleNonemptyList() {
        this.filterTextLabel.setEnabled(true);
        super.handleNonemptyList();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.ContextSelectionDialog_NewButtonText, false).setImage(Images.getImage("icons/context.gif"));
        Button captureBtn = this.createButton(parent, 1026, Messages.ContextSelectionDialog_CaptureButtonText, false);
        captureBtn.setImage(Images.getImage("icons/camera.png"));
        if (this.type != null) {
            captureBtn.setEnabled(this.type.canCreate());
        }
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId || 1026 == buttonId) {
            try {
                IContext context = DialogUtil.openNewContextDialog(this.getShell(), 1026 == buttonId, this.type);
                if (context == null) {
                    return;
                }
                this.setResult(Arrays.asList(context));
                this.setReturnCode(0);
                this.close();
            }
            catch (Throwable e) {
                Q7UIPlugin.log(e);
            }
        }
        super.buttonPressed(buttonId);
    }

    @Override
    protected Text createFilterText(Composite parent) {
        this.filterTextLabel = new Label(parent, 0);
        this.filterTextLabel.setText(Messages.ContextSelectionDialog_FilterText);
        GridDataFactory.fillDefaults().applyTo((Control)this.filterTextLabel);
        return super.createFilterText(parent);
    }

    @Override
    protected FilteredList createFilteredList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.ContextSelectionDialog_TopLabelText);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        FilteredList list = super.createFilteredList(parent);
        final Button checkbox = new Button(parent, 32);
        checkbox.setText(Messages.ContextSelectionDialog_ShowCheckboxText);
        boolean hasProject = this.hasProject();
        checkbox.setSelection(hasProject);
        checkbox.setEnabled(hasProject);
        this.updateFilteredList(hasProject);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextSelectionDialog.this.updateFilteredList(checkbox.getSelection());
            }
        });
        return list;
    }
}

