/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.runtime.IPipe;

public class Pipe
implements IPipe {
    private static Object CLOSE_OBJECT = new Object();
    private static final int DELTA = 100;
    private final LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
    private boolean closed = false;
    private IStatus status = null;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Object take(long timeout) throws CoreException {
        if (this.queue == null) {
            throw new CoreException(CorePlugin.err("Pipe was not initialized for some reason"));
        }
        try {
            if (timeout > 100L) {
                long steps = timeout / 100L;
                long end = timeout % 100L;
                int i = 0;
                while ((long)i < steps) {
                    if (this.closed && this.queue.isEmpty()) {
                        return this.status;
                    }
                    Object o = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (CLOSE_OBJECT.equals(o)) {
                        return this.status;
                    }
                    if (o != null) {
                        return o;
                    }
                    ++i;
                }
                if (end > 0L) {
                    return this.queue.poll(end, TimeUnit.MILLISECONDS);
                }
                return CorePlugin.err("Timeout");
            }
            Object result = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            if (CLOSE_OBJECT.equals(result)) {
                return this.status;
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new CoreException(CorePlugin.err(e.getMessage(), e));
        }
    }

    @Override
    public IPipe write(Object object) throws CoreException {
        if (this.queue == null) {
            Status s = new Status(4, "org.eclipse.rcptt.ecl.core", "Writing to closed pipe");
            throw new CoreException((IStatus)s);
        }
        try {
            this.queue.put(object);
        }
        catch (InterruptedException e) {
            throw new CoreException(CorePlugin.err(e.getMessage(), e));
        }
        return this;
    }

    @Override
    public IPipe close(IStatus status) throws CoreException {
        this.status = status;
        if (this.status == null) {
            throw new CoreException(CorePlugin.err("Pipe was closed without status specified"));
        }
        this.closed = true;
        try {
            this.queue.put(CLOSE_OBJECT);
        }
        catch (InterruptedException e) {
            throw new CoreException(CorePlugin.err(e.getMessage(), e));
        }
        return this;
    }

    @Override
    public void reinit() {
        this.status = null;
        this.closed = false;
    }
}

