/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.commands.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.data.commands.Append;
import org.eclipse.rcptt.ecl.data.commands.AsTableData;
import org.eclipse.rcptt.ecl.data.commands.AssertTablesMatch;
import org.eclipse.rcptt.ecl.data.commands.CommandsFactory;
import org.eclipse.rcptt.ecl.data.commands.CommandsPackage;
import org.eclipse.rcptt.ecl.data.commands.ExcludeColumns;
import org.eclipse.rcptt.ecl.data.commands.ExcludeRows;
import org.eclipse.rcptt.ecl.data.commands.GetAttr;
import org.eclipse.rcptt.ecl.data.commands.GetAttrs;
import org.eclipse.rcptt.ecl.data.commands.GetNodes;
import org.eclipse.rcptt.ecl.data.commands.HasAttr;
import org.eclipse.rcptt.ecl.data.commands.IgnoreColumnsMode;
import org.eclipse.rcptt.ecl.data.commands.ListAsTableData;
import org.eclipse.rcptt.ecl.data.commands.Print;
import org.eclipse.rcptt.ecl.data.commands.ReadCsvFile;
import org.eclipse.rcptt.ecl.data.commands.ReadFile;
import org.eclipse.rcptt.ecl.data.commands.ReadLines;
import org.eclipse.rcptt.ecl.data.commands.ReadProperties;
import org.eclipse.rcptt.ecl.data.commands.ReadXmlFile;
import org.eclipse.rcptt.ecl.data.commands.Remove;
import org.eclipse.rcptt.ecl.data.commands.RowMatchMode;
import org.eclipse.rcptt.ecl.data.commands.SelectColumns;
import org.eclipse.rcptt.ecl.data.commands.SelectRows;
import org.eclipse.rcptt.ecl.data.commands.SetAttr;
import org.eclipse.rcptt.ecl.data.commands.SetPageName;
import org.eclipse.rcptt.ecl.data.commands.TreeNode;
import org.eclipse.rcptt.ecl.data.commands.WriteCsvFile;
import org.eclipse.rcptt.ecl.data.commands.WriteLines;
import org.eclipse.rcptt.ecl.data.commands.WriteXmlFile;
import org.eclipse.rcptt.ecl.data.objects.ObjectsPackage;

public class CommandsPackageImpl
extends EPackageImpl
implements CommandsPackage {
    private EClass readCsvFileEClass = null;
    private EClass printEClass = null;
    private EClass writeCsvFileEClass = null;
    private EClass excludeColumnsEClass = null;
    private EClass selectColumnsEClass = null;
    private EClass assertTablesMatchEClass = null;
    private EClass writeLinesEClass = null;
    private EClass readLinesEClass = null;
    private EClass selectRowsEClass = null;
    private EClass excludeRowsEClass = null;
    private EClass asTableDataEClass = null;
    private EClass readPropertiesEClass = null;
    private EClass readFileEClass = null;
    private EClass setPageNameEClass = null;
    private EClass listAsTableDataEClass = null;
    private EClass readXmlFileEClass = null;
    private EClass writeXmlFileEClass = null;
    private EClass treeNodeEClass = null;
    private EClass getAttrsEClass = null;
    private EClass getAttrEClass = null;
    private EClass setAttrEClass = null;
    private EClass hasAttrEClass = null;
    private EClass getNodesEClass = null;
    private EClass appendEClass = null;
    private EClass removeEClass = null;
    private EEnum ignoreColumnsModeEEnum = null;
    private EEnum rowMatchModeEEnum = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private CommandsPackageImpl() {
        super("http://www.eclipse.org/ecl/data/commands.ecore", (EFactory)CommandsFactory.eINSTANCE);
    }

    public static CommandsPackage init() {
        if (isInited) {
            return (CommandsPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/data/commands.ecore");
        }
        CommandsPackageImpl theCommandsPackage = (CommandsPackageImpl)(EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/ecl/data/commands.ecore") instanceof CommandsPackageImpl ? EPackage.Registry.INSTANCE.get((Object)"http://www.eclipse.org/ecl/data/commands.ecore") : new CommandsPackageImpl());
        isInited = true;
        CorePackage.eINSTANCE.eClass();
        ObjectsPackage.eINSTANCE.eClass();
        theCommandsPackage.createPackageContents();
        theCommandsPackage.initializePackageContents();
        theCommandsPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ecl/data/commands.ecore", (Object)theCommandsPackage);
        return theCommandsPackage;
    }

    @Override
    public EClass getReadCsvFile() {
        return this.readCsvFileEClass;
    }

    @Override
    public EAttribute getReadCsvFile_Uri() {
        return (EAttribute)this.readCsvFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getPrint() {
        return this.printEClass;
    }

    @Override
    public EReference getPrint_Input() {
        return (EReference)this.printEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getWriteCsvFile() {
        return this.writeCsvFileEClass;
    }

    @Override
    public EReference getWriteCsvFile_Table() {
        return (EReference)this.writeCsvFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getWriteCsvFile_Uri() {
        return (EAttribute)this.writeCsvFileEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getWriteCsvFile_Append() {
        return (EAttribute)this.writeCsvFileEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getExcludeColumns() {
        return this.excludeColumnsEClass;
    }

    @Override
    public EReference getExcludeColumns_Table() {
        return (EReference)this.excludeColumnsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getExcludeColumns_Columns() {
        return (EAttribute)this.excludeColumnsEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getSelectColumns() {
        return this.selectColumnsEClass;
    }

    @Override
    public EReference getSelectColumns_Table() {
        return (EReference)this.selectColumnsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getSelectColumns_Columns() {
        return (EAttribute)this.selectColumnsEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getAssertTablesMatch() {
        return this.assertTablesMatchEClass;
    }

    @Override
    public EReference getAssertTablesMatch_Left() {
        return (EReference)this.assertTablesMatchEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getAssertTablesMatch_Right() {
        return (EReference)this.assertTablesMatchEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getAssertTablesMatch_IgnoreColumnOrder() {
        return (EAttribute)this.assertTablesMatchEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getAssertTablesMatch_IgnoreMissingColumns() {
        return (EAttribute)this.assertTablesMatchEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EClass getWriteLines() {
        return this.writeLinesEClass;
    }

    @Override
    public EAttribute getWriteLines_Uri() {
        return (EAttribute)this.writeLinesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getWriteLines_Append() {
        return (EAttribute)this.writeLinesEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getWriteLines_Encode() {
        return (EAttribute)this.writeLinesEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getReadLines() {
        return this.readLinesEClass;
    }

    @Override
    public EAttribute getReadLines_Uri() {
        return (EAttribute)this.readLinesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getSelectRows() {
        return this.selectRowsEClass;
    }

    @Override
    public EReference getSelectRows_Table() {
        return (EReference)this.selectRowsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getSelectRows_Column() {
        return (EAttribute)this.selectRowsEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getSelectRows_Value() {
        return (EAttribute)this.selectRowsEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getSelectRows_Match() {
        return (EAttribute)this.selectRowsEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EClass getExcludeRows() {
        return this.excludeRowsEClass;
    }

    @Override
    public EReference getExcludeRows_Table() {
        return (EReference)this.excludeRowsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getExcludeRows_Column() {
        return (EAttribute)this.excludeRowsEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getExcludeRows_Value() {
        return (EAttribute)this.excludeRowsEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getExcludeRows_Match() {
        return (EAttribute)this.excludeRowsEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EClass getAsTableData() {
        return this.asTableDataEClass;
    }

    @Override
    public EReference getAsTableData_Input() {
        return (EReference)this.asTableDataEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getReadProperties() {
        return this.readPropertiesEClass;
    }

    @Override
    public EAttribute getReadProperties_Uri() {
        return (EAttribute)this.readPropertiesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getReadFile() {
        return this.readFileEClass;
    }

    @Override
    public EAttribute getReadFile_Uri() {
        return (EAttribute)this.readFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getSetPageName() {
        return this.setPageNameEClass;
    }

    @Override
    public EReference getSetPageName_Table() {
        return (EReference)this.setPageNameEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getSetPageName_Name() {
        return (EAttribute)this.setPageNameEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getListAsTableData() {
        return this.listAsTableDataEClass;
    }

    @Override
    public EReference getListAsTableData_List() {
        return (EReference)this.listAsTableDataEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getReadXmlFile() {
        return this.readXmlFileEClass;
    }

    @Override
    public EAttribute getReadXmlFile_Uri() {
        return (EAttribute)this.readXmlFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getReadXmlFile_XPath() {
        return (EAttribute)this.readXmlFileEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getWriteXmlFile() {
        return this.writeXmlFileEClass;
    }

    @Override
    public EReference getWriteXmlFile_Tree() {
        return (EReference)this.writeXmlFileEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getWriteXmlFile_Uri() {
        return (EAttribute)this.writeXmlFileEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getTreeNode() {
        return this.treeNodeEClass;
    }

    @Override
    public EAttribute getTreeNode_Name() {
        return (EAttribute)this.treeNodeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getTreeNode_Attrs() {
        return (EReference)this.treeNodeEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EReference getTreeNode_Children() {
        return (EReference)this.treeNodeEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getTreeNode_Text() {
        return (EAttribute)this.treeNodeEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EClass getGetAttrs() {
        return this.getAttrsEClass;
    }

    @Override
    public EReference getGetAttrs_Object() {
        return (EReference)this.getAttrsEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getGetAttr() {
        return this.getAttrEClass;
    }

    @Override
    public EReference getGetAttr_Object() {
        return (EReference)this.getAttrEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getGetAttr_Name() {
        return (EAttribute)this.getAttrEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getSetAttr() {
        return this.setAttrEClass;
    }

    @Override
    public EReference getSetAttr_Object() {
        return (EReference)this.setAttrEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getSetAttr_Name() {
        return (EAttribute)this.setAttrEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getSetAttr_Value() {
        return (EAttribute)this.setAttrEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getHasAttr() {
        return this.hasAttrEClass;
    }

    @Override
    public EReference getHasAttr_Object() {
        return (EReference)this.hasAttrEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getHasAttr_Name() {
        return (EAttribute)this.hasAttrEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getGetNodes() {
        return this.getNodesEClass;
    }

    @Override
    public EReference getGetNodes_Object() {
        return (EReference)this.getNodesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getGetNodes_Name() {
        return (EAttribute)this.getNodesEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getGetNodes_Pos() {
        return (EAttribute)this.getNodesEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EAttribute getGetNodes_Len() {
        return (EAttribute)this.getNodesEClass.getEStructuralFeatures().get(3);
    }

    @Override
    public EClass getAppend() {
        return this.appendEClass;
    }

    @Override
    public EReference getAppend_Object() {
        return (EReference)this.appendEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getAppend_Children() {
        return (EReference)this.appendEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getAppend_Index() {
        return (EAttribute)this.appendEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getRemove() {
        return this.removeEClass;
    }

    @Override
    public EReference getRemove_Object() {
        return (EReference)this.removeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getRemove_Index() {
        return (EAttribute)this.removeEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EEnum getIgnoreColumnsMode() {
        return this.ignoreColumnsModeEEnum;
    }

    @Override
    public EEnum getRowMatchMode() {
        return this.rowMatchModeEEnum;
    }

    @Override
    public CommandsFactory getCommandsFactory() {
        return (CommandsFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.readCsvFileEClass = this.createEClass(0);
        this.createEAttribute(this.readCsvFileEClass, 2);
        this.printEClass = this.createEClass(1);
        this.createEReference(this.printEClass, 2);
        this.writeCsvFileEClass = this.createEClass(2);
        this.createEReference(this.writeCsvFileEClass, 2);
        this.createEAttribute(this.writeCsvFileEClass, 3);
        this.createEAttribute(this.writeCsvFileEClass, 4);
        this.excludeColumnsEClass = this.createEClass(3);
        this.createEReference(this.excludeColumnsEClass, 2);
        this.createEAttribute(this.excludeColumnsEClass, 3);
        this.selectColumnsEClass = this.createEClass(4);
        this.createEReference(this.selectColumnsEClass, 2);
        this.createEAttribute(this.selectColumnsEClass, 3);
        this.assertTablesMatchEClass = this.createEClass(5);
        this.createEReference(this.assertTablesMatchEClass, 2);
        this.createEReference(this.assertTablesMatchEClass, 3);
        this.createEAttribute(this.assertTablesMatchEClass, 4);
        this.createEAttribute(this.assertTablesMatchEClass, 5);
        this.writeLinesEClass = this.createEClass(6);
        this.createEAttribute(this.writeLinesEClass, 2);
        this.createEAttribute(this.writeLinesEClass, 3);
        this.createEAttribute(this.writeLinesEClass, 4);
        this.readLinesEClass = this.createEClass(7);
        this.createEAttribute(this.readLinesEClass, 2);
        this.selectRowsEClass = this.createEClass(8);
        this.createEReference(this.selectRowsEClass, 2);
        this.createEAttribute(this.selectRowsEClass, 3);
        this.createEAttribute(this.selectRowsEClass, 4);
        this.createEAttribute(this.selectRowsEClass, 5);
        this.excludeRowsEClass = this.createEClass(9);
        this.createEReference(this.excludeRowsEClass, 2);
        this.createEAttribute(this.excludeRowsEClass, 3);
        this.createEAttribute(this.excludeRowsEClass, 4);
        this.createEAttribute(this.excludeRowsEClass, 5);
        this.asTableDataEClass = this.createEClass(10);
        this.createEReference(this.asTableDataEClass, 2);
        this.readPropertiesEClass = this.createEClass(11);
        this.createEAttribute(this.readPropertiesEClass, 2);
        this.readFileEClass = this.createEClass(12);
        this.createEAttribute(this.readFileEClass, 2);
        this.setPageNameEClass = this.createEClass(13);
        this.createEReference(this.setPageNameEClass, 2);
        this.createEAttribute(this.setPageNameEClass, 3);
        this.listAsTableDataEClass = this.createEClass(14);
        this.createEReference(this.listAsTableDataEClass, 2);
        this.readXmlFileEClass = this.createEClass(15);
        this.createEAttribute(this.readXmlFileEClass, 2);
        this.createEAttribute(this.readXmlFileEClass, 3);
        this.writeXmlFileEClass = this.createEClass(16);
        this.createEReference(this.writeXmlFileEClass, 2);
        this.createEAttribute(this.writeXmlFileEClass, 3);
        this.treeNodeEClass = this.createEClass(17);
        this.createEAttribute(this.treeNodeEClass, 2);
        this.createEReference(this.treeNodeEClass, 3);
        this.createEReference(this.treeNodeEClass, 4);
        this.createEAttribute(this.treeNodeEClass, 5);
        this.getAttrsEClass = this.createEClass(18);
        this.createEReference(this.getAttrsEClass, 2);
        this.getAttrEClass = this.createEClass(19);
        this.createEReference(this.getAttrEClass, 2);
        this.createEAttribute(this.getAttrEClass, 3);
        this.setAttrEClass = this.createEClass(20);
        this.createEReference(this.setAttrEClass, 2);
        this.createEAttribute(this.setAttrEClass, 3);
        this.createEAttribute(this.setAttrEClass, 4);
        this.hasAttrEClass = this.createEClass(21);
        this.createEReference(this.hasAttrEClass, 2);
        this.createEAttribute(this.hasAttrEClass, 3);
        this.getNodesEClass = this.createEClass(22);
        this.createEReference(this.getNodesEClass, 2);
        this.createEAttribute(this.getNodesEClass, 3);
        this.createEAttribute(this.getNodesEClass, 4);
        this.createEAttribute(this.getNodesEClass, 5);
        this.appendEClass = this.createEClass(23);
        this.createEReference(this.appendEClass, 2);
        this.createEReference(this.appendEClass, 3);
        this.createEAttribute(this.appendEClass, 4);
        this.removeEClass = this.createEClass(24);
        this.createEReference(this.removeEClass, 2);
        this.createEAttribute(this.removeEClass, 3);
        this.ignoreColumnsModeEEnum = this.createEEnum(25);
        this.rowMatchModeEEnum = this.createEEnum(26);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("commands");
        this.setNsPrefix("dataCommands");
        this.setNsURI("http://www.eclipse.org/ecl/data/commands.ecore");
        CorePackage theCorePackage = (CorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/core.ecore");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        ObjectsPackage theObjectsPackage = (ObjectsPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/data/objects.ecore");
        this.readCsvFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.printEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.writeCsvFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.excludeColumnsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.selectColumnsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.assertTablesMatchEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.writeLinesEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.readLinesEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.selectRowsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.excludeRowsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.asTableDataEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.readPropertiesEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.readFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.setPageNameEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.listAsTableDataEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.readXmlFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.writeXmlFileEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.treeNodeEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.getAttrsEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.getAttrEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.setAttrEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.hasAttrEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.getNodesEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.appendEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.removeEClass.getESuperTypes().add((Object)theCorePackage.getCommand());
        this.initEClass(this.readCsvFileEClass, ReadCsvFile.class, "ReadCsvFile", false, false, true);
        this.initEAttribute(this.getReadCsvFile_Uri(), (EClassifier)this.ecorePackage.getEString(), "uri", null, 0, 1, ReadCsvFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.printEClass, Print.class, "Print", false, false, true);
        this.initEReference(this.getPrint_Input(), (EClassifier)theEcorePackage.getEObject(), null, "input", null, 0, -1, Print.class, false, false, true, false, true, false, false, false, true);
        this.initEClass(this.writeCsvFileEClass, WriteCsvFile.class, "WriteCsvFile", false, false, true);
        this.initEReference(this.getWriteCsvFile_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 0, 1, WriteCsvFile.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getWriteCsvFile_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 0, 1, WriteCsvFile.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getWriteCsvFile_Append(), (EClassifier)theEcorePackage.getEBoolean(), "append", "false", 0, 1, WriteCsvFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.excludeColumnsEClass, ExcludeColumns.class, "ExcludeColumns", false, false, true);
        this.initEReference(this.getExcludeColumns_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 0, 1, ExcludeColumns.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getExcludeColumns_Columns(), (EClassifier)theEcorePackage.getEString(), "columns", null, 0, -1, ExcludeColumns.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.selectColumnsEClass, SelectColumns.class, "SelectColumns", false, false, true);
        this.initEReference(this.getSelectColumns_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 0, 1, SelectColumns.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getSelectColumns_Columns(), (EClassifier)theEcorePackage.getEString(), "columns", null, 0, -1, SelectColumns.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.assertTablesMatchEClass, AssertTablesMatch.class, "AssertTablesMatch", false, false, true);
        this.initEReference(this.getAssertTablesMatch_Left(), (EClassifier)theObjectsPackage.getTable(), null, "left", null, 0, 1, AssertTablesMatch.class, false, false, true, false, true, false, true, false, true);
        this.initEReference(this.getAssertTablesMatch_Right(), (EClassifier)theObjectsPackage.getTable(), null, "right", null, 0, 1, AssertTablesMatch.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getAssertTablesMatch_IgnoreColumnOrder(), (EClassifier)theEcorePackage.getEBoolean(), "ignoreColumnOrder", "false", 0, 1, AssertTablesMatch.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getAssertTablesMatch_IgnoreMissingColumns(), (EClassifier)this.getIgnoreColumnsMode(), "ignoreMissingColumns", "NONE", 0, 1, AssertTablesMatch.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.writeLinesEClass, WriteLines.class, "WriteLines", false, false, true);
        this.initEAttribute(this.getWriteLines_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", "UTF-8", 0, 1, WriteLines.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getWriteLines_Append(), (EClassifier)theEcorePackage.getEBoolean(), "append", "false", 0, 1, WriteLines.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getWriteLines_Encode(), (EClassifier)theEcorePackage.getEString(), "encode", null, 0, 1, WriteLines.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.readLinesEClass, ReadLines.class, "ReadLines", false, false, true);
        this.initEAttribute(this.getReadLines_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 1, 1, ReadLines.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.selectRowsEClass, SelectRows.class, "SelectRows", false, false, true);
        this.initEReference(this.getSelectRows_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 0, 1, SelectRows.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getSelectRows_Column(), (EClassifier)theEcorePackage.getEString(), "column", null, 0, 1, SelectRows.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getSelectRows_Value(), (EClassifier)theEcorePackage.getEString(), "value", null, 0, 1, SelectRows.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getSelectRows_Match(), (EClassifier)this.getRowMatchMode(), "match", null, 0, 1, SelectRows.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.excludeRowsEClass, ExcludeRows.class, "ExcludeRows", false, false, true);
        this.initEReference(this.getExcludeRows_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 0, 1, ExcludeRows.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getExcludeRows_Column(), (EClassifier)theEcorePackage.getEString(), "column", null, 0, 1, ExcludeRows.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getExcludeRows_Value(), (EClassifier)theEcorePackage.getEString(), "value", null, 0, 1, ExcludeRows.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getExcludeRows_Match(), (EClassifier)this.getRowMatchMode(), "match", null, 0, 1, ExcludeRows.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.asTableDataEClass, AsTableData.class, "AsTableData", false, false, true);
        this.initEReference(this.getAsTableData_Input(), (EClassifier)theEcorePackage.getEObject(), null, "input", null, 0, -1, AsTableData.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.readPropertiesEClass, ReadProperties.class, "ReadProperties", false, false, true);
        this.initEAttribute(this.getReadProperties_Uri(), (EClassifier)this.ecorePackage.getEString(), "uri", null, 0, 1, ReadProperties.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.readFileEClass, ReadFile.class, "ReadFile", false, false, true);
        this.initEAttribute(this.getReadFile_Uri(), (EClassifier)theEcorePackage.getEString(), "uri", null, 1, 1, ReadFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.setPageNameEClass, SetPageName.class, "SetPageName", false, false, true);
        this.initEReference(this.getSetPageName_Table(), (EClassifier)theObjectsPackage.getTable(), null, "table", null, 1, 1, SetPageName.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getSetPageName_Name(), (EClassifier)theEcorePackage.getEString(), "name", null, 1, 1, SetPageName.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.listAsTableDataEClass, ListAsTableData.class, "ListAsTableData", false, false, true);
        this.initEReference(this.getListAsTableData_List(), (EClassifier)theCorePackage.getEclList(), null, "list", null, 1, 1, ListAsTableData.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.readXmlFileEClass, ReadXmlFile.class, "ReadXmlFile", false, false, true);
        this.initEAttribute(this.getReadXmlFile_Uri(), (EClassifier)this.ecorePackage.getEString(), "uri", null, 1, 1, ReadXmlFile.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getReadXmlFile_XPath(), (EClassifier)this.ecorePackage.getEString(), "xPath", null, 0, 1, ReadXmlFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.writeXmlFileEClass, WriteXmlFile.class, "WriteXmlFile", false, false, true);
        this.initEReference(this.getWriteXmlFile_Tree(), (EClassifier)theObjectsPackage.getTree(), null, "tree", null, 1, 1, WriteXmlFile.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getWriteXmlFile_Uri(), (EClassifier)this.ecorePackage.getEString(), "uri", null, 1, 1, WriteXmlFile.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.treeNodeEClass, TreeNode.class, "TreeNode", false, false, true);
        this.initEAttribute(this.getTreeNode_Name(), (EClassifier)this.ecorePackage.getEString(), "name", null, 1, 1, TreeNode.class, false, false, true, false, false, true, false, true);
        this.initEReference(this.getTreeNode_Attrs(), (EClassifier)theCorePackage.getEclMap(), null, "attrs", null, 0, 1, TreeNode.class, false, false, true, false, true, false, true, false, true);
        this.initEReference(this.getTreeNode_Children(), (EClassifier)theObjectsPackage.getTree(), null, "children", null, 0, -1, TreeNode.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getTreeNode_Text(), (EClassifier)this.ecorePackage.getEString(), "text", null, 0, 1, TreeNode.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.getAttrsEClass, GetAttrs.class, "GetAttrs", false, false, true);
        this.initEReference(this.getGetAttrs_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, GetAttrs.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.getAttrEClass, GetAttr.class, "GetAttr", false, false, true);
        this.initEReference(this.getGetAttr_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, GetAttr.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getGetAttr_Name(), (EClassifier)this.ecorePackage.getEString(), "name", null, 1, 1, GetAttr.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.setAttrEClass, SetAttr.class, "SetAttr", false, false, true);
        this.initEReference(this.getSetAttr_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, SetAttr.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getSetAttr_Name(), (EClassifier)this.ecorePackage.getEString(), "name", null, 1, 1, SetAttr.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getSetAttr_Value(), (EClassifier)this.ecorePackage.getEString(), "value", null, 0, 1, SetAttr.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.hasAttrEClass, HasAttr.class, "HasAttr", false, false, true);
        this.initEReference(this.getHasAttr_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, HasAttr.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getHasAttr_Name(), (EClassifier)this.ecorePackage.getEString(), "name", null, 1, 1, HasAttr.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.getNodesEClass, GetNodes.class, "GetNodes", false, false, true);
        this.initEReference(this.getGetNodes_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, GetNodes.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getGetNodes_Name(), (EClassifier)this.ecorePackage.getEString(), "name", null, 0, 1, GetNodes.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getGetNodes_Pos(), (EClassifier)theEcorePackage.getEInt(), "pos", "0", 0, 1, GetNodes.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getGetNodes_Len(), (EClassifier)theEcorePackage.getEInt(), "len", "-1", 0, 1, GetNodes.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.appendEClass, Append.class, "Append", false, false, true);
        this.initEReference(this.getAppend_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, Append.class, false, false, true, false, true, false, true, false, true);
        this.initEReference(this.getAppend_Children(), (EClassifier)theEcorePackage.getEObject(), null, "children", null, 1, -1, Append.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getAppend_Index(), (EClassifier)theEcorePackage.getEInt(), "index", "-1", 0, 1, Append.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.removeEClass, Remove.class, "Remove", false, false, true);
        this.initEReference(this.getRemove_Object(), (EClassifier)theEcorePackage.getEObject(), null, "object", null, 1, 1, Remove.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getRemove_Index(), (EClassifier)theEcorePackage.getEInt(), "index", "-1", 1, 1, Remove.class, false, false, true, false, false, true, false, true);
        this.initEEnum(this.ignoreColumnsModeEEnum, IgnoreColumnsMode.class, "IgnoreColumnsMode");
        this.addEEnumLiteral(this.ignoreColumnsModeEEnum, IgnoreColumnsMode.NONE);
        this.addEEnumLiteral(this.ignoreColumnsModeEEnum, IgnoreColumnsMode.LEFT);
        this.addEEnumLiteral(this.ignoreColumnsModeEEnum, IgnoreColumnsMode.RIGHT);
        this.addEEnumLiteral(this.ignoreColumnsModeEEnum, IgnoreColumnsMode.BOTH);
        this.initEEnum(this.rowMatchModeEEnum, RowMatchMode.class, "RowMatchMode");
        this.addEEnumLiteral(this.rowMatchModeEEnum, RowMatchMode.EXACT);
        this.addEEnumLiteral(this.rowMatchModeEEnum, RowMatchMode.GLOB);
        this.addEEnumLiteral(this.rowMatchModeEEnum, RowMatchMode.REGEXP);
        this.createResource("http://www.eclipse.org/ecl/data/commands.ecore");
        this.createDocsAnnotations();
        this.createInternalAnnotations();
        this.createInputAnnotations();
    }

    protected void createDocsAnnotations() {
        String source = "http://www.eclipse.org/ecl/docs";
        this.addAnnotation((ENamedElement)this.readCsvFileEClass, source, new String[]{"description", "Parses given csv file. Fails if file is not found or format is invalid.\nLearn more about <a href = \"http://xored.freshdesk.com/solution/articles/78219-assert-the-whole-table\">Asserting the whole table contents.</a>", "returns", "<code>Table</code> EMF Object. ", "example", "with [get-window Preferences] {\n\tget-tree | select \"Java/Installed JREs\"\n\tget-table | get-table-data | eq [read-csv-file \"workspace:/assertData/table.csv\"] | \n\t\tassert-true \"Data in table does not match input file\" \n\tget-button OK | click\n}\n\n//Let's say we need to write ErrorLog info to csv file 'table.csv'.\n//ECL script should look like this:\n \nget-view \"Error Log\" | get-tree | expand-all\nget-view \"Error Log\" | get-tree | get-table-data | write-csv-file \"workspace:/MyProject/AssertData/table.csv\n \n//Note: \n//<a href=\"#expand-all\">Expand-all</a>command may be useful in case of hierarchical tree - otherwise non-expanded levels won't be written.  \n//You should have MyProject/AssertData on your workspace (you may do it easily with a workspace context) to let you csv file to be created there. \n \n//In case you want to specify which columns/rows should be written you may use \n//<a href=\"#select-columns\">select-columns</a>/<a href=\"#exclude-columns\">exclude-columns</a> and <a href=\"#select-rows\">select-rows</a>/<a href=\"#exclude-rows\">exclude-rows</a> commands:\n \nget-view \"Error Log\" | get-tree | get-table-data | select-columns \"Message\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\" \nget-view \"Error Log\" | get-tree | get-table-data | exclude-columns \"Message\" \"Plug-in\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\"\nget-view \"Error Log\" | get-tree | get-table-data | select-rows -column \"Message\"  -value \"Execution of early startup handlers completed.\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\"\n \n//To compare table data to already written csv file you may use <a href=\"#read-csv-file\">read-csv-file</a> command:\n \nget-view \"Error Log\" | get-tree | get-table-data | select-columns \"Plug-in\" | eq [read-csv-file \"workspace:/MyProject/AssertData/table.csv\"] | assert-true \"Data in table does not match input file\" "});
        this.addAnnotation((ENamedElement)this.getReadCsvFile_Uri(), source, new String[]{"description", "URI to a file to read. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.printEClass, source, new String[]{"description", "Takes a list of objects from input pipe and prints them as a plain-text table into output pipe.", "returns", "Series of string objects"});
        this.addAnnotation((ENamedElement)this.writeCsvFileEClass, source, new String[]{"description", "Writes given table into csv file. Fails if file is not accessible.\nLearn more about <a href = \"http://xored.freshdesk.com/solution/articles/78219-assert-the-whole-table\">Asserting the whole table contents.</a>", "returns", "The value of <code>table</code> argument.", "example", "with [get-window Preferences] {\n\tget-tree | select \"Java/Installed JREs\"\n\tget-table | get-table-data | write-csv-file \"workspace:/assertData/table.csv\"\n\tget-button OK | click\n}\n\n//Let's say we need to write ErrorLog info to csv file 'table.csv'.\n//ECL script should look like this:\n \nget-view \"Error Log\" | get-tree | expand-all\nget-view \"Error Log\" | get-tree | get-table-data | write-csv-file \"workspace:/MyProject/AssertData/table.csv\n \n//Note: \n//<a href=\"#expand-all\">Expand-all</a>command may be useful in case of hierarchical tree - otherwise non-expanded levels won't be written.  \n//You should have MyProject/AssertData on your workspace (you may do it easily with a workspace context) to let you csv file to be created there. \n \n//In case you want to specify which columns/rows should be written you may use \n//<a href=\"#select-columns\">select-columns</a>/<a href=\"#exclude-columns\">exclude-columns</a> and <a href=\"#select-rows\">select-rows</a>/<a href=\"#exclude-rows\">exclude-rows</a> commands:\n \nget-view \"Error Log\" | get-tree | get-table-data | select-columns \"Message\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\" \nget-view \"Error Log\" | get-tree | get-table-data | exclude-columns \"Message\" \"Plug-in\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\"\nget-view \"Error Log\" | get-tree | get-table-data | select-rows -column \"Message\"  -value \"Execution of early startup handlers completed.\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\"\n \n//To compare table data to already written csv file you may use <a href=\"#read-csv-file\">read-csv-file</a> command:\n \nget-view \"Error Log\" | get-tree | get-table-data | select-columns \"Plug-in\" | eq [read-csv-file \"workspace:/MyProject/AssertData/table.csv\"] | assert-true \"Data in table does not match input file\" "});
        this.addAnnotation((ENamedElement)this.getWriteCsvFile_Table(), source, new String[]{"description", "Table to write"});
        this.addAnnotation((ENamedElement)this.getWriteCsvFile_Uri(), source, new String[]{"description", "URI to write CSV data to. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.excludeColumnsEClass, source, new String[]{"description", "Takes a table from input and returns the same table which has some columns excluded. ", "returns", "Copy of input table object without columns with names listed in <code>columns</code>", "example", "get-view \"Error Log\" | get-tree | get-table-data | exclude-columns \"Message\" \"Plug-in\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\""});
        this.addAnnotation((ENamedElement)this.getExcludeColumns_Table(), source, new String[]{"description", "Table to exclude columns from"});
        this.addAnnotation((ENamedElement)this.getExcludeColumns_Columns(), source, new String[]{"description", "Column names to exclude from table. It is OK to pass column names which are not present in table"});
        this.addAnnotation((ENamedElement)this.selectColumnsEClass, source, new String[]{"description", "Takes a table from input and returns the table containing only columns passed into <code>columns</code> argument.", "returns", "Copy of input table object with only columns with names listed in <code>columns</code>", "example", "get-view \"Error Log\" | get-tree | get-table-data | select-columns \"Message\" | write-csv-file \"workspace:/MyProject/AssertData/table.csv\" "});
        this.addAnnotation((ENamedElement)this.getSelectColumns_Table(), source, new String[]{"description", "Table to take columns from"});
        this.addAnnotation((ENamedElement)this.getSelectColumns_Columns(), source, new String[]{"description", "Column names to take from table. If given column name is not present in input table, command fails"});
        this.addAnnotation((ENamedElement)this.assertTablesMatchEClass, source, new String[]{"description", "Compares contents of two tables. If contents are not the same, fails with a descriptive message", "example", "assert-tables-match [get-editor \"context\" | get-section Parameters | get-table | get-table-data ]\n                    [get-editor \"context2\" | get-section Parameters | get-table | get-table-data]"});
        this.addAnnotation((ENamedElement)this.getAssertTablesMatch_IgnoreColumnOrder(), source, new String[]{"description", "When true, column order is not taken into account"});
        this.addAnnotation((ENamedElement)this.getAssertTablesMatch_IgnoreMissingColumns(), source, new String[]{"description", "Describes the comparison behaviour in case when one of tables contains a column which is not present in other table:\n<ul>\n<li><b>NONE</b> &ndash; all columns must be present in both tables</li>\n<li><b>LEFT</b> &ndash; columns from right table which are not present in left, are ignored</li>\n<li><b>RIGHT</b> &ndash; columns from left table which are not present in right, are ignored</li>\n<li><b>BOTH</b> &ndash; comparison performed only on columns present in both tables</li>\n<p>Another way to interpret this argument is that it is an answer on question &quot;Which column can have less columns?&quot;</p>\n<p>The primary reasoning for this argument is to provide smooth migration when presentation is changed \u2013 consider this scenario: we have a CSV file with table data, and we have UI table. If we add or remove extra columns in the UI, we can keep existing sample data file and just correct the <code>ignoreMissingColumns</code> argument</p>\n"});
        this.addAnnotation((ENamedElement)this.writeLinesEClass, source, new String[]{"description", "Reads objects from input pipe and writes them into file line-by-line as strings", "example", "//writes a list of launch configuration into a file line-by-line\nlist-launch-configurations | write-lines -uri \"workspace:/Project/Folder/file.txt\"\n// appends \"New line\" into a file. \nstr \"New line\" | write-lines -uri \"workspace:/Project/Folder/file.txt\" -append\n"});
        this.addAnnotation((ENamedElement)this.getWriteLines_Uri(), source, new String[]{"description", "URI to write lines to. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.getWriteLines_Append(), source, new String[]{"description", "Whether to append given lines into file. Default value is false"});
        this.addAnnotation((ENamedElement)this.readLinesEClass, source, new String[]{"description", "Reads lines from file identified by uri and writes them one-by-one into output pipe", "example", "//Displays alert with lines count\nshow-alert [concat \"The number of lines is \"[read-lines -uri \"workspace:/Project/Folder/file.txt\" | length | str]]\n\n"});
        this.addAnnotation((ENamedElement)this.getReadLines_Uri(), source, new String[]{"description", "URI to read lines from. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.selectRowsEClass, source, new String[]{"description", "Takes a table from input and returns the table with rows filtered by column and criteria.", "returns", "Copy of input table object with filtered rows.", "example", "select-rows -column \"columnName\" -value \"value\" -match exact|glob|regexp"});
        this.addAnnotation((ENamedElement)this.getSelectRows_Table(), source, new String[]{"description", "Table to take columns from"});
        this.addAnnotation((ENamedElement)this.getSelectRows_Column(), source, new String[]{"description", "Column named to filter rows by."});
        this.addAnnotation((ENamedElement)this.getSelectRows_Value(), source, new String[]{"description", "Pattern to match rows to."});
        this.addAnnotation((ENamedElement)this.getSelectRows_Match(), source, new String[]{"description", "Describes the matching behaviour for rows.\r\n<ul>\r\n<li><b>glob</b> &ndash; wildcard matching</li>\r\n<li><b>exact</b> &ndash; value should be equals to pattern</li>\r\n<li><b>regexp</b> &ndash; value must match java regular expression</li>\r\n</ul>"});
        this.addAnnotation((ENamedElement)this.excludeRowsEClass, source, new String[]{"description", "Takes a table from input and returns the table with rows filtered by column and criteria.", "returns", "Copy of input table object with filtered rows.", "example", "exclude-rows -column \"columnName\" -value \"value\" -match exact|glob|regex"});
        this.addAnnotation((ENamedElement)this.getExcludeRows_Table(), source, new String[]{"description", "Table to take columns from"});
        this.addAnnotation((ENamedElement)this.getExcludeRows_Column(), source, new String[]{"description", "Column named to filter rows by."});
        this.addAnnotation((ENamedElement)this.getExcludeRows_Value(), source, new String[]{"description", "Pattern to match rows to."});
        this.addAnnotation((ENamedElement)this.getExcludeRows_Match(), source, new String[]{"description", "Describes the matching behaviour for rows.\n<ul>\n<li><b>glob</b> &ndash; wildcard matching</li>\n<li><b>exact</b> &ndash; value should be equals to pattern</li>\n<li><b>regext</b> &ndash; value must match java regular expression</li>\n</ul>"});
        this.addAnnotation((ENamedElement)this.asTableDataEClass, source, new String[]{"description", "Converts its input to table data format, exactly the same as <code>get-table-data</code> returns.", "returns", "Table data.", "example", "get-log -levels error | as-table-data | write-csv-file \"workspace:/Project/file2.csv\""});
        this.addAnnotation((ENamedElement)this.getAsTableData_Input(), source, new String[]{"description", "Object(s) to convert from."});
        this.addAnnotation((ENamedElement)this.readPropertiesEClass, source, new String[]{"description", "Parses given .properties file. Fails if file is not found or format is invalid", "returns", "ECL map with values from properties file", "example", "...get-item \"General Registers/pc\" | get-property \"values[\\'Value\\']\"\n| matches [format \"%s.*\" [read-properties -uri \"file:/C:/Users/Administrator/Desktop/p.properties\" | get myKey]] | verify-true\n"});
        this.addAnnotation((ENamedElement)this.getReadProperties_Uri(), source, new String[]{"description", "URI to a file to read. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.readFileEClass, source, new String[]{"description", "Reads file identified by uri and writes it contents into output pipe", "example", "//Displays alert with file content\r\nshow-alert [read-file \"file:/path/to/your/file\"]\r\n\r\n\r\n\r\n"});
        this.addAnnotation((ENamedElement)this.getReadFile_Uri(), source, new String[]{"description", "URI to read file from. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.setPageNameEClass, source, new String[]{"description", "Set page name to table", "returns", "The value of <code>table</code> argument.", "example", "get-view \"Error Log\" | get-tree | expand-all\nget-view \"Error Log\" | get-tree | get-table-data\n\t| set-page-name \"Table\" | write-excel-file \"workspace:/MyProject/AssertData/table.xls\"\n\nread-excel-file \"workspace:/MyProject/AssertData/table.xls\"\n\t| get pageName | equals \"Table\" | assert-true"});
        this.addAnnotation((ENamedElement)this.getSetPageName_Table(), source, new String[]{"description", "Table to set page name to"});
        this.addAnnotation((ENamedElement)this.getSetPageName_Name(), source, new String[]{"description", "Page name to set"});
        this.addAnnotation((ENamedElement)this.listAsTableDataEClass, source, new String[]{"description", "Converts input list to table data format", "returns", "<code>Table</code> EMF Object", "example", "proc newTable [val table] [val name] {\n\t$table | list-as-table-data | set-page-name $name\n}\n\nglobal [val devices [list\n\t[list \"Device Name\" \"Device Target\"]\n\t[list \"Device 1\" \"Info 1\"]\n\t[list \"Device 2\" \"Info 2\"]\n\t[list \"Device 3\" \"Info 3\"]\n]]\n\nnewTable $devices \"Devices\"\n\t| write-excel-file \"workspace:/excel/devices.xls\""});
        this.addAnnotation((ENamedElement)this.getListAsTableData_List(), source, new String[]{"description", "List of List of String to convert to Table"});
        this.addAnnotation((ENamedElement)this.readXmlFileEClass, source, new String[]{"description", "Parses given xml file into tree and write it to output pipe. Fails if file is not found or if it is invalid xml.", "returns", "<code>Tree</code> EMF Object", "example", "proc logDevice [val device] {\n\tif [$device | has-attr \"id\"] {\n\t\tlog [format \"Device ID: %s\" [$device | get-attr \"id\"]]\n\t}\n\tlog [format \"Device Name: %s\" [$device | get-nodes \"DeviceName\" | get text]]\n\tlog [format \"Device Target: %s\" [$device | get-nodes \"DeviceTarget\"  | get text]]\n}\n \n \nglobal [val supportedDevices [\n\tread-xml-file \"workspace:/xml/devices.xml\"\n\t\t| get-nodes \"SupportedDevices\" | get-nodes \"Device\" | to-list\n]]\n \n$supportedDevices | each [val device] {\n\tlogDevice $device\n}"});
        this.addAnnotation((ENamedElement)this.getReadXmlFile_Uri(), source, new String[]{"description", "URI to read xml data from. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.getReadXmlFile_XPath(), source, new String[]{"description", "XPath expression to find xml nodes"});
        this.addAnnotation((ENamedElement)this.writeXmlFileEClass, source, new String[]{"description", "Writes tree from input pipe to into xml file", "returns", "The value of <code>tree</code> argument", "example", "proc newDevice [val id] [val name] [val target] {\n\ttree-node \"Device\"\n\t\t[map [entry \"id\" $id]]\n\t\t[tree-node -name \"DeviceName\" -text $name]\n\t\t[tree-node -name \"DeviceTarget\" -text $target]\n}\n \n \nglobal [val supportedDevices [tree-node \"SupportedDevices\"\n\t[newDevice \"1\" \"device 1\" \"target 1\"]\n\t[newDevice \"2\" \"device 2\" \"target 2\"]\n\t[newDevice \"3\" \"device 3\" \"target 3\"]\n]]\n \nglobal [val allDevices [tree-node \"AllDevices\"\n\t[newDevice \"1\" \"device 1\" \"target 1\"]\n\t[newDevice \"2\" \"device 2\" \"target 2\"]\n\t[newDevice \"3\" \"device 3\" \"target 3\"]\n\t[newDevice \"4\" \"device 4\" \"target 4\"]\n\t[newDevice \"5\" \"device 5\" \"target 5\"]\n]]\n \nglobal [val tree [\n\ttree-node \"DevicesInfo\" $supportedDevices $allDevices\n]]\n \n$tree | write-xml-file \"workspace:/xml/devices.xml\""});
        this.addAnnotation((ENamedElement)this.getWriteXmlFile_Tree(), source, new String[]{"description", "Tree to write"});
        this.addAnnotation((ENamedElement)this.getWriteXmlFile_Uri(), source, new String[]{"description", "URI to write xml data to. Currently supported schemes are workspace:/ for files in workspace and file:/ for files on local file system"});
        this.addAnnotation((ENamedElement)this.treeNodeEClass, source, new String[]{"description", "Creates a new tree node", "returns", "<code>Tree</code> EMF Object", "example", "tree-node \"Device\"\n\t[map [entry \"id\" \"1\"]]\n\t[tree-node -name \"DeviceName\" -text \"device\"]\n\t[tree-node -name \"DeviceTarget\" -text \"target\"]"});
        this.addAnnotation((ENamedElement)this.getTreeNode_Name(), source, new String[]{"description", "Name of the new node"});
        this.addAnnotation((ENamedElement)this.getTreeNode_Attrs(), source, new String[]{"description", "Map with node attributes"});
        this.addAnnotation((ENamedElement)this.getTreeNode_Children(), source, new String[]{"description", "Children of the new node"});
        this.addAnnotation((ENamedElement)this.getTreeNode_Text(), source, new String[]{"description", "Text of the new node"});
        this.addAnnotation((ENamedElement)this.getAttrsEClass, source, new String[]{"description", "Gets attributes from the object", "returns", "Map with object attributes", "example", "tree-node \"Device\" [map [entry \"id\" \"1\"] [entry \"name\" \"first\"]]\n\t| get-attrs | get \"name\" | log"});
        this.addAnnotation((ENamedElement)this.getGetAttrs_Object(), source, new String[]{"description", "Object to get attributes from"});
        this.addAnnotation((ENamedElement)this.getAttrEClass, source, new String[]{"description", "Gets attribute from the object by name. Fails if attribute is not found.", "returns", "Value of the attribute", "example", "tree-node \"Device\" [map [entry \"id\" \"1\"] [entry \"name\" \"first\"]]\n\t| get-attr \"name\" | log"});
        this.addAnnotation((ENamedElement)this.getGetAttr_Object(), source, new String[]{"description", "Tree node to get attribute from"});
        this.addAnnotation((ENamedElement)this.getGetAttr_Name(), source, new String[]{"description", "Name of the attribute"});
        this.addAnnotation((ENamedElement)this.setAttrEClass, source, new String[]{"description", "Sets value of the object attribute. If <code>value</code> parameter is not specified, the attribute will be removed.", "returns", "The value of <code>object</code> argument", "example", "tree-node \"Device\" [map [entry \"id\" \"1\"] [entry \"name\" \"first\"]]\n\t| get-attr \"name\" | log\n\n\n--set-attr-\n\n\n\ntree-node \"Device\" [map [entry \"id\" \"1\"] [entry \"name\" \"first\"]]\n\t| set-attr \"name\" \"second\" | get-attr \"name\" | log"});
        this.addAnnotation((ENamedElement)this.getSetAttr_Object(), source, new String[]{"description", "Object to set attribute to"});
        this.addAnnotation((ENamedElement)this.getSetAttr_Name(), source, new String[]{"description", "Name of the attribute"});
        this.addAnnotation((ENamedElement)this.getSetAttr_Value(), source, new String[]{"description", "New value of the attribute"});
        this.addAnnotation((ENamedElement)this.hasAttrEClass, source, new String[]{"description", "Checks if the object has attribute", "returns", "<code>true</code> when attribute is exist, <code>false</code> otherwise", "example", "tree-node \"Device\" [map [entry \"id\" \"1\"] [entry \"name\" \"first\"]]\n\t| has-attr \"name\" | log"});
        this.addAnnotation((ENamedElement)this.getHasAttr_Object(), source, new String[]{"description", "Object to check attribute from"});
        this.addAnnotation((ENamedElement)this.getHasAttr_Name(), source, new String[]{"description", "Name of the attribute"});
        this.addAnnotation((ENamedElement)this.getNodesEClass, source, new String[]{"description", "Gets child nodes from the object and writes them into output pipe. Fails if <code>pos</code> of <code>len</code> parameter is out of range.", "returns", "Child nodes of the object", "example", "proc newDevice [val id] [val name] [val target] {\n\ttree-node \"Device\"\n\t\t[map [entry \"id\" $id]]\n\t\t[tree-node -name \"DeviceName\" -text $name]\n\t\t[tree-node -name \"DeviceTarget\" -text $target]\n}\n \nglobal [val supportedDevices [tree-node \"SupportedDevices\"\n\t[newDevice \"1\" \"device 1\" \"target 1\"]\n\t[newDevice \"2\" \"device 2\" \"target 2\"]\n\t[newDevice \"3\" \"device 3\" \"target 3\"]\n]]\n \n$supportedDevices | get-nodes \"Device\" -pos 1 -len 1\n\t| get-nodes \"DeviceName\" | get text\n\t| equals \"device 2\" | verify-true"});
        this.addAnnotation((ENamedElement)this.getGetNodes_Object(), source, new String[]{"description", "Object to get child nodes from"});
        this.addAnnotation((ENamedElement)this.getGetNodes_Name(), source, new String[]{"description", "Name of the nodes"});
        this.addAnnotation((ENamedElement)this.getGetNodes_Pos(), source, new String[]{"description", "Start position. If <code>name</code> attribute is provided, <code>pos</code> is relative to the node list filtered by name."});
        this.addAnnotation((ENamedElement)this.getGetNodes_Len(), source, new String[]{"description", "Count of nodes. Default value is <code>-1</code> and it means the end of the node list. If <code>name</code> attribute is provided, <code>len</code> is relative to the node list filtered by name."});
        this.addAnnotation((ENamedElement)this.appendEClass, source, new String[]{"description", "Adds child nodes to the object. Fails if <code>index</code> parameter is out of range.", "returns", "The value of <code>object</code> argument", "example", "tree-node \"Device\" [tree-node -name \"DeviceName\" -text \"device\"]\n\t| append [tree-node -name \"DeviceTarget\" -text \"target\"] -index 0"});
        this.addAnnotation((ENamedElement)this.getAppend_Object(), source, new String[]{"description", "Object to add child nodes to"});
        this.addAnnotation((ENamedElement)this.getAppend_Children(), source, new String[]{"description", "New child nodes to add to the object"});
        this.addAnnotation((ENamedElement)this.getAppend_Index(), source, new String[]{"description", "Index of the first child node added in the node list. Min value is <code>0</code> and max value is size of node list. Default value is <code>-1</code> and it means size of node list."});
        this.addAnnotation((ENamedElement)this.removeEClass, source, new String[]{"description", "Removes child node from the object by index. Fails if <code>index</code> parameter is out of range.", "returns", "The value of <code>object</code> argument", "example", "tree-node \"Device\"\n\t[tree-node -name \"DeviceName\" -text \"device\"]\n\t[tree-node -name \"DeviceTarget\" -text \"target\"]\n\t\t| remove -index 1"});
        this.addAnnotation((ENamedElement)this.getRemove_Object(), source, new String[]{"description", "Object to remove child node from"});
        this.addAnnotation((ENamedElement)this.getRemove_Index(), source, new String[]{"description", "Index of the child node. Min value is <code>0</code> and max value is the last index in the node list. Default value is <code>-1</code> and the last index in the node list."});
    }

    protected void createInternalAnnotations() {
        String source = "http://www.eclipse.org/ecl/internal";
        this.addAnnotation((ENamedElement)this.printEClass, source, new String[0]);
    }

    protected void createInputAnnotations() {
        String source = "http://www.eclipse.org/ecl/input";
        this.addAnnotation((ENamedElement)this.getPrint_Input(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getWriteCsvFile_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getExcludeColumns_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getSelectColumns_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getReadLines_Uri(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getSelectRows_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getExcludeRows_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getAsTableData_Input(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getReadFile_Uri(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getSetPageName_Table(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getListAsTableData_List(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getWriteXmlFile_Tree(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getGetAttrs_Object(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getGetAttr_Object(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getSetAttr_Object(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getHasAttr_Object(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getGetNodes_Object(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getAppend_Object(), source, new String[0]);
        this.addAnnotation((ENamedElement)this.getRemove_Object(), source, new String[0]);
    }
}

