/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.IPlatformEntry;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteContentProvider;
import org.eclipse.pde.internal.build.site.compatibility.SiteManager;

public class BuildTimeFeature
extends Feature {
    public static final String FEATURE_FILE = "feature";
    public static final String FEATURE_XML = "feature.xml";
    private Boolean binary = null;
    private int contextQualifierLength = -1;
    private BuildTimeSiteContentProvider contentProvider = null;
    private BuildTimeSite site = null;
    private Path path = null;
    private String rootLocation = null;
    private static final Path FEATURE_XML_PATH = Path.of("feature.xml", new String[0]);

    public BuildTimeFeature(String id, String version) {
        super(id, version);
    }

    public BuildTimeFeature() {
        super("", "");
    }

    public FeatureEntry[] getRawIncludedFeatureReferences() {
        FeatureEntry[] entries;
        ArrayList<FeatureEntry> included = new ArrayList<FeatureEntry>();
        FeatureEntry[] featureEntryArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (!entry.isRequires() && !entry.isPlugin()) {
                included.add(entry);
            }
            ++n2;
        }
        return included.toArray(new FeatureEntry[included.size()]);
    }

    public FeatureEntry[] getIncludedFeatureReferences() {
        FeatureEntry[] entries;
        ArrayList<FeatureEntry> included = new ArrayList<FeatureEntry>();
        FeatureEntry[] featureEntryArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (!entry.isRequires() && !entry.isPlugin() && SiteManager.isValidEnvironment((IPlatformEntry)entry)) {
                included.add(entry);
            }
            ++n2;
        }
        return included.toArray(new FeatureEntry[included.size()]);
    }

    public FeatureEntry[] getPluginEntries() {
        FeatureEntry[] entries;
        ArrayList<FeatureEntry> plugins = new ArrayList<FeatureEntry>();
        FeatureEntry[] featureEntryArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (!entry.isRequires() && entry.isPlugin() && SiteManager.isValidEnvironment((IPlatformEntry)entry)) {
                plugins.add(entry);
            }
            ++n2;
        }
        return plugins.toArray(new FeatureEntry[plugins.size()]);
    }

    public FeatureEntry[] getRawPluginEntries() {
        FeatureEntry[] entries;
        ArrayList<FeatureEntry> plugins = new ArrayList<FeatureEntry>();
        FeatureEntry[] featureEntryArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (!entry.isRequires() && entry.isPlugin()) {
                plugins.add(entry);
            }
            ++n2;
        }
        return plugins.toArray(new FeatureEntry[plugins.size()]);
    }

    public FeatureEntry[] getImports() {
        FeatureEntry[] entries;
        ArrayList<FeatureEntry> imports = new ArrayList<FeatureEntry>();
        FeatureEntry[] featureEntryArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (entry.isRequires()) {
                imports.add(entry);
            }
            ++n2;
        }
        return imports.toArray(new FeatureEntry[imports.size()]);
    }

    public boolean isBinary() {
        if (this.binary == null) {
            String root = this.getRootLocation();
            File properties = new File(root, "build.properties");
            this.binary = !properties.exists() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.binary;
    }

    public void setBinary(boolean isCompiled) {
        this.binary = isCompiled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setContextQualifierLength(int l) {
        this.contextQualifierLength = l;
    }

    public int getContextQualifierLength() {
        return this.contextQualifierLength;
    }

    public void setSite(BuildTimeSite site) {
        this.site = site;
    }

    public BuildTimeSite getSite() {
        return this.site;
    }

    public void setFeatureContentProvider(BuildTimeSiteContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public BuildTimeSiteContentProvider getFeatureContentProvider() {
        return this.contentProvider;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getRootLocation() {
        if (this.rootLocation == null) {
            Path location = this.getPath();
            if (location == null) {
                return null;
            }
            if ((location = location.toAbsolutePath()).endsWith(FEATURE_XML)) {
                location = location.getParent();
            }
            this.rootLocation = location.toString() + File.separator;
        }
        return this.rootLocation;
    }

    public FeatureEntry findPluginEntry(String id, String version) {
        FeatureEntry[] entries;
        FeatureEntry[] featureEntryArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (entry.isPlugin() && entry.getId().equals(id) && Utils.matchVersions(version, entry.getVersion())) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    static Path ensureEndsWithFeatureXml(Path path) {
        return path != null && !path.endsWith(FEATURE_XML_PATH) ? path.resolve(FEATURE_XML_PATH) : path;
    }
}

