/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.OomphWizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class SetupWizardDialog
extends OomphWizardDialog {
    public SetupWizardDialog(Shell parentShell, SetupWizard wizard) {
        super(parentShell, (IWizard)wizard, true);
        if (wizard.getTrigger() != Trigger.BOOTSTRAP) {
            this.setNonModal();
        }
    }

    protected void setNonModal() {
        this.setShellStyle(0xC70 | SetupWizardDialog.getDefaultOrientation());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        AccessUtil.setKey((Widget)this.getButton(14), (Object)"back");
        AccessUtil.setKey((Widget)this.getButton(15), (Object)"next");
        AccessUtil.setKey((Widget)this.getButton(16), (Object)"finish");
        AccessUtil.setKey((Widget)this.getButton(1), (Object)"cancel");
    }

    protected void createToolItemsForToolBar(ToolBar toolBar) {
        ToolItem helpButton = toolBar.getItems()[0];
        AccessUtil.setKey((Widget)helpButton, (Object)"help");
    }

    protected void handleInactivity(Display display, boolean inactive) {
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof SetupWizardPage) {
            SetupWizardPage setupWizardPage = (SetupWizardPage)currentPage;
            setupWizardPage.handleInactivity(display, inactive);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return SetupUIPlugin.INSTANCE.getDialogSettings(this.getWizard().getClass().getName());
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected Point basicGetInitialSize() {
        return this.getShell().computeSize(-1, -1, true);
    }

    protected Point getInitialSize() {
        Point computedSize = this.basicGetInitialSize();
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(computedSize.x, initialSize.x), Math.max(computedSize.y, initialSize.y));
    }
}

