/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RoundingMode;
import org.eclipse.swt.widgets.Monitor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class Rectangle
implements Serializable,
Cloneable {
    public int x;
    public int y;
    public int width;
    public int height;
    static final long serialVersionUID = 3256439218279428914L;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    private Rectangle() {
    }

    public void add(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        int left = this.x < rect.x ? this.x : rect.x;
        int top = this.y < rect.y ? this.y : rect.y;
        int lhs = this.x + this.width;
        int rhs = rect.x + rect.width;
        int right = lhs > rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        int bottom = lhs > rhs ? lhs : rhs;
        this.x = left;
        this.y = top;
        this.width = right - left;
        this.height = bottom - top;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void other;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)object;
        return other.x == this.x && other.y == this.y && other.width == this.width && other.height == this.height;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public void intersect(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        if (this == rect) {
            return;
        }
        int left = this.x > rect.x ? this.x : rect.x;
        int top = this.y > rect.y ? this.y : rect.y;
        int lhs = this.x + this.width;
        int rhs = rect.x + rect.width;
        int right = lhs < rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        int bottom = lhs < rhs ? lhs : rhs;
        this.x = right < left ? 0 : left;
        this.y = bottom < top ? 0 : top;
        this.width = right < left ? 0 : right - left;
        this.height = bottom < top ? 0 : bottom - top;
    }

    public Rectangle intersection(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        if (this == rect) {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
        int left = this.x > rect.x ? this.x : rect.x;
        int top = this.y > rect.y ? this.y : rect.y;
        int lhs = this.x + this.width;
        int rhs = rect.x + rect.width;
        int right = lhs < rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        int bottom = lhs < rhs ? lhs : rhs;
        return new Rectangle(right < left ? 0 : left, bottom < top ? 0 : top, right < left ? 0 : right - left, bottom < top ? 0 : bottom - top);
    }

    public boolean intersects(int x, int y, int width, int height) {
        return x < this.x + this.width && y < this.y + this.height && x + width > this.x && y + height > this.y;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return rect == this || this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public String toString() {
        return "Rectangle {" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "}";
    }

    public Rectangle union(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        int left = this.x < rect.x ? this.x : rect.x;
        int top = this.y < rect.y ? this.y : rect.y;
        int lhs = this.x + this.width;
        int rhs = rect.x + rect.width;
        int right = lhs > rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        int bottom = lhs > rhs ? lhs : rhs;
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public static Rectangle of(Point topLeft, int width, int height) {
        if (topLeft instanceof Point.WithMonitor) {
            Point.WithMonitor monitorAwareTopLeft = (Point.WithMonitor)topLeft;
            return new WithMonitor(monitorAwareTopLeft.getX(), monitorAwareTopLeft.getY(), (float)width, (float)height, monitorAwareTopLeft.getMonitor());
        }
        return new Rectangle(topLeft.x, topLeft.y, width, height);
    }

    public Rectangle clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class OfFloat
    extends Rectangle {
        private static final long serialVersionUID = -3006999002677468391L;
        private float residualX;
        private float residualY;
        private float residualWidth;
        private float residualHeight;
        private RoundingMode locationRounding = RoundingMode.ROUND;
        private RoundingMode sizeRounding = RoundingMode.ROUND;

        public OfFloat(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public OfFloat(float x, float y, float width, float height) {
            this(x, y, width, height, RoundingMode.ROUND, RoundingMode.ROUND);
        }

        private OfFloat(float x, float y, float width, float height, RoundingMode locationRounding, RoundingMode sizeRounding) {
            this.locationRounding = locationRounding;
            this.sizeRounding = sizeRounding;
            this.setX(x);
            this.setY(y);
            this.setWidth(width);
            this.setHeight(height);
        }

        public float getX() {
            return (float)this.x + this.residualX;
        }

        public float getY() {
            return (float)this.y + this.residualY;
        }

        public float getWidth() {
            return (float)this.width + this.residualWidth;
        }

        public float getHeight() {
            return (float)this.height + this.residualHeight;
        }

        public void setX(float x) {
            this.x = this.locationRounding.round(x);
            this.residualX = x - (float)this.x;
            this.setWidth(this.getWidth());
        }

        public void setY(float y) {
            this.y = this.locationRounding.round(y);
            this.residualY = y - (float)this.y;
            this.setHeight(this.getHeight());
        }

        public void setWidth(float width) {
            this.width = this.sizeRounding.round(width + this.getX()) - this.x;
            this.residualWidth = width - (float)this.width;
        }

        public void setHeight(float height) {
            this.height = this.sizeRounding.round(height + this.getY()) - this.y;
            this.residualHeight = height - (float)this.height;
        }

        public Point.OfFloat getTopLeft() {
            return new Point.OfFloat(this.getX(), this.getY(), this.locationRounding);
        }

        public Point.OfFloat getBottomRight() {
            return new Point.OfFloat(this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.sizeRounding);
        }

        @Override
        public OfFloat clone() {
            return new OfFloat(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.locationRounding, this.sizeRounding);
        }

        public static OfFloat from(Rectangle rectangle) {
            if (rectangle instanceof OfFloat) {
                OfFloat rectangleOfFloat = (OfFloat)rectangle;
                return rectangleOfFloat.clone();
            }
            return new OfFloat(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static final class WithMonitor
    extends OfFloat {
        private static final long serialVersionUID = 5041911840525116925L;
        private final Monitor monitor;

        public WithMonitor(int x, int y, int width, int height, Monitor monitor) {
            super(x, y, width, height);
            this.monitor = monitor;
        }

        private WithMonitor(float x, float y, float width, float height, Monitor monitor) {
            super(x, y, width, height);
            this.monitor = monitor;
        }

        public Monitor getMonitor() {
            return this.monitor;
        }

        @Override
        public WithMonitor clone() {
            return new WithMonitor(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.monitor);
        }
    }
}

