/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ItemElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTImageHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.w3c.dom.Node;

public class ToolItemElement
extends ItemElement {
    private boolean isSelected = false;
    boolean dynamicEnabled = Boolean.getBoolean("org.eclipse.e4.ui.css.dynamic");
    private final SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ToolItem toolItem = ToolItemElement.this.getToolItem();
            if (toolItem != null && !toolItem.isDisposed()) {
                ToolItemElement.this.isSelected = ToolItemElement.this.getToolItem().getSelection();
                ToolItemElement.this.doApplyStyles();
            }
        }
    };

    public ToolItemElement(ToolItem toolItem, CSSEngine engine) {
        super((Item)toolItem, engine);
        if (!this.dynamicEnabled) {
            return;
        }
        toolItem.addSelectionListener(this.selectionListener);
    }

    public ToolItem getToolItem() {
        return (ToolItem)this.getNativeWidget();
    }

    public void dispose() {
        super.dispose();
        if (!this.dynamicEnabled) {
            return;
        }
        ToolItem toolItem = this.getToolItem();
        if (!toolItem.isDisposed()) {
            toolItem.removeSelectionListener(this.selectionListener);
        }
    }

    @Override
    public Node getParentNode() {
        ToolItem item = this.getToolItem();
        ToolBar parent = item.getParent();
        if (parent != null) {
            return this.getElement(parent);
        }
        return null;
    }

    @Override
    public Node item(int index) {
        Control control;
        ToolItem item = this.getToolItem();
        if ((item.getStyle() & 2) == 2 && (control = item.getControl()) != null) {
            return this.getElement(control);
        }
        return null;
    }

    @Override
    public int getLength() {
        ToolItem item = this.getToolItem();
        return (item.getStyle() & 2) == 2 && item.getControl() != null ? 1 : 0;
    }

    public boolean isPseudoInstanceOf(String s) {
        if ("checked".equalsIgnoreCase(s)) {
            return this.isSelected;
        }
        return super.isPseudoInstanceOf(s);
    }

    @Override
    public void reset() {
        CSSSWTImageHelper.restoreDefaultImage(this.getToolItem());
        this.getToolItem().setBackground(null);
        this.getToolItem().setForeground(null);
        super.reset();
    }
}

