/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.renderers.swt.AbstractContributionItem;
import org.eclipse.swt.widgets.Display;

public class ToolItemUpdater
implements Runnable {
    private static int DELAY = 100;
    private long timestampOfEarliestQueuedUpdate = 0L;
    private final List<AbstractContributionItem> itemsToCheck = new ArrayList<AbstractContributionItem>();
    private final List<AbstractContributionItem> orphanedToolItems = new ArrayList<AbstractContributionItem>();
    private final Set<AbstractContributionItem> itemsToUpdateLater = new LinkedHashSet<AbstractContributionItem>();

    public ToolItemUpdater() {
        String delayProperty = System.getProperty("ToolItemUpdaterDelayInMs");
        if (delayProperty != null) {
            DELAY = Integer.parseInt(delayProperty);
        }
    }

    void registerItem(AbstractContributionItem item) {
        if (!this.itemsToCheck.contains((Object)item)) {
            this.itemsToCheck.add(item);
        }
    }

    void removeItem(AbstractContributionItem item) {
        this.itemsToCheck.remove((Object)item);
    }

    public void updateContributionItems(Selector selector) {
        boolean doRunNow = false;
        for (AbstractContributionItem ci : this.itemsToCheck) {
            if (ci.getModel() != null && ci.getModel().getParent() != null) {
                if (!selector.select((MApplicationElement)ci.getModel())) continue;
                this.itemsToUpdateLater.add(ci);
                if (this.timestampOfEarliestQueuedUpdate == 0L) {
                    this.timestampOfEarliestQueuedUpdate = System.nanoTime();
                }
                if (System.nanoTime() - this.timestampOfEarliestQueuedUpdate > (long)DELAY * 1000000L) {
                    doRunNow = true;
                    continue;
                }
                Display.getDefault().timerExec(DELAY, (Runnable)this);
                continue;
            }
            this.orphanedToolItems.add(ci);
        }
        if (!this.orphanedToolItems.isEmpty()) {
            this.itemsToCheck.removeAll(this.orphanedToolItems);
            this.orphanedToolItems.clear();
        }
        if (doRunNow) {
            this.run();
        }
    }

    @Override
    public void run() {
        this.timestampOfEarliestQueuedUpdate = 0L;
        AbstractContributionItem[] copy = this.itemsToUpdateLater.toArray(new AbstractContributionItem[0]);
        this.itemsToUpdateLater.clear();
        AbstractContributionItem[] abstractContributionItemArray = copy;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractContributionItem it = abstractContributionItemArray[n2];
            it.updateItemEnablement();
            ++n2;
        }
    }
}

