/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class Positions {
    public static Position of(int lineIndex, IDocument document, boolean leadingSpaces) throws BadLocationException {
        int offset = document.getLineOffset(lineIndex);
        int lineLength = document.getLineLength(lineIndex);
        String line = document.get(offset, lineLength);
        if (leadingSpaces) {
            offset += Positions.getLeadingSpaces(line);
        }
        return new Position(offset, 1);
    }

    private static int getLeadingSpaces(String line) {
        char[] chars;
        int counter = 0;
        char[] cArray = chars = line.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\t') {
                ++counter;
            } else {
                if (c != ' ') break;
                ++counter;
            }
            ++n2;
        }
        return counter;
    }
}

