/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

public abstract class Types {
    public static final int TEAM_FLAG = 1;
    public static final int ROLE_FLAG = 2;
    public static final String VOID = "V";
    public static final String BOOLEAN = "Z";
    public static final String CHAR = "C";
    public static final String BYTE = "B";
    public static final String SHORT = "S";
    public static final String INT = "I";
    public static final String FLOAT = "F";
    public static final String LONG = "J";
    public static final String DOUBLE = "D";
    private static final String ARRAY = "[";

    public static String getAsArrayType(String typeName) {
        if (typeName.length() == 1) {
            switch (typeName.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return ARRAY + typeName;
                }
            }
        }
        return "[L" + typeName + ";";
    }

    public static String getAsInternalType(String className) {
        return "L" + className + ";";
    }

    public static String getAsInternalType(Class<?> clazz) {
        Object type = null;
        if (clazz.isPrimitive()) {
            String name = clazz.getName();
            if (name.compareTo("void") == 0) {
                type = VOID;
            } else if (name.compareTo("boolean") == 0) {
                type = BOOLEAN;
            } else if (name.compareTo("char") == 0) {
                type = CHAR;
            } else if (name.compareTo("byte") == 0) {
                type = BYTE;
            } else if (name.compareTo("short") == 0) {
                type = SHORT;
            } else if (name.compareTo("int") == 0) {
                type = INT;
            } else if (name.compareTo("float") == 0) {
                type = FLOAT;
            } else if (name.compareTo("long") == 0) {
                type = LONG;
            } else if (name.compareTo("double") == 0) {
                type = DOUBLE;
            }
        } else {
            type = clazz.getName().replace('.', '/');
            if (!clazz.isArray()) {
                type = "L" + (String)type + ";";
            }
        }
        return type;
    }

    public static String getTypeStringForMethod(String returnType, String[] paramTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (paramTypes != null) {
            String[] stringArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String paramType = stringArray[n2];
                buf.append(paramType);
                ++n2;
            }
        }
        buf.append(')');
        buf.append(returnType);
        return buf.toString();
    }

    public static String getTypeStringForMethod(Class<?> returnType, Class<?>[] paramTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (paramTypes != null) {
            Class<?>[] classArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paramType = classArray[n2];
                buf.append(Types.getAsInternalType(paramType));
                ++n2;
            }
        }
        buf.append(')');
        buf.append(Types.getAsInternalType(returnType));
        return buf.toString();
    }
}

