/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.pde.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.objectteams.otdt.core.ext.OTDTPlugin;
import org.eclipse.objectteams.otdt.core.ext.OTREContainer;
import org.eclipse.objectteams.otdt.internal.pde.ui.ClasspathComputerAdapter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.ui.templates.PluginReference;

public class OTPluginProject {
    public static void makeOTPlugin(IProject project) throws CoreException {
        IJavaProject javaProject;
        String value;
        OTPluginProject.addOTNatureAndBuilder(project);
        OTREContainer.initializeOTJProject((IProject)project);
        if (PluginProject.isPluginProject((IProject)project)) {
            WorkspaceBundlePluginModel fModel = new WorkspaceBundlePluginModel(project.getFile("META-INF/MANIFEST.MF"), project.getFile("plugin.xml"));
            IPluginBase pluginBase = fModel.getPluginBase();
            PluginReference ref = new PluginReference("org.eclipse.objectteams.otequinox", null, 0);
            IPluginImport iimport = fModel.getPluginFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            pluginBase.add(iimport);
            fModel.save();
            ClasspathComputerAdapter.sortClasspathEntries(project);
        }
        if (!(value = (javaProject = JavaCore.create((IProject)project)).getOption("org.eclipse.objectteams.otdt.compiler.problem.binding_conventions", true)).equals("error")) {
            javaProject.setOption("org.eclipse.objectteams.otdt.compiler.problem.binding_conventions", "error");
        }
        javaProject.setOption("org.eclipse.objectteams.otdt.compiler.option.weaving_scheme", CompilerOptions.WeavingScheme.OTDRE.name());
    }

    public static void addOTNatureAndBuilder(IProject project) throws CoreException {
        IProjectDescription prjDesc = project.getDescription();
        prjDesc.setNatureIds(OTDTPlugin.createProjectNatures((IProjectDescription)prjDesc));
        ICommand[] buildSpecs = prjDesc.getBuildSpec();
        prjDesc.setBuildSpec(OTPluginProject.replaceOrAddOTBuilder(prjDesc, buildSpecs));
        project.setDescription(prjDesc, null);
    }

    private static ICommand[] replaceOrAddOTBuilder(IProjectDescription prjDesc, ICommand[] buildSpecs) {
        ICommand otBuildCmd = OTDTPlugin.createProjectBuildCommand((IProjectDescription)prjDesc);
        int i = 0;
        while (i < buildSpecs.length) {
            if (buildSpecs[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                buildSpecs[i] = otBuildCmd;
                return buildSpecs;
            }
            ++i;
        }
        int len = buildSpecs.length;
        ICommand[] iCommandArray = buildSpecs;
        buildSpecs = new ICommand[len + 1];
        System.arraycopy(iCommandArray, 0, buildSpecs, 1, len);
        buildSpecs[0] = otBuildCmd;
        return buildSpecs;
    }
}

