/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IMethodSpec;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public abstract class MethodMapping
extends OTJavaElement
implements IMethodMapping {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    private int declarationSourceStart;
    private int sourceStart;
    private int sourceEnd;
    private int declarationSourceEnd;
    private IMethod roleMethod;
    protected MethodData roleMethodHandle;
    private boolean hasSearchedRoleMethod;
    private boolean hasSignature;

    public MethodMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int type, IMethod correspondingJavaElem, IType parent, MethodData roleMethodHandle, boolean hasSignature) {
        super(type, correspondingJavaElem, parent);
        this.roleMethodHandle = roleMethodHandle;
        this.declarationSourceStart = declarationSourceStart;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.declarationSourceEnd = declarationSourceEnd;
        this.hasSignature = hasSignature;
    }

    public MethodMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int type, IMethod correspondingJavaElem, IType parent, MethodData roleMethodHandle, boolean hasSignature, boolean addAsChild) {
        super(type, correspondingJavaElem, parent, addAsChild);
        this.roleMethodHandle = roleMethodHandle;
        this.declarationSourceStart = declarationSourceStart;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.declarationSourceEnd = declarationSourceEnd;
        this.hasSignature = hasSignature;
    }

    @Override
    public String getHandleIdentifier() {
        StringBuilder buff = new StringBuilder();
        IJavaElement myParent = this.getParent();
        if (myParent instanceof IOTJavaElement) {
            myParent = ((IOTJavaElement)myParent).getCorrespondingJavaElement();
        }
        buff.append(myParent.getHandleMemento());
        char delimiter = '\u00a7';
        buff.append(delimiter);
        buff.append(this.getMappingKindChar());
        buff.append(this.hasSignature ? (char)'l' : 's');
        buff.append(delimiter);
        this.getNameForHandle(buff);
        this.getMethodForHandle(this.roleMethodHandle, buff);
        this.getBaseMethodsForHandle(buff);
        buff.append(delimiter);
        return buff.toString();
    }

    protected void getNameForHandle(StringBuilder buff) {
    }

    protected abstract char getMappingKindChar();

    protected abstract void getBaseMethodsForHandle(StringBuilder var1);

    protected void getMethodForHandle(IMethodSpec method, StringBuilder buff) {
        this.escapeMementoName(buff, method.getSelector());
        if (this.hasSignature) {
            String[] stringArray = method.getArgumentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String argType = stringArray[n2];
                buff.append('~');
                this.escapeMementoName(buff, argType);
                ++n2;
            }
            buff.append('~');
            this.escapeMementoName(buff, method.getReturnType());
        }
        buff.append('\u00a7');
    }

    public static MethodData createMethodData(MementoTokenizer memento, String selector) {
        String cur = memento.nextToken();
        if (cur.charAt(0) == '~') {
            cur = memento.nextToken();
        }
        ArrayList<String> argTypes = new ArrayList<String>();
        while (cur.charAt(0) != '\u00a7') {
            StringBuffer buffer = new StringBuffer();
            while (cur.length() == 1 && '[' == cur.charAt(0)) {
                buffer.append('[');
                if (!memento.hasMoreTokens()) break;
                cur = memento.nextToken();
            }
            buffer.append(cur);
            argTypes.add(buffer.toString());
            if (memento.nextToken().charAt(0) != '~') break;
            cur = memento.nextToken();
        }
        String returnType = null;
        if (argTypes.size() > 0) {
            returnType = (String)argTypes.remove(argTypes.size() - 1);
        }
        return new MethodData(selector, argTypes.toArray(new String[argTypes.size()]), null, returnType, false);
    }

    @Override
    public IMethod getRoleMethod() {
        if (!this.hasSearchedRoleMethod) {
            try {
                try {
                    this.roleMethod = this.findRoleMethod();
                }
                catch (JavaModelException ex) {
                    Util.log((Throwable)((Object)ex), "Failed to lookup original role method element!");
                    this.hasSearchedRoleMethod = true;
                }
            }
            finally {
                this.hasSearchedRoleMethod = true;
            }
        }
        return this.roleMethod;
    }

    @Override
    public MethodData getRoleMethodHandle() {
        return this.roleMethodHandle;
    }

    public IMethod getRoleMethodThrowingException() throws JavaModelException {
        if (!this.hasSearchedRoleMethod) {
            try {
                this.roleMethod = this.findRoleMethod();
            }
            finally {
                this.hasSearchedRoleMethod = true;
            }
        }
        return this.roleMethod;
    }

    public void setRoleMethod(IMethod meth) {
        this.roleMethod = meth;
    }

    @Override
    public String getElementName() {
        if (this.hasSignature) {
            return this.roleMethodHandle.toString();
        }
        return this.roleMethodHandle.getSelector();
    }

    @Override
    public int getDeclarationSourceStart() {
        return this.declarationSourceStart;
    }

    @Override
    public int getSourceStart() {
        return this.sourceStart;
    }

    @Override
    public int getSourceEnd() {
        return this.sourceEnd;
    }

    @Override
    public int getDeclarationSourceEnd() {
        return this.declarationSourceEnd;
    }

    @Override
    public boolean equals(Object obj) {
        MethodMapping other = (MethodMapping)obj;
        return super.equals(other) && this.getElementName().equals(other.getElementName());
    }

    @Override
    public String toString() {
        return "methodmapping: " + this.getElementName();
    }

    protected IMethod findRoleMethod() throws JavaModelException {
        IType[] implicitParents = TypeHelper.getImplicitSuperTypes(this.getDeclaringRole());
        HashSet<IType> allParents = new HashSet<IType>();
        int idx = 0;
        while (idx < implicitParents.length) {
            IType elem = implicitParents[idx];
            ITypeHierarchy hierarchy = elem.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] superTypes = hierarchy.getAllSuperclasses(elem);
            allParents.add(elem);
            if (superTypes.length > 0) {
                allParents.addAll(Arrays.asList(superTypes));
            }
            ++idx;
        }
        return this.findMethod(allParents.toArray(new IType[allParents.size()]), this.roleMethodHandle);
    }

    protected abstract IRoleType getDeclaringRole();

    protected IMethod findMethod(IType[] types, IMethodSpec methodHandle) throws JavaModelException {
        int parIdx = 0;
        while (parIdx < types.length) {
            IMethod[] methods = types[parIdx].getMethods();
            int methIdx = 0;
            while (methIdx < methods.length) {
                IMethod tmpMethod = methods[methIdx];
                String selector = tmpMethod.getElementName();
                if (this.isEqualMethod(methodHandle, tmpMethod, selector)) {
                    return tmpMethod;
                }
                ++methIdx;
            }
            IOTType otType = OTModelManager.getOTElement(types[parIdx]);
            if (otType != null && otType.isRole()) {
                IMethodMapping[] iMethodMappingArray = ((IRoleType)otType).getMethodMappings(2);
                int n = iMethodMappingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String selector;
                    IMethodMapping mapping = iMethodMappingArray[n2];
                    AbstractCalloutMapping tmpMethod = (AbstractCalloutMapping)mapping;
                    if (tmpMethod != this && this.isEqualMethod(methodHandle, tmpMethod, selector = tmpMethod.getCorrespondingJavaElement().getElementName())) {
                        return tmpMethod;
                    }
                    ++n2;
                }
            }
            ++parIdx;
        }
        IMethod methodReference = SourceMethod.createHandle((JavaElement)((Object)types[0]), methodHandle);
        int parIdx2 = 0;
        while (parIdx2 < types.length) {
            IMethod[] methods = types[parIdx2].findMethods(methodReference);
            if (methods != null && methods.length == 1) {
                return methods[0];
            }
            ++parIdx2;
        }
        return null;
    }

    private boolean isEqualMethod(IMethodSpec baseMethodHandle, IMethod foundMethodOrCallout, String foundSelector) {
        if (!foundSelector.equals(baseMethodHandle.getSelector())) {
            return false;
        }
        if (!baseMethodHandle.hasSignature()) {
            return true;
        }
        return Util.equalArraysOrNull(foundMethodOrCallout.getParameterTypes(), baseMethodHandle.getArgumentTypes());
    }

    @Override
    public IOpenable getOpenableParent() {
        IJavaElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            if (current.getElementType() == 100) {
                IOTType otElement = (IOTType)current;
                current = otElement.getCorrespondingJavaElement();
            }
            current = current.getParent();
        }
        return null;
    }

    @Override
    public String getSource() throws JavaModelException {
        IOpenable openable = this.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        return new SourceRange(this.declarationSourceStart, this.declarationSourceEnd - this.declarationSourceStart + 1);
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        SourceRange range = new SourceRange(this.sourceStart, this.sourceEnd - this.sourceStart + 1);
        return range;
    }

    protected String getSourceName() {
        return super.getElementName();
    }

    IMethod getIMethod() {
        return (IMethod)this.getCorrespondingJavaElement();
    }

    public String[] getExceptionTypes() throws JavaModelException {
        return this.getIMethod().getExceptionTypes();
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        return this.getIMethod().getTypeParameterSignatures();
    }

    public int getNumberOfParameters() {
        return this.getIMethod().getNumberOfParameters();
    }

    public String[] getParameterNames() throws JavaModelException {
        if (this.roleMethodHandle != null && this.roleMethodHandle.hasSignature()) {
            return this.roleMethodHandle.getArgumentNames();
        }
        return this.getIMethod().getParameterNames();
    }

    public String[] getParameterTypes() {
        return this.getIMethod().getParameterTypes();
    }

    public String getReturnType() throws JavaModelException {
        if (this.roleMethodHandle != null && this.roleMethodHandle.hasSignature()) {
            return this.roleMethodHandle.getReturnType();
        }
        return this.getIMethod().getReturnType();
    }

    public String getSignature() throws JavaModelException {
        return this.getIMethod().getSignature();
    }

    public boolean isConstructor() throws JavaModelException {
        return this.getIMethod().isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.getIMethod().isMainMethod();
    }

    public boolean isLambdaMethod() {
        return false;
    }

    public boolean isSimilar(IMethod method) {
        return this.getIMethod().isSimilar(method);
    }

    @Override
    public IClassFile getClassFile() {
        return this.getIMethod().getClassFile();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.getIMethod().getCompilationUnit();
    }

    @Override
    public IType getDeclaringType() {
        return this.getIMethod().getDeclaringType();
    }

    @Override
    public int getFlags() throws JavaModelException {
        return 0;
    }

    @Override
    public SourceType getType(String name, int count) {
        if (this.isBinary()) {
            throw new IllegalArgumentException("Not a source member " + this.toStringWithAncestors());
        }
        return (SourceType)this.getIMethod().getType(name, count);
    }

    @Override
    public boolean isBinary() {
        return this.getIMethod().isBinary();
    }

    @Override
    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().copy(container, sibling, rename, replace, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().delete(force, monitor);
    }

    @Override
    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().move(container, sibling, rename, replace, monitor);
    }

    @Override
    public void rename(String name, boolean replace, IProgressMonitor monitor) throws JavaModelException {
        this.getIMethod().rename(name, replace, monitor);
    }

    @Override
    public boolean hasSignature() {
        return this.hasSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        JavaElement myParent = this.getParent();
        if (!myParent.exists()) {
            return false;
        }
        try {
            IJavaElement[] iJavaElementArray = ((IType)((Object)myParent)).getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IJavaElement child = iJavaElementArray[n2];
                if (this.equals(child)) {
                    if (this == child) return true;
                    if (this.declarationSourceStart != 0) return true;
                    MethodMapping other = (MethodMapping)child;
                    this.declarationSourceStart = other.declarationSourceStart;
                    this.declarationSourceEnd = other.declarationSourceEnd;
                    this.sourceStart = other.sourceStart;
                    this.sourceEnd = other.sourceEnd;
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    @Override
    public boolean isStructureKnown() throws JavaModelException {
        return this.getParent().isStructureKnown();
    }

    public String getKey() {
        return this.getIMethod().getKey();
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        return NO_TYPE_PARAMETERS;
    }

    public String[] getRawParameterNames() throws JavaModelException {
        return EMPTY_STRING_ARRAY;
    }

    public ITypeParameter getTypeParameter(String name) {
        return new TypeParameter((JavaElement)this.getCorrespondingJavaElement(), name);
    }

    public boolean isResolved() {
        return false;
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        return null;
    }

    @Override
    public String[] getCategories() throws JavaModelException {
        IType type = (IType)this.getAncestor(7);
        if (type == null) {
            return CharOperation.NO_STRINGS;
        }
        if (type.isBinary()) {
            return CharOperation.NO_STRINGS;
        }
        SourceTypeElementInfo info = (SourceTypeElementInfo)((SourceType)type).getElementInfo();
        HashMap<IJavaElement, String[]> map = info.getCategories();
        if (map == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] categories = map.get(this);
        if (categories == null) {
            return CharOperation.NO_STRINGS;
        }
        return categories;
    }

    @Override
    public ISourceRange getJavadocRange() throws JavaModelException {
        ISourceRange range = this.getSourceRange();
        if (range == null) {
            return null;
        }
        IBuffer buf = null;
        if (this.isBinary()) {
            buf = this.getClassFile().getBuffer();
        } else {
            ICompilationUnit compilationUnit = this.getCompilationUnit();
            if (!compilationUnit.isConsistent()) {
                return null;
            }
            buf = compilationUnit.getBuffer();
        }
        int start = range.getOffset();
        int length = range.getLength();
        if (length > 0 && buf.getChar(start) == '/') {
            IScanner scanner = ToolFactory.createScanner(true, false, false, false);
            scanner.setSource(buf.getText(start, length).toCharArray());
            try {
                int docOffset = -1;
                int docEnd = -1;
                int terminal = scanner.getNextToken();
                block6: while (true) {
                    switch (terminal) {
                        case 1003: {
                            docOffset = scanner.getCurrentTokenStartPosition();
                            docEnd = scanner.getCurrentTokenEndPosition() + 1;
                            terminal = scanner.getNextToken();
                            continue block6;
                        }
                        case 1001: 
                        case 1002: {
                            terminal = scanner.getNextToken();
                            continue block6;
                        }
                    }
                    break;
                }
                if (docOffset != -1) {
                    return new SourceRange(docOffset + start, docEnd - docOffset + 1);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return null;
    }

    @Override
    public int getOccurrenceCount() {
        return 0;
    }

    @Override
    public ITypeRoot getTypeRoot() {
        IJavaElement element = this.getParent();
        while (element instanceof IMember) {
            element = element.getParent();
        }
        return (ITypeRoot)element;
    }

    @Override
    public OTJavaElement resolved(Binding binding) {
        char[] uniqueKey = binding.computeUniqueKey();
        if (uniqueKey == null) {
            throw new AbortCompilation();
        }
        return this.resolved(uniqueKey);
    }

    public abstract OTJavaElement resolved(char[] var1);

    @Override
    protected char getHandleMementoDelimiter() {
        return '\u00a7';
    }

    @Override
    protected int calculateHashCode() {
        return this.roleMethodHandle.hashCode();
    }
}

