/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.Util;

public class JrtPackageFragmentRoot
extends JarPackageFragmentRoot
implements IModulePathEntry {
    protected final String moduleName;
    public static final ThreadLocal<Boolean> workingOnOldClasspath = new ThreadLocal();
    private static final Map<JrtModuleKey, Map<List<String>, JarPackageFragmentRootInfo.PackageContent>> childrenCache = new ConcurrentHashMap<JrtModuleKey, Map<List<String>, JarPackageFragmentRootInfo.PackageContent>>();

    protected JrtPackageFragmentRoot(IPath jrtPath, String moduleName, JavaProject project, IClasspathAttribute[] extraAttributes) {
        super(null, jrtPath, project, extraAttributes);
        this.moduleName = moduleName;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, IResource underlyingResource) throws JavaModelException {
        JrtModuleKey key = new JrtModuleKey(this.jarPath.toFile(), this.moduleName, this.getClassNameSubFolder());
        Map rawPackageInfo = childrenCache.computeIfAbsent(key, JrtPackageFragmentRoot::computeChildren);
        info.setChildren(this.createChildren(rawPackageInfo.keySet()));
        ((JarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        return true;
    }

    private static Map<List<String>, JarPackageFragmentRootInfo.PackageContent> computeChildren(JrtModuleKey key) {
        final HashMap<List<String>, JarPackageFragmentRootInfo.PackageContent> rawPackageInfo = new HashMap<List<String>, JarPackageFragmentRootInfo.PackageContent>();
        File image = key.image();
        final String moduleName = key.moduleName();
        final String classNameSubFolder = key.classNameSubFolder();
        final String compliance = "1.8";
        rawPackageInfo.put(List.of(), new JarPackageFragmentRootInfo.PackageContent());
        try {
            JRTUtil.walkModuleImage((File)image, (JRTUtil.JrtFileVisitor)new JRTUtil.JrtFileVisitor<Path>(){

                public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
                    JrtPackageFragmentRoot.initRawPackageInfo(rawPackageInfo, classNameSubFolder, dir.toString(), true, compliance);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path path, Path mod, BasicFileAttributes attrs) throws IOException {
                    JrtPackageFragmentRoot.initRawPackageInfo(rawPackageInfo, classNameSubFolder, path.toString(), false, compliance);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitModule(Path path, String name) throws IOException {
                    if (!moduleName.equals(name)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            }, (int)7);
        }
        catch (IOException e) {
            Util.log(e, "Error reading modules" + String.valueOf(image));
        }
        return JrtPackageFragmentRoot.unmodifiableCopy(rawPackageInfo);
    }

    @Override
    SourceMapper createSourceMapper(IPath sourcePath, IPath rootPath) throws JavaModelException {
        IClasspathEntry entry = ((JavaProject)this.getParent()).getClasspathEntryFor(this.getPath());
        String encoding = entry == null ? null : ((ClasspathEntry)entry).getSourceAttachmentEncoding();
        IModule mod = this.getModule();
        String modName = mod == null ? null : new String(mod.name());
        SourceMapper mapper = new SourceMapper(sourcePath, rootPath == null ? modName : rootPath.toOSString(), this.getJavaProject().getOptions(true), encoding);
        return mapper;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JrtPackageFragmentRoot) {
            JrtPackageFragmentRoot other = (JrtPackageFragmentRoot)o;
            return this.moduleName.equals(other.moduleName) && this.jarPath.equals((Object)other.jarPath) && Arrays.equals(this.extraAttributes, other.extraAttributes);
        }
        return false;
    }

    @Override
    protected int calculateHashCode() {
        int hash = 31;
        hash = Util.combineHashCodes(hash, this.jarPath.hashCode());
        hash = Util.combineHashCodes(hash, this.moduleName.hashCode());
        hash = Util.combineHashCodes(hash, Arrays.hashCode(this.extraAttributes));
        return hash;
    }

    @Override
    public String getElementName() {
        return this.moduleName;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    @Override
    protected void toStringInfo(int tab, StringBuilder buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("<module:").append(this.moduleName).append(">");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public IModule getModule() {
        IModuleDescription desc = this.getModuleDescription();
        if (desc != null) {
            try {
                return (IModule)((JavaElement)((Object)desc)).getElementInfo();
            }
            catch (JavaModelException e) {
                Util.log((Throwable)((Object)e));
            }
        }
        return null;
    }

    @Override
    protected boolean isComplianceJava9OrHigher() {
        return true;
    }

    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String requestedModuleName) {
        if (requestedModuleName != null && !requestedModuleName.equals(this.moduleName)) {
            return null;
        }
        if (this.getPackageFragment(qualifiedPackageName).exists()) {
            return new char[][]{requestedModuleName.toCharArray()};
        }
        return null;
    }

    @Override
    protected boolean ignoreErrorStatus(IStatus status) {
        return status.getCode() == 1006 && workingOnOldClasspath.get() == Boolean.TRUE;
    }

    static final class JrtModuleKey
    extends Record {
        private final File image;
        private final String moduleName;
        private final String classNameSubFolder;

        public File image() {
            return this.image;
        }

        public String moduleName() {
            return this.moduleName;
        }

        public String classNameSubFolder() {
            return this.classNameSubFolder;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{JrtModuleKey.class, "image;moduleName;classNameSubFolder", "image", "moduleName", "classNameSubFolder"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{JrtModuleKey.class, "image;moduleName;classNameSubFolder", "image", "moduleName", "classNameSubFolder"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{JrtModuleKey.class, "image;moduleName;classNameSubFolder", "image", "moduleName", "classNameSubFolder"}, this, object);
        }

        JrtModuleKey(File file, String string, String string2) {
            this.image = file;
            this.moduleName = string;
            this.classNameSubFolder = string2;
        }
    }
}

