/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class ImportDeclaration
extends ASTNode {
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(ImportDeclaration.class, "name", Name.class, true, false);
    public static final SimplePropertyDescriptor ON_DEMAND_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "onDemand", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor STATIC_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "static", Boolean.TYPE, true);
    public static final SimplePropertyDescriptor BASE_PROPERTY = new SimplePropertyDescriptor(ImportDeclaration.class, "base", Boolean.TYPE, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    public static final ChildListPropertyDescriptor MODIFIERS_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS_23;
    private volatile Name importName;
    private boolean onDemand = false;
    private boolean isStatic = false;
    private boolean isBase = false;
    private int baseModifierPosition = -1;
    private ASTNode.NodeList modifiers = null;

    static {
        MODIFIERS_PROPERTY = new ChildListPropertyDescriptor(ImportDeclaration.class, "modifiers", IExtendedModifier.class, true);
        ArrayList properyList = new ArrayList(3);
        ImportDeclaration.createPropertyList(ImportDeclaration.class, properyList);
        ImportDeclaration.addProperty(NAME_PROPERTY, properyList);
        ImportDeclaration.addProperty(ON_DEMAND_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_2_0 = ImportDeclaration.reapPropertyList(properyList);
        properyList = new ArrayList(4);
        ImportDeclaration.createPropertyList(ImportDeclaration.class, properyList);
        ImportDeclaration.addProperty(STATIC_PROPERTY, properyList);
        ImportDeclaration.addProperty(BASE_PROPERTY, properyList);
        ImportDeclaration.addProperty(NAME_PROPERTY, properyList);
        ImportDeclaration.addProperty(ON_DEMAND_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_3_0 = ImportDeclaration.reapPropertyList(properyList);
        properyList = new ArrayList(5);
        ImportDeclaration.createPropertyList(ImportDeclaration.class, properyList);
        ImportDeclaration.addProperty(STATIC_PROPERTY, properyList);
        ImportDeclaration.addProperty(BASE_PROPERTY, properyList);
        ImportDeclaration.addProperty(MODIFIERS_PROPERTY, properyList);
        ImportDeclaration.addProperty(NAME_PROPERTY, properyList);
        ImportDeclaration.addProperty(ON_DEMAND_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_23 = ImportDeclaration.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel >= 23) {
            return PROPERTY_DESCRIPTORS_23;
        }
        if (apiLevel >= 3) {
            return PROPERTY_DESCRIPTORS_3_0;
        }
        return PROPERTY_DESCRIPTORS_2_0;
    }

    ImportDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel >= 23) {
            this.modifiers = new ASTNode.NodeList(MODIFIERS_PROPERTY);
        }
    }

    public List modifiers() {
        if (this.ast.apiLevel < 23) {
            throw new UnsupportedOperationException("Operation not supported in AST below JLS23");
        }
        return this.modifiers;
    }

    public int getModifiers() {
        if (this.modifiers == null) {
            return this.isStatic ? 8 : 0;
        }
        int computedmodifierFlags = 0;
        for (Object x : this.modifiers()) {
            if (!(x instanceof Modifier)) continue;
            Modifier modifier = (Modifier)x;
            computedmodifierFlags |= modifier.getKeyword().toFlagValue();
        }
        return computedmodifierFlags;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ImportDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == ON_DEMAND_PROPERTY) {
            if (get) {
                return this.isOnDemand();
            }
            this.setOnDemand(value);
            return false;
        }
        if (property == STATIC_PROPERTY) {
            if (get) {
                return this.isStatic();
            }
            this.setStatic(value);
            return false;
        }
        if (property == BASE_PROPERTY) {
            if (get) {
                return this.isBase();
            }
            this.setBase(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Name)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS_PROPERTY) {
            return this.modifiers();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 26;
    }

    @Override
    ASTNode clone0(AST target) {
        ImportDeclaration result = new ImportDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOnDemand(this.isOnDemand());
        if (this.ast.apiLevel >= 3) {
            result.setStatic(this.isStatic());
            result.setBase(this.isBase());
        }
        if (this.ast.apiLevel >= 23) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
        }
        result.setName((Name)this.getName().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
            if (this.ast.apiLevel >= 23) {
                this.acceptChildren(visitor, this.modifiers);
            }
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getName() {
        if (this.importName == null) {
            ImportDeclaration importDeclaration = this;
            synchronized (importDeclaration) {
                if (this.importName == null) {
                    this.preLazyInit();
                    this.importName = this.postLazyInit(this.ast.newQualifiedName(new SimpleName(this.ast), new SimpleName(this.ast)), NAME_PROPERTY);
                }
            }
        }
        return this.importName;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.importName;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.importName = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }

    public void setOnDemand(boolean onDemand) {
        this.preValueChange(ON_DEMAND_PROPERTY);
        this.onDemand = onDemand;
        this.postValueChange(ON_DEMAND_PROPERTY);
    }

    public boolean isStatic() {
        if (this.modifiers != null) {
            for (Object x : this.modifiers()) {
                Modifier modifier;
                if (!(x instanceof Modifier) || !(modifier = (Modifier)x).isStatic()) continue;
                return true;
            }
            return false;
        }
        this.unsupportedIn2();
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        if (this.ast.apiLevel >= 23) {
            List mods = this.modifiers();
            for (Modifier mod : mods) {
                if (!mod.isStatic()) continue;
                if (!isStatic) {
                    this.modifiers.remove(mod);
                }
                return;
            }
            if (isStatic) {
                Modifier newMod = this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                this.modifiers.add(newMod);
            }
            return;
        }
        this.unsupportedIn2();
        this.preValueChange(STATIC_PROPERTY);
        this.isStatic = isStatic;
        this.postValueChange(STATIC_PROPERTY);
    }

    public boolean isBase() {
        this.unsupportedIn2();
        return this.isBase;
    }

    public void setBase(boolean isBase) {
        this.unsupportedIn2();
        this.preValueChange(BASE_PROPERTY);
        this.isBase = isBase;
        this.postValueChange(BASE_PROPERTY);
    }

    public IBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveImport(this);
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.importName == null ? 0 : this.getName().treeSize());
    }

    public void setBaseModifierPosition(int baseModifierPosition) {
        this.baseModifierPosition = baseModifierPosition;
    }

    public int getBaseModifierPosition() {
        return this.baseModifierPosition;
    }
}

