/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.ExtraCompilerModifiers;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.SourcePosition;

public abstract class AstFactory
implements ClassFileConstants,
ExtraCompilerModifiers,
IOTConstants {
    public int sourceStart;
    public int sourceEnd;
    public long pos;
    private SourcePosition _sourcePosition;

    public AstFactory(int start, int end) {
        this.sourceStart = start;
        this.sourceEnd = end;
        this.pos = ((long)start << 32) + (long)end;
        this._sourcePosition = new SourcePosition(this.sourceStart, this.sourceEnd, this.pos);
    }

    public void shiftPosition() {
        --this.sourceEnd;
        if (this.sourceEnd < this.sourceStart) {
            --this.sourceStart;
        }
        this.pos = ((long)this.sourceStart << 32) + (long)this.sourceEnd;
        this._sourcePosition = new SourcePosition(this.sourceStart, this.sourceEnd, this.pos);
    }

    public void retargetFrom(ASTNode node) {
        this.sourceStart = node.sourceStart;
        this.sourceEnd = node.sourceEnd;
        this.pos = ((long)this.sourceStart << 32) + (long)this.sourceEnd;
        this._sourcePosition = new SourcePosition(this.sourceStart, this.sourceEnd, this.pos);
    }

    public void setMethodPositions(AbstractMethodDeclaration method) {
        method.sourceStart = this.sourceStart;
        method.sourceEnd = this.sourceEnd;
        method.declarationSourceStart = this.sourceStart;
        method.declarationSourceEnd = this.sourceEnd;
        method.bodyStart = this.sourceStart;
        method.bodyEnd = this.sourceEnd;
        method.modifiersSourceStart = this.sourceStart;
    }

    public void setSourcePosition(long position) {
        this.pos = position;
        this.sourceStart = (int)position >> 32;
        this.sourceEnd = (int)(position & 0xFFFFFFFFL);
    }

    public void setSourcePosition(SourcePosition sourcePosition) {
        this.sourceStart = sourcePosition.sourceStart;
        this.sourceEnd = sourcePosition.sourceEnd;
        this.pos = sourcePosition.position;
        this._sourcePosition = sourcePosition;
    }

    public SourcePosition getSourcePosition() {
        if (this._sourcePosition == null || this.sourceStart != this._sourcePosition.sourceStart || this.sourceEnd != this._sourcePosition.sourceEnd || this.pos != this._sourcePosition.position) {
            this._sourcePosition = new SourcePosition(this.sourceStart, this.sourceEnd, this.pos);
        }
        return this._sourcePosition;
    }
}

