/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.QualifiedBaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class TypeAnchorReference
extends TypeReference
implements InvocationSite {
    public Reference anchor;
    public boolean isExpression = false;

    public TypeAnchorReference(Reference anchor, int sourceStart) {
        this.anchor = anchor;
        this.sourceStart = sourceStart;
        this.sourceEnd = anchor.sourceEnd;
        anchor.bits |= 0x2000;
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int additionalDimensions, Annotation[][] additionalAnnotations, boolean isVarargs) {
        throw new InternalCompilerError("Method not applicable");
    }

    @Override
    public void setBaseclassDecapsulation(Expression.DecapsulationState state) {
        super.setBaseclassDecapsulation(state);
        if (this.anchor instanceof QualifiedThisReference) {
            ((QualifiedThisReference)this.anchor).qualification.setBaseclassDecapsulation(state);
        }
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        throw new InternalCompilerError("TypeAnchorReference is not intended to be used here");
    }

    @Override
    public char[][] getTypeName() {
        return this.getTypeName(this.anchor);
    }

    char[][] getTypeName(Reference reference) {
        Object result;
        if (reference instanceof SingleNameReference) {
            result = new char[][]{((SingleNameReference)reference).token};
        } else if (reference instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)reference;
            result = CharOperation.arrayConcat(this.getTypeName((Reference)fieldRef.receiver), fieldRef.token);
        } else if (reference instanceof QualifiedBaseReference) {
            QualifiedBaseReference baseRef = (QualifiedBaseReference)reference;
            char[][] tokens = baseRef.qualification.getTypeName();
            int len = tokens.length;
            result = new char[len + 1][];
            System.arraycopy(tokens, 0, result, 0, len);
            result[len] = IOTConstants.BASE;
        } else if (reference instanceof QualifiedThisReference) {
            QualifiedThisReference thisRef = (QualifiedThisReference)reference;
            char[][] tokens = thisRef.qualification.getTypeName();
            int len = tokens.length;
            result = new char[len + 1][];
            System.arraycopy(tokens, 0, result, 0, len);
            result[len] = "this".toCharArray();
        } else {
            char[][] orig = ((QualifiedNameReference)this.anchor).tokens;
            result = new char[orig.length][];
            System.arraycopy(orig, 0, result, 0, orig.length);
        }
        result[0] = CharOperation.concat(new char[]{'@'}, result[0]);
        return result;
    }

    @Override
    public char[] getLastToken() {
        if (this.anchor instanceof SingleNameReference) {
            return ((SingleNameReference)this.anchor).token;
        }
        if (this.anchor instanceof QualifiedBaseReference) {
            return IOTConstants.BASE;
        }
        if (this.anchor instanceof FieldReference) {
            return ((FieldReference)this.anchor).token;
        }
        char[][] tokens = ((QualifiedNameReference)this.anchor).tokens;
        return tokens[tokens.length - 1];
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        classScope.problemReporter().valueParamWrongPosition(this);
        return null;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope, boolean checkBounds, int location) {
        if (!this.isExpression) {
            scope.problemReporter().valueParamWrongPosition(this);
            return null;
        }
        ITeamAnchor binding = this.resolveAnchor(scope);
        if (binding == null) {
            return null;
        }
        if (binding.isValidBinding()) {
            ReferenceBinding receiverType = null;
            int bit = 2;
            if (binding instanceof FieldBinding) {
                bit = 1;
                receiverType = ((FieldBinding)binding).declaringClass;
            }
            this.bits &= 0xFFFFFFF8;
            this.bits |= bit;
            this.anchor.bits &= 0xFFFFFFF8;
            this.anchor.bits |= bit;
            this.constant = Constant.NotAConstant;
            this.anchor.constant = Constant.NotAConstant;
            int depth = 0;
            if (receiverType != null && this.anchor instanceof InvocationSite) {
                ReferenceBinding currentType = scope.enclosingSourceType();
                while (!currentType.isCompatibleWith(receiverType)) {
                    ++depth;
                    if ((currentType = currentType.enclosingType()) != null) continue;
                    return null;
                }
                ((InvocationSite)((Object)this.anchor)).setDepth(depth);
            }
        }
        this.resolvedType = binding.getResolvedType();
        return this.resolvedType;
    }

    public ITeamAnchor resolveAnchor(Scope scope) {
        ITeamAnchor result = this.resolveAnchor(scope, this.anchor);
        if (result != null) {
            this.resolvedType = result.getResolvedType();
        }
        return result;
    }

    ITeamAnchor resolveAnchor(Scope scope, Reference reference) {
        ITeamAnchor prefix = null;
        ITeamAnchor currentAnchor = null;
        char[] currentToken = null;
        if (reference instanceof SingleNameReference) {
            SingleNameReference singleAnchor = (SingleNameReference)reference;
            currentToken = singleAnchor.token;
            currentAnchor = this.findVariable(scope, currentToken, scope.isStatic(), singleAnchor.sourceStart, singleAnchor.sourceEnd);
            this.anchor.bits |= this.bits & 0x1FE0;
        } else if (reference instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)reference;
            Expression prefixExpr = fieldRef.receiver;
            if (!(prefixExpr instanceof Reference)) {
                throw new InternalCompilerError("Unexpected anchor prefix " + String.valueOf(prefixExpr));
            }
            prefix = this.resolveAnchor(scope, (Reference)prefixExpr);
            currentToken = fieldRef.token;
            fieldRef.binding = TypeAnalyzer.findField(((ReferenceBinding)prefix.getResolvedType()).getRealClass(), currentToken, false, true);
            currentAnchor = this.checkAnchor(scope, reference, currentToken, reference.sourceStart, reference.sourceEnd, fieldRef.binding);
        } else if (reference instanceof QualifiedBaseReference) {
            QualifiedBaseReference baseRef = (QualifiedBaseReference)reference;
            if (scope instanceof BlockScope) {
                baseRef.resolveType((BlockScope)scope);
            } else {
                baseRef.resolveType((ClassScope)scope);
            }
            currentAnchor = baseRef.baseField;
        } else if (reference instanceof QualifiedThisReference) {
            QualifiedThisReference thisRef = (QualifiedThisReference)reference;
            if (scope instanceof BlockScope) {
                thisRef.resolveType((BlockScope)scope);
            } else {
                thisRef.resolveType((ClassScope)scope);
            }
            if (thisRef.resolvedType.isTeam()) {
                currentAnchor = ((ReferenceBinding)thisRef.resolvedType).getTeamModel().getTThis();
            }
        } else {
            boolean haveReportedProblem = false;
            long currentPos = 0L;
            QualifiedNameReference qualifiedAnchor = (QualifiedNameReference)reference;
            char[][] tokens = qualifiedAnchor.tokens;
            currentToken = tokens[tokens.length - 1];
            Binding staticPrefix = null;
            int j = 1;
            while (j <= tokens.length) {
                Binding current = scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, j));
                if (current == null || !current.isValidBinding()) break;
                staticPrefix = current;
                ++j;
            }
            if (j > tokens.length) {
                scope.problemReporter().typeAnchorReferenceNotAValue(reference);
                haveReportedProblem = true;
            } else {
                if (staticPrefix != null) {
                    currentPos = qualifiedAnchor.sourcePositions[j - 1];
                    currentToken = tokens[j - 1];
                    if (staticPrefix instanceof ReferenceBinding) {
                        currentAnchor = TypeAnalyzer.findField(((ReferenceBinding)staticPrefix).getRealClass(), currentToken, true, true);
                    } else {
                        scope.problemReporter().typeAnchorReferenceNotAnObjectRef((int)(currentPos >>> 32), (int)currentPos);
                        haveReportedProblem = true;
                    }
                } else {
                    currentPos = qualifiedAnchor.sourcePositions[0];
                    currentToken = tokens[0];
                    currentAnchor = this.findVariable(scope, currentToken, scope.isStatic(), (int)(currentPos >>> 32), (int)currentPos);
                    boolean bl = haveReportedProblem = currentAnchor == null;
                }
                if (currentAnchor != null) {
                    if (!currentAnchor.hasValidReferenceType()) {
                        if (j < tokens.length) {
                            currentAnchor = null;
                        }
                    } else {
                        int i = j;
                        while (i < tokens.length) {
                            TypeBinding fieldType = currentAnchor.getResolvedType().leafComponentType();
                            if (fieldType instanceof SourceTypeBinding) {
                                SourceTypeBinding stb = (SourceTypeBinding)fieldType;
                                if (stb.scope != null && stb.scope.compilationUnitScope() != scope.compilationUnitScope() && (stb.tagBits & 0x300L) == 768L && StateHelper.isReadyToProcess(stb, 9)) {
                                    Dependencies.ensureBindingState(stb, 9);
                                }
                            }
                            currentPos = qualifiedAnchor.sourcePositions[i];
                            currentToken = tokens[i];
                            FieldBinding nextField = currentAnchor.getFieldOfType(currentToken, false, true);
                            if (nextField == null || !nextField.hasValidReferenceType()) {
                                currentAnchor = null;
                                break;
                            }
                            currentAnchor = nextField.setPathPrefix(currentAnchor);
                            ++i;
                        }
                    }
                }
            }
            if (!haveReportedProblem) {
                if (currentAnchor == null) {
                    scope.problemReporter().typeAnchorNotFound(currentToken, (int)(currentPos >>> 32), (int)currentPos);
                } else if (!currentAnchor.hasValidReferenceType()) {
                    scope.problemReporter().typeAnchorReferenceNotAnObjectRef((int)(currentPos >>> 32), (int)currentPos);
                }
            }
        }
        if (currentAnchor == null) {
            currentAnchor = new ProblemFieldBinding(scope.enclosingReceiverType(), currentToken, 1);
            ((FieldBinding)currentAnchor).type = reference.resolvedType = new ProblemReferenceBinding("UnresolvedType".toCharArray(), 1, null);
        } else if (currentAnchor.isValidBinding()) {
            if (prefix != null && !(prefix instanceof TThisBinding)) {
                currentAnchor = currentAnchor.setPathPrefix(prefix);
            }
            reference.resolvedType = currentAnchor.getResolvedType();
            reference.bits &= 0xFFFFFFF8;
            if (currentAnchor instanceof FieldBinding) {
                reference.bits |= 1;
                if (reference instanceof NameReference) {
                    ((NameReference)reference).actualReceiverType = ((FieldBinding)currentAnchor).declaringClass;
                }
                if (reference instanceof FieldReference) {
                    ((FieldReference)reference).actualReceiverType = ((FieldBinding)currentAnchor).declaringClass;
                }
            } else {
                reference.bits |= 2;
            }
            reference.constant = Constant.NotAConstant;
        }
        if (reference instanceof NameReference) {
            ((NameReference)reference).binding = (Binding)((Object)currentAnchor);
            ((NameReference)reference).resolveFinished();
        } else if (reference instanceof FieldReference) {
            ((FieldReference)reference).binding = (FieldBinding)currentAnchor;
        }
        return currentAnchor;
    }

    public ITeamAnchor getResolvedAnchor() {
        if (this.anchor instanceof NameReference) {
            return (ITeamAnchor)((Object)((NameReference)this.anchor).binding);
        }
        if (this.anchor instanceof FieldReference) {
            return ((FieldReference)this.anchor).binding;
        }
        if (this.anchor instanceof QualifiedBaseReference) {
            return ((QualifiedBaseReference)this.anchor).baseField;
        }
        return null;
    }

    public ReferenceBinding resolveStaticPart(Scope scope) {
        if (!(this.anchor instanceof QualifiedNameReference)) {
            return null;
        }
        QualifiedNameReference qualifiedAnchor = (QualifiedNameReference)this.anchor;
        char[][] tokens = qualifiedAnchor.tokens;
        Binding staticPrefix = null;
        int j = 1;
        while (j <= tokens.length) {
            Binding current = scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, j));
            if (current == null || !current.isValidBinding()) break;
            staticPrefix = current;
            ++j;
        }
        if (j > tokens.length) {
            scope.problemReporter().typeAnchorReferenceNotAValue(this.anchor);
            return null;
        }
        if (staticPrefix instanceof ReferenceBinding) {
            return (ReferenceBinding)staticPrefix;
        }
        return null;
    }

    private ITeamAnchor findVariable(Scope scope, char[] token, boolean isStaticScope, int start, int end) {
        Binding binding;
        if (scope instanceof ClassScope && ((ClassScope)scope).superTypeReference != null) {
            scope.problemReporter().extendingExternalizedRole(((ClassScope)scope).superTypeReference);
            return null;
        }
        VariableBinding anchorBinding = null;
        switch (scope.kind) {
            case 2: {
                Argument[] arguments;
                AbstractMethodDeclaration method = ((MethodScope)scope).referenceMethod();
                if (method != null && (arguments = method.arguments) != null) {
                    int i = 0;
                    while (i < arguments.length) {
                        if (CharOperation.equals(arguments[i].name, token)) {
                            return RoleTypeCreator.resolveTypeAnchoredToArgument(method, i);
                        }
                        ++i;
                    }
                }
            }
            case 1: 
            case 6: {
                anchorBinding = scope.findVariable(token);
            }
        }
        if (anchorBinding == null && (binding = scope.getBinding(token, 3, this, true)) instanceof VariableBinding) {
            anchorBinding = (VariableBinding)binding;
        }
        return this.checkAnchor(scope, this.anchor, token, start, end, anchorBinding);
    }

    private ITeamAnchor checkAnchor(Scope scope, Reference reference, char[] token, int start, int end, ITeamAnchor anchorBinding) {
        if (anchorBinding == null) {
            scope.problemReporter().typeAnchorNotFound(token, start, end);
            return null;
        }
        if (anchorBinding instanceof ProblemFieldBinding) {
            if (reference instanceof NameReference) {
                scope.problemReporter().invalidField((NameReference)reference, (FieldBinding)anchorBinding);
            } else if (reference instanceof FieldReference) {
                scope.problemReporter().invalidField((FieldReference)reference, ((FieldReference)reference).actualReceiverType);
            }
            return null;
        }
        if (!anchorBinding.hasValidReferenceType()) {
            scope.problemReporter().typeAnchorReferenceNotAnObjectRef(start, end);
            return null;
        }
        return anchorBinding;
    }

    public TypeBinding createDependentTypeBinding(Scope scope, TypeReference typeReference, int typeParamPosition) {
        TypeBinding type = typeReference.resolvedType;
        ITeamAnchor anchorBinding = null;
        if (this.anchor instanceof NameReference) {
            anchorBinding = (ITeamAnchor)((Object)((NameReference)this.anchor).binding);
        } else if (this.anchor instanceof FieldReference) {
            anchorBinding = ((FieldReference)this.anchor).binding;
        }
        if (anchorBinding != null && type instanceof ReferenceBinding && type.isValidBinding()) {
            ReferenceBinding refBinding = (ReferenceBinding)type;
            VariableBinding currentParam = refBinding.valueParamSynthArgAt(typeParamPosition);
            if (currentParam == null) {
                scope.problemReporter().typeHasNoValueParamAt(typeReference, refBinding, typeParamPosition);
                return null;
            }
            if (currentParam.type instanceof UnresolvedReferenceBinding) {
                currentParam.type = ((UnresolvedReferenceBinding)currentParam.type).resolve(scope.environment(), false);
            }
            if (currentParam.isValidBinding() && !anchorBinding.isTypeCompatibleWith((ReferenceBinding)currentParam.type)) {
                scope.problemReporter().incompatibleValueParameter(this, currentParam);
                return null;
            }
            TypeBinding[] typeArguments = refBinding.isParameterizedType() ? ((ParameterizedTypeBinding)refBinding).arguments : null;
            return anchorBinding.getDependentTypeBinding(refBinding, typeParamPosition, typeArguments, typeReference.dimensions());
        }
        scope.problemReporter().invalidType(typeReference, new ProblemReferenceBinding(typeReference.getTypeName(), null, 1));
        return null;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.isExpression) {
            this.anchor.generateCode(currentScope, codeStream, valueRequired);
        } else {
            super.generateCode(currentScope, codeStream, valueRequired);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            this.anchor.traverse(visitor, classScope);
        }
        visitor.endVisit(this, classScope);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.anchor.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        output.append('@');
        return this.anchor.printExpression(indent, output);
    }

    public static boolean[] fetchAnchorFlags(Argument[] arguments, TypeParameter[] typeParameters) {
        boolean[] flags = new boolean[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            TypeReference[] parameters;
            if (arguments[i].type instanceof ParameterizedSingleTypeReference && (parameters = ((ParameterizedSingleTypeReference)arguments[i].type).typeArguments).length > 0 && parameters[0] instanceof TypeAnchorReference) {
                TypeAnchorReference.checkTypeAnchorXRef((TypeAnchorReference)parameters[0], arguments, i, flags);
            }
            ++i;
        }
        if (typeParameters != null) {
            i = 0;
            while (i < typeParameters.length) {
                if (typeParameters[i].type instanceof TypeAnchorReference) {
                    TypeAnchorReference.checkTypeAnchorXRef((TypeAnchorReference)typeParameters[i].type, arguments, -1, flags);
                }
                ++i;
            }
        }
        return flags;
    }

    private static void checkTypeAnchorXRef(TypeAnchorReference anchorRef, Argument[] arguments, int argPos, boolean[] flags) {
        if (anchorRef.anchor instanceof SingleNameReference) {
            char[] name = ((SingleNameReference)anchorRef.anchor).token;
            int j = 0;
            while (j < arguments.length) {
                if (j != argPos && CharOperation.equals(arguments[j].name, name)) {
                    flags[j] = true;
                    break;
                }
                ++j;
            }
        }
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return Binding.NO_TYPES;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return false;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    @Override
    public void setFieldIndex(int depth) {
    }

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        throw new InternalCompilerError("Method not applicable");
    }
}

