/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TeamAnchor;

public abstract class VariableBinding
extends TeamAnchor {
    public int modifiers;
    public int otBits;
    public char[] name;
    protected Constant constant;
    public int id;

    public VariableBinding(char[] name, TypeBinding type, int modifiers, Constant constant) {
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.constant = constant;
        if (type != null) {
            this.tagBits |= type.tagBits & 0x80L;
        }
    }

    public Constant constant() {
        return this.constant;
    }

    public Constant constant(Scope scope) {
        return this.constant();
    }

    @Override
    public abstract AnnotationBinding[] getAnnotations();

    public ReferenceBinding getDeclaringClass() {
        return null;
    }

    public final boolean isBlankFinal() {
        return (this.modifiers & 0x4000000) != 0;
    }

    @Override
    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isEffectivelyFinal() {
        return (this.tagBits & 0x800L) != 0L;
    }

    public boolean isNonNull() {
        return (this.tagBits & 0x100000000000000L) != 0L || this.type != null && (this.type.tagBits & 0x100000000000000L) != 0L;
    }

    public boolean isNullable() {
        return (this.tagBits & 0x80000000000000L) != 0L || this.type != null && (this.type.tagBits & 0x80000000000000L) != 0L;
    }

    @Override
    public char[] readableName() {
        if (CharOperation.prefixEquals(IOTConstants.OT_DOLLAR_NAME, this.name)) {
            return CharOperation.subarray(this.name, IOTConstants.OT_DOLLAR_LEN, -1);
        }
        return this.name;
    }

    @Override
    public char[] internalName() {
        return this.name;
    }

    public void setConstant(Constant constant) {
        this.constant = constant;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(10);
        ASTNode.printModifiers(this.modifiers & 0xEFFFFFFF, output);
        if ((this.modifiers & 0x2000000) != 0) {
            output.append("[unresolved] ");
        }
        output.append(this.type != null ? this.type.debugName() : "<no type>");
        output.append(" ");
        output.append(this.name != null ? new String(this.name) : "<no name>");
        return output.toString();
    }

    public void clearEffectiveFinality(Scope scope, Expression node, boolean complain) {
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public void fillInDefaultNonNullness(AbstractVariableDeclaration sourceField, Scope scope) {
        assert (sourceField.getKind() != 4);
        if (this.type == null || this.type.isBaseType()) {
            return;
        }
        LookupEnvironment environment = scope.environment();
        if (environment.usesNullTypeAnnotations()) {
            if (!this.type.acceptsNonNullDefault()) {
                return;
            }
            if ((this.type.tagBits & 0x180000000000000L) == 0L) {
                this.type = environment.createNonNullAnnotatedType(this.type);
            } else if ((this.type.tagBits & 0x100000000000000L) != 0L) {
                scope.problemReporter().nullAnnotationIsRedundant(sourceField);
            }
        } else if ((this.tagBits & 0x180000000000000L) == 0L) {
            this.tagBits |= 0x100000000000000L;
        } else if ((this.tagBits & 0x100000000000000L) != 0L) {
            scope.problemReporter().nullAnnotationIsRedundant(sourceField);
        }
    }
}

