/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class SwitchStatement
extends Expression {
    public static final SingletonBootstrap PRIMITIVE_CLASS__BOOTSTRAP = new SingletonBootstrap("ConstantBootStraps.primitiveClass", PRIMITIVE_CLASS, PRIMITIVE_CLASS__SIGNATURE);
    public static final SingletonBootstrap GET_STATIC_FINAL__BOOTSTRAP = new SingletonBootstrap("ConstantBootStraps.getStaticFinal", GET_STATIC_FINAL, GET_STATIC_FINAL__SIGNATURE);
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public int blockStart;
    public BranchLabel breakLabel;
    private CaseLabel defaultLabel;
    public int caseCount;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public CaseStatement nullCase;
    public CaseStatement unconditionalPatternCase;
    public static final CaseStatement.LabelExpression[] NO_LABEL_EXPRESSIONS = new CaseStatement.LabelExpression[0];
    public CaseStatement.LabelExpression[] labelExpressions = NO_LABEL_EXPRESSIONS;
    public int labelExpressionIndex = 0;
    public int nConstants;
    public int switchBits;
    public boolean containsPatterns;
    public boolean containsRecordPatterns;
    public boolean containsNull;
    boolean nullProcessed = false;
    BranchLabel switchPatternRestartTarget;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int BREAKING = 2;
    public static final int LabeledRules = 1;
    public static final int InvalidSelector = 2;
    public static final int Exhaustive = 4;
    public static final int QualifiedEnum = 8;
    public static final int LabeledBlockStatementGroup = 16;
    public static final int BarricadeInjectedDefault = 32;
    public static final int HasNondefaultCase = 64;
    private static final char[] SecretSelectorVariableName = " selector".toCharArray();
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;
    LocalVariableBinding selector = null;
    boolean isNonTraditional = false;
    boolean isPrimitiveSwitch = false;
    List<Pattern> caseLabelElements = new ArrayList<Pattern>(0);
    public List<TypeBinding> caseLabelElementTypes = new ArrayList<TypeBinding>(0);

    private void preprocess() {
        int n = 0;
        Statement[] statementArray = this.statements;
        int n2 = this.statements.length;
        int n3 = 0;
        while (n3 < n2) {
            Statement statement = statementArray[n3];
            if (statement instanceof CaseStatement) {
                CaseStatement caseStatement = (CaseStatement)statement;
                ++n;
                int count = 0;
                Expression[] expressionArray = caseStatement.peeledLabelExpressions();
                int n4 = expressionArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Expression e = expressionArray[n5];
                    if (!(e instanceof FakeDefaultLiteral)) {
                        ++count;
                    }
                    ++n5;
                }
                this.nConstants += count;
            }
            ++n3;
        }
        this.labelExpressions = new CaseStatement.LabelExpression[this.nConstants];
        this.cases = new CaseStatement[n];
    }

    boolean integralType(TypeBinding type) {
        boolean bl;
        switch (type.id) {
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean duplicateConstant(CaseStatement.LabelExpression current, CaseStatement.LabelExpression prior) {
        if (current.expression instanceof Pattern || prior.expression instanceof Pattern) {
            return false;
        }
        if (current.expression instanceof NullLiteral ^ prior.expression instanceof NullLiteral) {
            return false;
        }
        if (current.constant.equals(prior.constant)) {
            return true;
        }
        if (current.type.id == 5) {
            this.switchBits |= 4;
        }
        return false;
    }

    void gatherLabelExpression(CaseStatement.LabelExpression labelExpression) {
        if (labelExpression.expression instanceof Pattern) {
            Pattern pattern = (Pattern)labelExpression.expression;
            if (this.defaultCase != null) {
                this.scope.problemReporter().patternDominatedByAnother(pattern);
            } else {
                int i = 0;
                while (i < this.labelExpressionIndex) {
                    Pattern priorPattern;
                    Expression expression = this.labelExpressions[i].expression;
                    if (expression instanceof Pattern && (priorPattern = (Pattern)expression).dominates(pattern)) {
                        this.scope.problemReporter().patternDominatedByAnother(pattern);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            if (labelExpression.expression instanceof NullLiteral) {
                if (this.defaultCase != null) {
                    this.scope.problemReporter().patternDominatedByAnother(labelExpression.expression);
                }
            } else {
                TypeBinding boxedType = labelExpression.type.isBaseType() ? this.scope.environment().computeBoxingType(labelExpression.type) : labelExpression.type;
                int i = 0;
                while (i < this.labelExpressionIndex) {
                    Pattern priorPattern;
                    Expression expression = this.labelExpressions[i].expression;
                    if (expression instanceof Pattern && (priorPattern = (Pattern)expression).coversType(boxedType, this.scope)) {
                        this.scope.problemReporter().patternDominatedByAnother(labelExpression.expression);
                        break;
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < this.labelExpressionIndex) {
                if (this.duplicateConstant(labelExpression, this.labelExpressions[i])) {
                    this.scope.problemReporter().duplicateCase(labelExpression.expression);
                    break;
                }
                ++i;
            }
        }
        this.labelExpressions[this.labelExpressionIndex++] = labelExpression;
    }

    private void complainIfNotExhaustiveSwitch(BlockScope upperScope, TypeBinding selectorType, CompilerOptions compilerOptions) {
        boolean isEnhanced = this.isEnhancedSwitch(upperScope, selectorType);
        if (selectorType != null && selectorType.isEnum()) {
            Set<FieldBinding> unenumeratedConstants;
            if (isEnhanced) {
                this.switchBits |= 4;
            }
            if (this.defaultCase != null && !compilerOptions.reportMissingEnumCaseDespiteDefault) {
                return;
            }
            int casesCount = this.caseCount;
            if (this.defaultCase != null && this.defaultCase.constantExpressions == NO_EXPRESSIONS) {
                --casesCount;
            }
            int constantCount = this.labelExpressions.length;
            if (this.unconditionalPatternCase == null && (this.containsPatterns || this.containsNull || constantCount >= casesCount && constantCount != selectorType.enumConstantCount()) && (unenumeratedConstants = this.unenumeratedConstants(selectorType, constantCount)).size() != 0) {
                this.switchBits &= 0xFFFFFFFB;
                if (this.defaultCase == null || (this.defaultCase.bits & 0x40000000) == 0) {
                    if (isEnhanced) {
                        upperScope.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
                    } else {
                        for (FieldBinding enumConstant : unenumeratedConstants) {
                            this.reportMissingEnumConstantCase(upperScope, enumConstant);
                        }
                    }
                }
            }
            if (this.defaultCase == null) {
                if (this instanceof SwitchExpression || compilerOptions.getSeverity(0x40008000) == 256) {
                    upperScope.methodScope().hasMissingSwitchDefault = true;
                } else {
                    upperScope.problemReporter().missingDefaultCase(this, true, selectorType);
                }
            }
            return;
        }
        if (this.isExhaustive() || this.defaultCase != null || selectorType == null) {
            if (isEnhanced) {
                this.switchBits |= 4;
            }
            return;
        }
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && selectorType.isSealed() && this.caseElementsCoverSealedType((ReferenceBinding)selectorType, this.caseLabelElementTypes)) {
            this.switchBits |= 4;
        } else if (selectorType.isRecordWithComponents() && this.containsRecordPatterns && this.caseElementsCoverRecordType(upperScope, compilerOptions, (ReferenceBinding)selectorType)) {
            this.switchBits |= 4;
        }
        if (!this.isExhaustive()) {
            if (isEnhanced) {
                upperScope.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
            } else {
                upperScope.problemReporter().missingDefaultCase(this, false, selectorType);
            }
        }
    }

    private Set<FieldBinding> unenumeratedConstants(TypeBinding enumType, int constantCount) {
        FieldBinding[] enumFields = enumType.erasure().fields();
        HashSet<FieldBinding> unenumerated = new HashSet<FieldBinding>(Arrays.asList(enumFields));
        int i = 0;
        int max = enumFields.length;
        while (i < max) {
            FieldBinding enumConstant = enumFields[i];
            if ((enumConstant.modifiers & 0x4000) == 0) {
                unenumerated.remove(enumConstant);
            } else {
                int j = 0;
                while (j < constantCount) {
                    Expression expression;
                    if (TypeBinding.equalsEquals(this.labelExpressions[j].expression.resolvedType, enumType) && (expression = this.labelExpressions[j].expression) instanceof NameReference) {
                        NameReference reference = (NameReference)expression;
                        if (enumConstant.id == reference.fieldBinding().original().id) {
                            unenumerated.remove(enumConstant);
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return unenumerated;
    }

    private boolean isExhaustive() {
        return (this.switchBits & 4) != 0;
    }

    private boolean isEnhancedSwitch(BlockScope upperScope, TypeBinding expressionType) {
        if (expressionType == null || this instanceof SwitchExpression) {
            return false;
        }
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(upperScope.compilerOptions())) {
            boolean nonTraditionalSelector = !expressionType.isEnum();
            switch (expressionType.id) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    nonTraditionalSelector = false;
                }
            }
            if (nonTraditionalSelector || this.containsPatterns || this.containsNull) {
                return true;
            }
        }
        if (JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(upperScope.compilerOptions())) {
            switch (expressionType.id) {
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean caseElementsCoverRecordType(BlockScope skope, CompilerOptions compilerOptions, ReferenceBinding recordType) {
        RNode head = new RNode(recordType);
        for (Pattern pattern : this.caseLabelElements) {
            head.addPattern(pattern);
        }
        CoverageCheckerVisitor ccv = new CoverageCheckerVisitor();
        head.traverse(ccv);
        return ccv.covers;
    }

    private boolean caseElementsCoverSealedType(ReferenceBinding sealedType, List<TypeBinding> listedTypes) {
        List<ReferenceBinding> allAllowedTypes = sealedType.getAllEnumerableAvatars();
        Iterator<ReferenceBinding> iterator = allAllowedTypes.iterator();
        block0: while (iterator.hasNext()) {
            int constantCount;
            Set<FieldBinding> unenumeratedConstants;
            ReferenceBinding next = iterator.next();
            if (next.isAbstract() && next.isSealed()) {
                iterator.remove();
                continue;
            }
            if (next.isEnum() && (unenumeratedConstants = this.unenumeratedConstants(next, constantCount = this.labelExpressions.length)).size() == 0) {
                iterator.remove();
                continue;
            }
            for (TypeBinding type : listedTypes) {
                if (!next.erasure().isCompatibleWith(type.erasure())) continue;
                iterator.remove();
                continue block0;
            }
        }
        return allAllowedTypes.size() == 0;
    }

    private void reserveSecretVariablesSlot() {
        this.selector = new LocalVariableBinding(SecretSelectorVariableName, (TypeBinding)this.scope.getJavaLangObject(), 0, false);
        this.scope.addLocalVariable(this.selector);
        this.selector.setConstant(Constant.NotAConstant);
    }

    private void releaseUnusedSecretVariable() {
        if (this.selector != null) {
            if (this.expression.resolvedType.id == 11 && !this.isNonTraditional) {
                this.selector.useFlag = 1;
                this.selector.type = this.scope.getJavaLangString();
            } else if (this.indySwitch()) {
                this.selector.useFlag = 1;
                this.selector.type = this.expression.resolvedType;
            } else {
                this.selector = null;
            }
        }
    }

    private boolean indySwitch() {
        if (this.containsPatterns || this.containsNull || (this.switchBits & 8) != 0) {
            return true;
        }
        TypeBinding eType = this.expression.resolvedType;
        if (eType == null) {
            return false;
        }
        switch (eType.id) {
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
            case 7: 
            case 8: 
            case 9: {
                if (!this.isPrimitiveSwitch) break;
                return true;
            }
        }
        return !eType.isPrimitiveOrBoxedPrimitiveType() && !eType.isEnum() && eType.id != 11;
    }

    @Override
    public void resolve(BlockScope upperScope) {
        try {
            CompilerOptions compilerOptions;
            TypeBinding expressionType;
            block30: {
                block31: {
                    block32: {
                        expressionType = this.expression.resolveType(upperScope);
                        if (expressionType != null && !expressionType.isValidBinding()) {
                            expressionType = null;
                        }
                        compilerOptions = upperScope.compilerOptions();
                        if (expressionType == null) break block30;
                        this.expression.computeConversion(upperScope, expressionType, expressionType);
                        if (!expressionType.isBaseType()) break block31;
                        if (expressionType.id != 6) break block32;
                        upperScope.problemReporter().illegalVoidExpression(this.expression);
                        break block30;
                    }
                    if (JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(compilerOptions)) {
                        upperScope.referenceContext().compilationResult().usesPreview = true;
                        this.isPrimitiveSwitch = true;
                    }
                    if (this.expression.isConstantValueOfTypeAssignableToType(expressionType, TypeBinding.INT) || expressionType.isCompatibleWith(TypeBinding.INT)) break block30;
                }
                if (expressionType.id != 11 && !expressionType.isEnum() && !upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT)) {
                    if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && (!expressionType.isBaseType() || expressionType.id == 12 || expressionType.id == 6)) {
                        this.isNonTraditional = true;
                    } else if (!this.isPrimitiveSwitch) {
                        upperScope.problemReporter().incorrectSwitchType(this.expression, expressionType);
                        expressionType = null;
                    }
                }
            }
            this.scope = new BlockScope(upperScope);
            if (expressionType != null) {
                this.reserveSecretVariablesSlot();
            } else {
                this.switchBits |= 2;
            }
            if (this.statements != null) {
                this.preprocess();
                LocalVariableBinding[] patternVariables = NO_VARIABLES;
                boolean trueSeen = false;
                boolean falseSeen = false;
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement statement = statementArray[n2];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement = (CaseStatement)statement;
                        caseStatement.swich = this;
                        caseStatement.resolve(this.scope);
                        patternVariables = caseStatement.bindingsWhenTrue();
                        Boolean booleanConstant = caseStatement.getBooleanConstantValue();
                        if (booleanConstant == Boolean.TRUE) {
                            trueSeen = true;
                        } else if (booleanConstant == Boolean.FALSE) {
                            falseSeen = true;
                        }
                    } else {
                        statement.resolveWithBindings(patternVariables, this.scope);
                        patternVariables = LocalVariableBinding.merge(patternVariables, statement.bindingsWhenComplete());
                    }
                    ++n2;
                }
                if (expressionType != null && (expressionType.id == 5 || expressionType.id == 33) && this.defaultCase != null && trueSeen && falseSeen) {
                    upperScope.problemReporter().caseDefaultPlusTrueAndFalse(this);
                }
                if (this.labelExpressions.length != this.labelExpressionIndex) {
                    this.labelExpressions = new CaseStatement.LabelExpression[this.labelExpressionIndex];
                    System.arraycopy(this.labelExpressions, 0, this.labelExpressions, 0, this.labelExpressionIndex);
                }
            } else if ((this.bits & 8) != 0) {
                upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
            }
            if (expressionType != null) {
                if (!expressionType.isBaseType() && upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT) && !this.containsPatterns && !this.containsNull) {
                    this.expression.computeConversion(upperScope, TypeBinding.INT, expressionType);
                }
                this.releaseUnusedSecretVariable();
                this.complainIfNotExhaustiveSwitch(upperScope, expressionType, compilerOptions);
            }
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    protected void reportMissingEnumConstantCase(BlockScope upperScope, FieldBinding enumConstant) {
        upperScope.problemReporter().missingEnumConstantCase(this, enumConstant);
    }

    @Override
    public void branchChainTo(BranchLabel label) {
        if (this.breakLabel.forwardReferenceCount() > 0) {
            label.becomeDelegateFor(this.breakLabel);
        }
    }

    protected boolean needToCheckFlowInAbsenceOfDefaultBranch() {
        return !this.isExhaustive();
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            TypeBinding resolvedTypeBinding;
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
            if (!this.containsNull && this.expression.resolvedType instanceof ReferenceBinding) {
                this.expression.checkNPE(currentScope, flowContext, flowInfo, 1);
            }
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel, true, true);
            CompilerOptions compilerOptions = currentScope.compilerOptions();
            FlowInfo caseInits = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            if (this.statements != null) {
                int initialComplaintLevel;
                int complaintLevel = initialComplaintLevel = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
                int fallThroughState = 0;
                int prevCaseStmtIndex = -100;
                int i = 0;
                int max = this.statements.length;
                while (i < max) {
                    Statement statement = this.statements[i];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement;
                        this.scope.enclosingCase = caseStatement = (CaseStatement)statement;
                        if (prevCaseStmtIndex == i - 1 && this.statements[prevCaseStmtIndex].containsPatternVariable()) {
                            this.scope.problemReporter().illegalFallthroughFromAPattern(this.statements[prevCaseStmtIndex]);
                        }
                        prevCaseStmtIndex = i;
                        if (fallThroughState == 1 && complaintLevel <= 0) {
                            if (statement.containsPatternVariable()) {
                                this.scope.problemReporter().IllegalFallThroughToPattern(this.scope.enclosingCase);
                            } else if ((statement.bits & 0x20000000) == 0) {
                                this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                            }
                        }
                        caseInits = caseInits.mergedWith(flowInfo.unconditionalInits());
                        if (caseStatement.constantExpressions == NO_EXPRESSIONS && (this.switchBits & 1) != 0 && this.expression.resolvedType instanceof ReferenceBinding) {
                            if (this.expression instanceof NameReference) {
                                NameReference reference = (NameReference)this.expression;
                                if (reference.localVariableBinding() != null) {
                                    caseInits.markAsDefinitelyNonNull(reference.localVariableBinding());
                                } else if (reference.lastFieldBinding() != null && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                    switchContext.recordNullCheckedFieldReference(reference, 2);
                                }
                            } else if (this.expression instanceof FieldReference && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                switchContext.recordNullCheckedFieldReference((FieldReference)this.expression, 2);
                            }
                        }
                        complaintLevel = initialComplaintLevel;
                        fallThroughState = this.containsPatterns ? 1 : 0;
                    } else {
                        fallThroughState = (this.switchBits & 1) != 0 || statement.doesNotCompleteNormally() ? 2 : 1;
                    }
                    complaintLevel = statement.complainIfUnreachable(caseInits, this.scope, complaintLevel, true);
                    if (complaintLevel < 2) {
                        caseInits = statement.analyseCode(this.scope, switchContext, caseInits);
                        if (compilerOptions.enableSyntacticNullAnalysisForFields) {
                            switchContext.expireNullCheckedFieldInfo();
                        }
                        if (compilerOptions.analyseResourceLeaks) {
                            FakedTrackingVariable.cleanUpUnassigned(this.scope, statement, caseInits, false);
                        }
                    }
                    ++i;
                }
            }
            if (caseInits != FlowInfo.DEAD_END) {
                if (this.isTrulyExpression()) {
                    currentScope.problemReporter().switchExpressionBlockCompletesNormally(this.statements[this.statements.length - 1]);
                }
                if (this.defaultCase == null) {
                    this.switchBits |= 0x20;
                }
            }
            if ((resolvedTypeBinding = this.expression.resolvedType).isEnum() && !this.indySwitch()) {
                SourceTypeBinding sourceTypeBinding = currentScope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(resolvedTypeBinding, this);
            }
            if (this.defaultCase == null && this.needToCheckFlowInAbsenceOfDefaultBranch()) {
                flowInfo.addPotentialInitializationsFrom(caseInits.mergedWith(switchContext.initsOnBreak));
                this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo2 = flowInfo;
                return flowInfo2;
            }
            UnconditionalFlowInfo mergedInfo = caseInits.mergedWith(switchContext.initsOnBreak);
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            UnconditionalFlowInfo unconditionalFlowInfo = mergedInfo;
            return unconditionalFlowInfo;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        SwitchTranslator.PatternSwitchTranslator translator = this.indySwitch() ? new SwitchTranslator.PatternSwitchTranslator() : (this.expression.resolvedType.id == 11 && !this.isNonTraditional ? new SwitchTranslator.StringSwitchTranslator() : (this.expression.resolvedType.isEnum() ? new SwitchTranslator.ClassicEnumSwitchTranslator() : new SwitchTranslator.ClassicSwitchTranslator()));
        translator.setSwitch(this);
        translator.generateCode(currentScope, codeStream);
    }

    @Override
    public boolean isTrulyExpression() {
        return false;
    }

    @Override
    public boolean doesNotCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        if (!this.isExhaustive() && this.defaultCase == null) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.breaksOut(null)) {
                return false;
            }
            ++n2;
        }
        return this.statements[this.statements.length - 1].doesNotCompleteNormally();
    }

    @Override
    public boolean completesByContinue() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.completesByContinue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public StringBuilder printStatement(int indent, StringBuilder output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                output.append('\n');
                if (statement instanceof CaseStatement) {
                    statement.printStatement(indent, output);
                } else {
                    statement.printStatement(indent + 2, output);
                }
                ++n2;
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        return this.printStatement(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, blockScope);
            if (this.statements != null) {
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement statement = statementArray[n2];
                    statement.traverse(visitor, this.scope);
                    ++n2;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    class CoverageCheckerVisitor {
        public boolean covers = true;

        CoverageCheckerVisitor() {
        }

        public boolean visit(TNode node) {
            ReferenceBinding referenceBinding;
            if (node.hasError) {
                return false;
            }
            ArrayList<TypeBinding> availableTypes = new ArrayList<TypeBinding>();
            if (node.children != null) {
                for (Node node2 : node.children) {
                    if (node.type.isSubtypeOf(node2.type, false)) {
                        this.covers = true;
                    }
                    node2.traverse(this);
                    if (node.type.isSubtypeOf(node2.type, false) && this.covers) {
                        return false;
                    }
                    availableTypes.add(node2.type);
                }
            }
            if (node.type instanceof ReferenceBinding && (referenceBinding = (ReferenceBinding)node.type).isSealed()) {
                this.covers &= SwitchStatement.this.caseElementsCoverSealedType(referenceBinding, availableTypes);
                return this.covers;
            }
            this.covers = false;
            return false;
        }
    }

    abstract class Node {
        TypeBinding type;
        boolean hasError = false;

        Node() {
        }

        public abstract void traverse(CoverageCheckerVisitor var1);
    }

    class PatternNode
    extends Node {
        TNode next;

        PatternNode(TypeBinding type) {
            this.type = type;
        }

        public void addPattern(RecordPattern rp, int i) {
            TypeBinding ref = SwitchStatement.this.expression.resolvedType;
            RecordComponentBinding[] comps = ref.components();
            if (comps == null || comps.length <= i) {
                return;
            }
            if (this.next == null) {
                this.next = new TNode(comps[i].type);
            }
            this.next.addPattern(rp, i);
        }

        public String toString() {
            return "[" + (this.type.isRecord() ? "Record" : "") + "Pattern node] {\n    type:" + String.valueOf(this.type) + "    next:" + String.valueOf(this.next) + "\n}\n";
        }

        @Override
        public void traverse(CoverageCheckerVisitor visitor) {
            if (this.next != null) {
                visitor.visit(this.next);
            }
        }
    }

    class RNode
    extends Node {
        TNode firstComponent;

        RNode(TypeBinding rec) {
            RecordComponentBinding comp;
            int len;
            this.type = rec;
            RecordComponentBinding[] comps = rec.components();
            int n = len = comps != null ? comps.length : 0;
            if (len > 0 && (comp = comps[0]) != null && comp.type != null) {
                this.firstComponent = new TNode(comp.type);
            }
        }

        void addPattern(Pattern p) {
            if (p instanceof RecordPattern) {
                RecordPattern rp = (RecordPattern)p;
                if (TypeBinding.equalsEquals(this.type, rp.type.resolvedType) && this.firstComponent != null) {
                    this.firstComponent.addPattern(rp, 0);
                }
            }
        }

        public String toString() {
            return "[RNode] {\n    type:" + String.valueOf(this.type) + "     firstComponent:" + String.valueOf(this.firstComponent) + "\n}\n";
        }

        @Override
        public void traverse(CoverageCheckerVisitor visitor) {
            if (this.firstComponent != null) {
                visitor.visit(this.firstComponent);
            }
        }
    }

    public static final class SingletonBootstrap
    extends Record {
        private final String id;
        private final char[] selector;
        private final char[] signature;

        public String id() {
            return this.id;
        }

        public char[] selector() {
            return this.selector;
        }

        public char[] signature() {
            return this.signature;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SingletonBootstrap.class, "id;selector;signature", "id", "selector", "signature"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SingletonBootstrap.class, "id;selector;signature", "id", "selector", "signature"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SingletonBootstrap.class, "id;selector;signature", "id", "selector", "signature"}, this, object);
        }

        public SingletonBootstrap(String string, char[] cArray, char[] cArray2) {
            this.id = string;
            this.selector = cArray;
            this.signature = cArray2;
        }
    }

    static abstract class SwitchTranslator {
        protected SwitchStatement swich;
        int[] constants;
        int constantCount;
        BranchLabel[] caseLabels;

        SwitchTranslator() {
        }

        public void setSwitch(SwitchStatement swich) {
            this.swich = swich;
        }

        protected <T extends BranchLabel> void gatherLabels(CodeStream codeStream, Function<CodeStream, T> newLabel) {
            int i = 0;
            int j = 0;
            int max = this.swich.caseCount;
            while (i < max) {
                BranchLabel label;
                CaseStatement stmt = this.swich.cases[i];
                stmt.targetLabel = label = (BranchLabel)newLabel.apply(codeStream);
                Expression[] expressionArray = stmt.peeledLabelExpressions();
                int n = expressionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression e = expressionArray[n2];
                    if (!(e instanceof FakeDefaultLiteral)) {
                        this.caseLabels[j++] = label;
                    }
                    ++n2;
                }
                ++i;
            }
        }

        protected void initializeLabels(CodeStream codeStream) {
            this.swich.breakLabel.initialize(codeStream);
            this.caseLabels = new CaseLabel[this.swich.nConstants];
            this.gatherLabels(codeStream, CaseLabel::new);
            this.swich.defaultLabel = this.swich.defaultCase != null ? (CaseLabel)this.swich.defaultCase.targetLabel : (this.swich.unconditionalPatternCase != null ? (CaseLabel)this.swich.unconditionalPatternCase.targetLabel : new CaseLabel(codeStream));
        }

        protected void gatherCaseConstantsOrProxies(CodeStream codeStream) {
            this.constantCount = this.swich.labelExpressions.length;
            this.constants = new int[this.constantCount];
            int i = 0;
            int length = this.swich.labelExpressions.length;
            while (i < length) {
                this.constants[i] = this.swich.labelExpressions[i].intValue();
                ++i;
            }
        }

        protected void finalizeLabels(CodeStream codeStream) {
        }

        protected void generateSelectorExpression(BlockScope currentScope, CodeStream codeStream) {
            this.swich.expression.generateCode(currentScope, codeStream, true);
            if (this.swich.expression.resolvedType.id == 33) {
                codeStream.generateUnboxingConversion(5);
            }
        }

        protected void generateSwitchByteCode(BlockScope currentScope, CodeStream codeStream) {
            if ((this.swich.switchBits & 0x40) != 0) {
                int[] sortedIndexes = new int[this.constantCount];
                int i = 0;
                while (i < this.constantCount) {
                    sortedIndexes[i] = i;
                    ++i;
                }
                int[] localKeysCopy = new int[this.constantCount];
                System.arraycopy(this.constants, 0, localKeysCopy, 0, this.constantCount);
                CodeStream.sort(localKeysCopy, 0, this.constantCount - 1, sortedIndexes);
                int max = localKeysCopy[this.constantCount - 1];
                int min = localKeysCopy[0];
                if ((long)((double)this.constantCount * 2.5) > (long)max - (long)min) {
                    codeStream.tableswitch(this.swich.defaultLabel, min, max, this.constants, sortedIndexes, (CaseLabel[])this.caseLabels);
                } else {
                    codeStream.lookupswitch(this.swich.defaultLabel, this.constants, sortedIndexes, (CaseLabel[])this.caseLabels);
                }
                codeStream.recordPositionsFrom(codeStream.position, this.swich.expression.sourceEnd);
            } else {
                codeStream.pop();
            }
        }

        protected final void generateSwitchBlock(BlockScope currentScope, CodeStream codeStream) {
            if (this.swich.statements != null) {
                Statement[] statementArray = this.swich.statements;
                int n = this.swich.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement statement = statementArray[n2];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement;
                        this.swich.scope.enclosingCase = caseStatement = (CaseStatement)statement;
                        if (this.swich.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.swich.preSwitchInitStateIndex);
                        }
                    }
                    statement.generateCode(this.swich.scope, codeStream);
                    if (statement instanceof Block) {
                        Block block = (Block)statement;
                        if ((block.bits & 1) != 0) {
                            codeStream.goto_(this.swich.breakLabel);
                        }
                    }
                    ++n2;
                }
            }
        }

        protected final void generateDefaultCase(BlockScope currentScope, CodeStream codeStream) {
            if (this.swich.defaultCase == null && this.swich.unconditionalPatternCase == null) {
                boolean needsThrowingDefault;
                boolean bl = needsThrowingDefault = this.swich.expression.resolvedType.isEnum() && (this.swich instanceof SwitchExpression || this.swich.containsNull);
                if (needsThrowingDefault |= this.swich.isExhaustive()) {
                    if (this.swich.preSwitchInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.swich.preSwitchInitStateIndex);
                    }
                    if (this.swich.scope.compilerOptions().complianceLevel >= 0x3F0000L) {
                        if ((this.swich.switchBits & 0x20) != 0) {
                            codeStream.goto_(this.swich.breakLabel);
                        }
                        this.swich.defaultLabel.place();
                        codeStream.newJavaLangMatchException();
                        codeStream.dup();
                        codeStream.aconst_null();
                        codeStream.aconst_null();
                        codeStream.invokeJavaLangMatchExceptionConstructor();
                        codeStream.athrow();
                    } else {
                        this.swich.defaultLabel.place();
                        codeStream.newJavaLangIncompatibleClassChangeError();
                        codeStream.dup();
                        codeStream.invokeJavaLangIncompatibleClassChangeErrorDefaultConstructor();
                        codeStream.athrow();
                    }
                }
            }
        }

        protected final void generateEpilogue(BlockScope currentScope, CodeStream codeStream, int pc) {
            this.swich.breakLabel.place();
            if (this.swich.defaultLabel.position == -1) {
                codeStream.recordPositionsFrom(codeStream.position, this.swich.sourceEnd, true);
                this.swich.defaultLabel.place();
            }
            if (this.swich.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.swich.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.swich.mergedInitStateIndex);
            }
            codeStream.removeVariable(this.swich.selector);
            if (this.swich.scope != currentScope) {
                codeStream.exitUserScope(this.swich.scope);
            }
            codeStream.recordPositionsFrom(pc, this.swich.sourceStart);
        }

        public final void generateCode(BlockScope currentScope, CodeStream codeStream) {
            if ((this.swich.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            try {
                int pc = codeStream.position;
                this.initializeLabels(codeStream);
                this.gatherCaseConstantsOrProxies(codeStream);
                this.finalizeLabels(codeStream);
                this.generateSelectorExpression(currentScope, codeStream);
                this.generateSwitchByteCode(currentScope, codeStream);
                this.generateSwitchBlock(currentScope, codeStream);
                this.generateDefaultCase(currentScope, codeStream);
                this.generateEpilogue(currentScope, codeStream, pc);
            }
            finally {
                if (this.swich.scope != null) {
                    this.swich.scope.enclosingCase = null;
                }
            }
        }

        static final class ClassicEnumSwitchTranslator
        extends SwitchTranslator {
            ClassicEnumSwitchTranslator() {
            }

            @Override
            protected void generateSelectorExpression(BlockScope currentScope, CodeStream codeStream) {
                codeStream.invoke((byte)-72, this.swich.synthetic, null);
                this.swich.expression.generateCode(currentScope, codeStream, true);
                codeStream.invokeEnumOrdinal(this.swich.expression.resolvedType.constantPoolName());
                codeStream.iaload();
            }
        }

        static final class ClassicSwitchTranslator
        extends SwitchTranslator {
            ClassicSwitchTranslator() {
            }
        }

        static final class PatternSwitchTranslator
        extends SwitchTranslator {
            PatternSwitchTranslator() {
            }

            @Override
            protected void gatherCaseConstantsOrProxies(CodeStream codeStream) {
                this.constantCount = this.swich.labelExpressions.length;
                this.constants = new int[this.constantCount];
                int i = 0;
                int j = 0;
                int length = this.swich.labelExpressions.length;
                while (i < length) {
                    CaseStatement.LabelExpression labelExpression = this.swich.labelExpressions[i];
                    this.constants[i] = labelExpression.index - j;
                    if (labelExpression.type.isPrimitiveType()) {
                        SingletonBootstrap descriptor;
                        SingletonBootstrap singletonBootstrap = labelExpression.isPattern() ? PRIMITIVE_CLASS__BOOTSTRAP : (descriptor = labelExpression.type.id == 5 ? GET_STATIC_FINAL__BOOTSTRAP : null);
                        if (descriptor != null) {
                            labelExpression.primitivesBootstrapIdx = codeStream.classFile.recordSingletonBootstrapMethod(descriptor);
                        }
                    } else if (labelExpression.isQualifiedEnum()) {
                        labelExpression.enumDescIdx = codeStream.classFile.recordBootstrapMethod(labelExpression);
                        labelExpression.classDescIdx = codeStream.classFile.recordBootstrapMethod(labelExpression.type);
                    } else if (labelExpression.expression instanceof NullLiteral) {
                        j = 1;
                    }
                    ++i;
                }
            }

            private char[] typeSwitchSignature(TypeBinding exprType) {
                char[] cArray;
                switch (exprType.id) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        if (this.swich.isPrimitiveSwitch) {
                            cArray = exprType.signature();
                            break;
                        }
                        cArray = "Ljava/lang/Object;".toCharArray();
                        break;
                    }
                    default: {
                        cArray = exprType.id > 128 && exprType.erasure().isBoxedPrimitiveType() ? exprType.erasure().signature() : (exprType.isPrimitiveType() || exprType.isEnum() ? exprType.signature() : "Ljava/lang/Object;".toCharArray());
                    }
                }
                char[] arg1 = cArray;
                return CharOperation.concat("(".toCharArray(), arg1, "I)I".toCharArray());
            }

            @Override
            protected void generateSelectorExpression(BlockScope currentScope, CodeStream codeStream) {
                this.swich.expression.generateCode(currentScope, codeStream, true);
                if (!this.swich.containsNull && !this.swich.expression.resolvedType.isPrimitiveType()) {
                    codeStream.dup();
                    codeStream.invokeJavaUtilObjectsrequireNonNull();
                    codeStream.pop();
                }
                codeStream.store(this.swich.selector, false);
                codeStream.addVariable(this.swich.selector);
                int invokeDynamicNumber = codeStream.classFile.recordBootstrapMethod(this.swich);
                codeStream.load(this.swich.selector);
                codeStream.loadInt(0);
                this.swich.switchPatternRestartTarget = new BranchLabel(codeStream);
                this.swich.switchPatternRestartTarget.place();
                TypeBinding selectorType = this.swich.expression.resolvedType;
                char[] signature = this.typeSwitchSignature(selectorType);
                int argsSize = TypeIds.getCategory(selectorType.id) + 1;
                char[] bootstrap = selectorType.isEnum() ? ConstantPool.ENUMSWITCH : ConstantPool.TYPESWITCH;
                codeStream.invokeDynamic(invokeDynamicNumber, argsSize, 1, bootstrap, signature, TypeBinding.INT);
            }
        }

        static final class StringSwitchTranslator
        extends SwitchTranslator {
            private StringCaseConstant[] stringCaseConstants;

            StringSwitchTranslator() {
            }

            @Override
            protected void initializeLabels(CodeStream codeStream) {
                this.swich.breakLabel.initialize(codeStream);
                this.caseLabels = new BranchLabel[this.swich.nConstants];
                this.gatherLabels(codeStream, BranchLabel::new);
                this.swich.defaultLabel = new CaseLabel(codeStream, true);
                if (this.swich.defaultCase != null) {
                    this.swich.defaultCase.targetLabel = this.swich.defaultLabel;
                }
            }

            @Override
            protected void gatherCaseConstantsOrProxies(CodeStream codeStream) {
                this.stringCaseConstants = new StringCaseConstant[this.swich.nConstants];
                int[] hashCodes = new int[this.swich.nConstants];
                int i = 0;
                while (i < this.swich.nConstants) {
                    String literal = this.swich.labelExpressions[i].constant.stringValue();
                    this.stringCaseConstants[i] = new StringCaseConstant(literal.hashCode(), literal, this.caseLabels[i]);
                    ++i;
                }
                Arrays.sort(this.stringCaseConstants);
                int uniqHashCount = 0;
                int lastHashCode = 0;
                int i2 = 0;
                while (i2 < this.swich.nConstants) {
                    int hashCode = this.stringCaseConstants[i2].hashKode;
                    if (i2 == 0 || hashCode != lastHashCode) {
                        int n = uniqHashCount++;
                        int n2 = hashCode;
                        hashCodes[n] = n2;
                        lastHashCode = n2;
                    }
                    ++i2;
                }
                if (uniqHashCount != this.swich.nConstants) {
                    int[] nArray = hashCodes;
                    hashCodes = new int[uniqHashCount];
                    System.arraycopy(nArray, 0, hashCodes, 0, uniqHashCount);
                }
                this.constants = hashCodes;
                this.constantCount = uniqHashCount;
            }

            @Override
            protected void finalizeLabels(CodeStream codeStream) {
                this.caseLabels = new CaseLabel[this.constantCount];
                int i = 0;
                while (i < this.constantCount) {
                    this.caseLabels[i] = new CaseLabel(codeStream);
                    ++i;
                }
            }

            @Override
            protected void generateSelectorExpression(BlockScope currentScope, CodeStream codeStream) {
                this.swich.expression.generateCode(currentScope, codeStream, true);
                codeStream.store(this.swich.selector, true);
                codeStream.addVariable(this.swich.selector);
                codeStream.invokeStringHashCode();
            }

            @Override
            protected void generateSwitchByteCode(BlockScope currentScope, CodeStream codeStream) {
                int[] sortedIndexes = new int[this.constantCount];
                int i = 0;
                while (i < this.constantCount) {
                    sortedIndexes[i] = i;
                    ++i;
                }
                int lastHashCode = 0;
                codeStream.lookupswitch(this.swich.defaultLabel, this.constants, sortedIndexes, (CaseLabel[])this.caseLabels);
                int i2 = 0;
                int j = 0;
                while (i2 < this.swich.nConstants) {
                    int hashCode = this.stringCaseConstants[i2].hashKode;
                    if (i2 == 0 || hashCode != lastHashCode) {
                        lastHashCode = hashCode;
                        if (i2 != 0) {
                            codeStream.goto_(this.swich.defaultLabel);
                        }
                        this.caseLabels[j++].place();
                    }
                    codeStream.load(this.swich.selector);
                    codeStream.ldc(this.stringCaseConstants[i2].string);
                    codeStream.invokeStringEquals();
                    codeStream.ifne(this.stringCaseConstants[i2].label);
                    ++i2;
                }
                codeStream.goto_(this.swich.defaultLabel);
            }

            private static final class StringCaseConstant
            extends Record
            implements Comparable<StringCaseConstant> {
                private final int hashKode;
                private final String string;
                private final BranchLabel label;

                @Override
                public int compareTo(StringCaseConstant that) {
                    return this.hashKode == that.hashKode ? 0 : (this.hashKode > that.hashKode ? 1 : -1);
                }

                public int hashKode() {
                    return this.hashKode;
                }

                public String string() {
                    return this.string;
                }

                public BranchLabel label() {
                    return this.label;
                }

                @Override
                public final String toString() {
                    return ObjectMethods.bootstrap("toString", new MethodHandle[]{StringCaseConstant.class, "hashKode;string;label", "hashKode", "string", "label"}, this);
                }

                @Override
                public final int hashCode() {
                    return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StringCaseConstant.class, "hashKode;string;label", "hashKode", "string", "label"}, this);
                }

                @Override
                public final boolean equals(Object object) {
                    return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StringCaseConstant.class, "hashKode;string;label", "hashKode", "string", "label"}, this, object);
                }

                private StringCaseConstant(int n, String string, BranchLabel branchLabel) {
                    this.hashKode = n;
                    this.string = string;
                    this.label = branchLabel;
                }
            }
        }
    }

    class TNode
    extends Node {
        List<PatternNode> children;

        TNode(TypeBinding type) {
            this.type = type;
            this.children = new ArrayList<PatternNode>();
        }

        public void addPattern(RecordPattern rp, int i) {
            if (rp.patterns.length <= i) {
                this.hasError = true;
                return;
            }
            TypeBinding childType = rp.patterns[i].resolvedType;
            PatternNode child = null;
            for (PatternNode c : this.children) {
                if (!TypeBinding.equalsEquals(childType, c.type)) continue;
                child = c;
                break;
            }
            if (child == null) {
                child = new PatternNode(childType);
                if (this.type.isSubtypeOf(childType, false)) {
                    this.children.add(0, child);
                } else {
                    this.children.add(child);
                }
            }
            if (i + 1 < rp.patterns.length) {
                child.addPattern(rp, i + 1);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[TNode] {\n    type:" + String.valueOf(this.type) + "    children:");
            if (this.children == null) {
                sb.append("null");
            } else {
                for (Node node : this.children) {
                    sb.append(node);
                }
            }
            return sb.append("\n}\n").toString();
        }

        @Override
        public void traverse(CoverageCheckerVisitor visitor) {
            visitor.visit(this);
        }
    }
}

