/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public BlockScope scope;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int preCondInitStateIndex = -1;
    int preIncrementsInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForStatement(Statement[] initializations, Expression condition, Statement[] increments, Statement action, boolean neededScope, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.initializations = initializations;
        this.condition = condition;
        this.increments = increments;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        if (neededScope) {
            this.bits |= 0x20000000;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        int n2;
        Statement[] statementArray;
        LoopingFlowContext loopingContext;
        UnconditionalFlowInfo actionInfo;
        int initialComplaintLevel;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        int n3 = initialComplaintLevel = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
        if (this.initializations != null) {
            Statement[] statementArray2 = this.initializations;
            int n4 = this.initializations.length;
            int n5 = 0;
            while (n5 < n4) {
                Statement initialization = statementArray2[n5];
                flowInfo = initialization.analyseCode(this.scope, flowContext, flowInfo);
                ++n5;
            }
        }
        this.preCondInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        Constant cst = this.condition == null ? null : this.condition.constant;
        boolean isConditionTrue = cst == null || cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
        cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst == null || cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
        LoopingFlowContext condLoopContext = null;
        FlowInfo condInfo = flowInfo.nullInfoLessUnconditionalCopy();
        if (this.condition != null && !isConditionTrue) {
            condLoopContext = new LoopingFlowContext(flowContext, flowInfo, this, null, null, this.scope, true);
            condInfo = this.condition.analyseCode(this.scope, condLoopContext, condInfo);
            this.condition.checkNPEbyUnboxing(currentScope, flowContext, flowInfo);
        }
        if (this.action == null) {
            if (condLoopContext != null) {
                condLoopContext.complainOnDeferredFinalChecks(this.scope, condInfo);
            }
            if (isConditionTrue) {
                if (condLoopContext != null) {
                    condLoopContext.complainOnDeferredNullChecks(currentScope, condInfo);
                }
                return FlowInfo.DEAD_END;
            }
            if (isConditionFalse) {
                this.continueLabel = null;
            }
            actionInfo = condInfo.initsWhenTrue().unconditionalCopy();
            loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope, false);
        } else {
            loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, this.scope, true);
            FlowInfo initsWhenTrue = condInfo.initsWhenTrue();
            this.condIfTrueInitStateIndex = currentScope.methodScope().recordInitializationStates(initsWhenTrue);
            if (isConditionFalse) {
                actionInfo = FlowInfo.DEAD_END;
            } else {
                actionInfo = initsWhenTrue.unconditionalCopy();
                if (isConditionOptimizedFalse) {
                    actionInfo.setReachMode(1);
                }
            }
            if (this.action.complainIfUnreachable(actionInfo, this.scope, initialComplaintLevel, true) < 2) {
                if (this.condition != null) {
                    this.condition.updateFlowOnBooleanResult(actionInfo, true);
                }
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo).unconditionalInits();
            }
            if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            } else {
                if (condLoopContext != null) {
                    condLoopContext.complainOnDeferredFinalChecks(this.scope, condInfo);
                }
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue);
                loopingContext.complainOnDeferredFinalChecks(this.scope, actionInfo);
            }
        }
        FlowInfo exitBranch = flowInfo.copy();
        LoopingFlowContext incrementContext = null;
        if (this.continueLabel != null) {
            if (this.increments != null) {
                incrementContext = new LoopingFlowContext(flowContext, flowInfo, this, null, null, this.scope, true);
                FlowInfo incrementInfo = actionInfo;
                this.preIncrementsInitStateIndex = currentScope.methodScope().recordInitializationStates(incrementInfo);
                statementArray = this.increments;
                n2 = this.increments.length;
                n = 0;
                while (n < n2) {
                    Statement increment = statementArray[n];
                    incrementInfo = increment.analyseCode(this.scope, incrementContext, incrementInfo);
                    ++n;
                }
                actionInfo = ((FlowInfo)incrementInfo).unconditionalInits();
                incrementContext.complainOnDeferredFinalChecks(this.scope, actionInfo);
            }
            exitBranch.addPotentialInitializationsFrom(actionInfo).addInitializationsFrom(condInfo.initsWhenFalse());
        } else {
            exitBranch.addInitializationsFrom(condInfo.initsWhenFalse());
            if (this.increments != null && initialComplaintLevel == 0) {
                currentScope.problemReporter().fakeReachable(this.increments[0]);
            }
        }
        if (condLoopContext != null) {
            condLoopContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        }
        loopingContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        if (incrementContext != null) {
            incrementContext.complainOnDeferredNullChecks(currentScope, actionInfo);
        }
        if (loopingContext.hasEscapingExceptions()) {
            FlowInfo loopbackFlowInfo = flowInfo.copy();
            if (this.continueLabel != null) {
                loopbackFlowInfo = loopbackFlowInfo.mergedWith(loopbackFlowInfo.unconditionalCopy().addNullInfoFrom(actionInfo).unconditionalInits());
            }
            loopingContext.simulateThrowAfterLoopBack(loopbackFlowInfo);
        }
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches((loopingContext.initsOnBreak.tagBits & 3) != 0 ? loopingContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingContext.initsOnBreak), isConditionOptimizedTrue, exitBranch, isConditionOptimizedFalse, !isConditionTrue);
        if (this.initializations != null) {
            statementArray = this.initializations;
            n2 = this.initializations.length;
            n = 0;
            while (n < n2) {
                Statement init = statementArray[n];
                if (init instanceof LocalDeclaration) {
                    LocalVariableBinding binding = ((LocalDeclaration)init).binding;
                    ((FlowInfo)mergedInfo).resetAssignmentInfo(binding);
                }
                ++n;
            }
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        this.scope.checkUnclosedCloseables(mergedInfo, loopingContext, null, null);
        if (this.condition != null) {
            this.condition.updateFlowOnBooleanResult(mergedInfo, false);
        }
        return mergedInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean isConditionOptimizedFalse;
        Constant cst;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.initializations != null) {
            Statement[] statementArray = this.initializations;
            int n = this.initializations.length;
            int n2 = 0;
            while (n2 < n) {
                Statement initialization = statementArray[n2];
                initialization.generateCode(this.scope, codeStream);
                ++n2;
            }
        }
        Constant constant = cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean conditionInjectsBindings = this.condition != null ? this.condition.bindingsWhenTrue().length > 0 : false;
        boolean bl = isConditionOptimizedFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
        if (isConditionOptimizedFalse) {
            this.condition.generateCode(this.scope, codeStream, false);
            if ((this.bits & 0x20000000) != 0) {
                codeStream.exitUserScope(this.scope);
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        BranchLabel actionLabel = new BranchLabel(codeStream);
        BranchLabel conditionLabel = new BranchLabel(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel == null || conditionInjectsBindings) {
            if (this.continueLabel != null) {
                this.continueLabel.initialize(codeStream);
            }
            conditionLabel.place();
            if (this.condition != null && this.condition.constant == Constant.NotAConstant) {
                this.condition.generateOptimizedBoolean(this.scope, codeStream, null, this.breakLabel, true);
            }
        } else {
            this.continueLabel.initialize(codeStream);
            if (this.condition != null && this.condition.constant == Constant.NotAConstant && (this.action != null && !this.action.isEmptyBlock() || this.increments != null)) {
                int jumpPC = codeStream.position;
                codeStream.goto_(conditionLabel);
                codeStream.recordPositionsFrom(jumpPC, this.condition.sourceStart);
            }
        }
        if (this.action != null) {
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.condIfTrueInitStateIndex);
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.condIfTrueInitStateIndex);
            }
            actionLabel.place();
            this.action.generateCode(this.scope, codeStream);
        } else {
            actionLabel.place();
        }
        if (this.preIncrementsInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preIncrementsInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.preIncrementsInitStateIndex);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            if (this.increments != null) {
                Statement[] statementArray = this.increments;
                int n = this.increments.length;
                int n3 = 0;
                while (n3 < n) {
                    Statement increment = statementArray[n3];
                    increment.generateCode(this.scope, codeStream);
                    ++n3;
                }
            }
            if (this.preCondInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preCondInitStateIndex);
            }
            if (conditionInjectsBindings) {
                codeStream.goto_(conditionLabel);
            } else {
                conditionLabel.place();
                if (this.condition != null && this.condition.constant == Constant.NotAConstant) {
                    this.condition.generateOptimizedBoolean(this.scope, codeStream, actionLabel, null, true);
                } else {
                    codeStream.goto_(actionLabel);
                }
            }
        } else if (this.preCondInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preCondInitStateIndex);
        }
        if ((this.bits & 0x20000000) != 0) {
            codeStream.exitUserScope(this.scope);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        this.breakLabel.place();
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public StringBuilder printStatement(int tab, StringBuilder output) {
        int i;
        ForStatement.printIndent(tab, output).append("for (");
        if (this.initializations != null) {
            i = 0;
            while (i < this.initializations.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.initializations[i].print(0, output);
                ++i;
            }
        }
        output.append("; ");
        if (this.condition != null) {
            this.condition.printExpression(0, output);
        }
        output.append("; ");
        if (this.increments != null) {
            i = 0;
            while (i < this.increments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.increments[i].print(0, output);
                ++i;
            }
        }
        output.append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenComplete() {
        return this.condition != null && this.action != null && !this.action.breaksOut(null) ? this.condition.bindingsWhenFalse() : NO_VARIABLES;
    }

    @Override
    public void resolve(BlockScope upperScope) {
        int n;
        int n2;
        Statement[] statementArray;
        LocalVariableBinding[] patternVariablesInTrueScope = NO_VARIABLES;
        if (this.scope == null) {
            BlockScope blockScope = this.scope = (this.bits & 0x20000000) != 0 ? new BlockScope(upperScope) : upperScope;
        }
        if (this.initializations != null) {
            statementArray = this.initializations;
            n2 = this.initializations.length;
            n = 0;
            while (n < n2) {
                Statement initialization = statementArray[n];
                initialization.resolve(this.scope);
                ++n;
            }
        }
        if (this.condition != null) {
            if ((this.bits & 0x20000000) != 0) {
                this.scope.reparentLocals(true);
            }
            TypeBinding type = this.condition.resolveTypeExpecting(this.scope, TypeBinding.BOOLEAN);
            this.scope.reparentLocals(false);
            this.condition.computeConversion(this.scope, type, type);
            patternVariablesInTrueScope = this.condition.bindingsWhenTrue();
        }
        if (this.increments != null) {
            statementArray = this.increments;
            n2 = this.increments.length;
            n = 0;
            while (n < n2) {
                Statement increment = statementArray[n];
                increment.resolveWithBindings(patternVariablesInTrueScope, this.scope);
                ++n;
            }
        }
        if (this.action != null) {
            this.action.resolveWithBindings(patternVariablesInTrueScope, this.scope);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            int i;
            if (this.initializations != null) {
                int initializationsLength = this.initializations.length;
                i = 0;
                while (i < initializationsLength) {
                    this.initializations[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.condition != null) {
                this.condition.traverse(visitor, this.scope);
            }
            if (this.increments != null) {
                int incrementsLength = this.increments.length;
                i = 0;
                while (i < incrementsLength) {
                    this.increments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public boolean doesNotCompleteNormally() {
        boolean isConditionOptimizedTrue;
        Constant cst = this.condition == null ? null : this.condition.constant;
        boolean isConditionTrue = cst == null || cst != Constant.NotAConstant && cst.booleanValue();
        Constant constant = cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean bl = cst == null ? true : (isConditionOptimizedTrue = cst != Constant.NotAConstant && cst.booleanValue());
        return !(!isConditionTrue && !isConditionOptimizedTrue || this.action != null && this.action.breaksOut(null));
    }

    @Override
    public boolean completesByContinue() {
        return this.action.continuesAtOuterLabel();
    }
}

