/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.registry;

import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codetemplates.ui.highlighting.TemplateBodyHighlighter;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.IPartialEditingContentAssistContextFactory;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;

public class LanguageRegistry {
    private Map<String, Language> registeredLanguages = Maps.newHashMap();

    void register(Grammar grammar, Provider<TemplateBodyHighlighter> highlighter, ContextTypeRegistry registry, ContextTypeIdHelper helper, Provider<IPartialEditingContentAssistContextFactory> partialContentAssistContextFactory, String primaryFileExtension) {
        Language language = new Language();
        language.contextTypeRegistry = registry;
        language.templateBodyHighlighter = highlighter;
        language.helper = helper;
        language.partialContentAssistContextFactory = partialContentAssistContextFactory;
        language.primaryFileExtension = primaryFileExtension;
        this.registeredLanguages.put(grammar.getName(), language);
    }

    public TemplateBodyHighlighter getTemplateBodyHighlighter(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return (TemplateBodyHighlighter)language.templateBodyHighlighter.get();
    }

    public IPartialEditingContentAssistContextFactory getPartialContentAssistContextFactory(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return (IPartialEditingContentAssistContextFactory)language.partialContentAssistContextFactory.get();
    }

    public ContextTypeRegistry getContextTypeRegistry(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return language.contextTypeRegistry;
    }

    public ContextTypeIdHelper getContextTypeIdHelper(Grammar grammar) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        return language.helper;
    }

    public XtextResource createTemporaryResourceIn(Grammar grammar, ResourceSet resourceSet) {
        Language language = this.registeredLanguages.get(grammar.getName());
        if (language == null) {
            return null;
        }
        XtextResource syntheticResource = (XtextResource)resourceSet.createResource(URI.createURI((String)("syntethic:/unnamed." + language.primaryFileExtension)));
        return syntheticResource;
    }

    protected static class Language {
        private Provider<TemplateBodyHighlighter> templateBodyHighlighter;
        private ContextTypeRegistry contextTypeRegistry;
        private ContextTypeIdHelper helper;
        private Provider<IPartialEditingContentAssistContextFactory> partialContentAssistContextFactory;
        private String primaryFileExtension;

        protected Language() {
        }
    }
}

