/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.compare.CompareInputResourceProvider;
import org.eclipse.xtext.ui.compare.DefaultMergeEditor;
import org.eclipse.xtext.ui.compare.StreamContentAccessorDelegate;
import org.eclipse.xtext.ui.compare.StreamContentDocumentProvider;
import org.eclipse.xtext.ui.editor.CompoundXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DefaultMergeViewer
extends TextMergeViewer {
    private static final IUnitOfWork<Boolean, XtextResource> TEST_EXISTING_XTEXT_RESOURCE = new IUnitOfWork<Boolean, XtextResource>(){

        public Boolean exec(XtextResource xtextResource) throws Exception {
            if (xtextResource != null) {
                return true;
            }
            return false;
        }
    };
    private static final IResourceProvider NULL_RESOURCE_PROVIDER = new IResourceProvider(){

        public IResource getResource() {
            return null;
        }
    };
    protected IDocumentProvider documentProvider;
    protected Map<ISourceViewer, DefaultMergeEditor> sourceViewerEditorMap;
    protected Provider<XtextSourceViewerConfiguration> sourceViewerConfigurationProvider;
    protected XtextDocumentUtil xtextDocumentUtil;
    private Map<Object, IStreamContentAccessor> inputObjectStreamContentAccessorMap = Maps.newHashMap();

    public DefaultMergeViewer(Composite parent, int styles, CompareConfiguration compareConfiguration, IDocumentProvider documentProvider) {
        super(parent, styles | 0x2000000, compareConfiguration);
        this.documentProvider = documentProvider;
    }

    public DefaultMergeViewer(Composite parent, int styles, CompareConfiguration compareConfiguration, StreamContentDocumentProvider documentProvider, Provider<XtextSourceViewerConfiguration> sourceViewerConfigurationProvider) {
        super(parent, styles | 0x2000000, compareConfiguration);
        this.documentProvider = documentProvider;
        this.sourceViewerConfigurationProvider = sourceViewerConfigurationProvider;
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        ancestor = this.updateAsDocument(ancestor);
        left = this.updateAsDocument(left);
        right = this.updateAsDocument(right);
        super.updateContent(ancestor, left, right);
    }

    protected Object updateAsDocument(Object object) {
        if (object instanceof IResourceProvider && this.supportsSharedDocuments(object)) {
            return object;
        }
        if (object instanceof IStreamContentAccessor) {
            try {
                StreamContentAccessorDelegate streamContentAccessorDelegate = new StreamContentAccessorDelegate((IStreamContentAccessor)object, this.createResourceProvider(object));
                this.documentProvider.connect((Object)streamContentAccessorDelegate);
                this.inputObjectStreamContentAccessorMap.put(object, (IStreamContentAccessor)streamContentAccessorDelegate);
                return this.documentProvider.getDocument((Object)streamContentAccessorDelegate);
            }
            catch (CoreException coreException) {
                throw new WrappedException((Exception)((Object)coreException));
            }
        }
        return object;
    }

    protected IResourceProvider createResourceProvider(Object object) {
        if (this.getInput() instanceof ICompareInput && object instanceof ITypedElement) {
            return new CompareInputResourceProvider((ICompareInput)this.getInput(), (ITypedElement)object);
        }
        return NULL_RESOURCE_PROVIDER;
    }

    private boolean supportsSharedDocuments(Object object) {
        return Adapters.adapt((Object)object, ISharedDocumentAdapter.class) != null;
    }

    protected void handleDispose(DisposeEvent event) {
        this.disposeEditors();
        this.disconnectDocuments();
        super.handleDispose(event);
    }

    protected void disposeEditors() {
        if (this.sourceViewerEditorMap != null) {
            for (DefaultMergeEditor mergeEditor : this.sourceViewerEditorMap.values()) {
                mergeEditor.dispose();
            }
            this.sourceViewerEditorMap = null;
        }
    }

    protected void disconnectDocuments() {
        IMergeViewerContentProvider contentProvider = (IMergeViewerContentProvider)this.getContentProvider();
        Object ancestorContent = contentProvider.getAncestorContent(this.getInput());
        Object leftContent = contentProvider.getLeftContent(this.getInput());
        Object rightContent = contentProvider.getRightContent(this.getInput());
        this.documentProvider.disconnect((Object)this.inputObjectStreamContentAccessorMap.get(ancestorContent));
        this.documentProvider.disconnect((Object)this.inputObjectStreamContentAccessorMap.get(leftContent));
        this.documentProvider.disconnect((Object)this.inputObjectStreamContentAccessorMap.get(rightContent));
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            this.configureSourceViewer((SourceViewer)textViewer);
        }
    }

    protected void configureSourceViewer(SourceViewer sourceViewer) {
        IEditorInput editorInput = this.getEditorInput((ISourceViewer)sourceViewer);
        SourceViewerConfiguration sourceViewerConfiguration = this.createSourceViewerConfiguration(sourceViewer, editorInput);
        sourceViewer.unconfigure();
        sourceViewer.configure(sourceViewerConfiguration);
        IXtextDocument xtextDocument = this.xtextDocumentUtil.getXtextDocument((ITextViewer)sourceViewer);
        if (xtextDocument != null && !((Boolean)xtextDocument.readOnly(TEST_EXISTING_XTEXT_RESOURCE)).booleanValue()) {
            String[] configuredContentTypes;
            String[] stringArray = configuredContentTypes = sourceViewerConfiguration.getConfiguredContentTypes((ISourceViewer)sourceViewer);
            int n = configuredContentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                sourceViewer.removeTextHovers(contentType);
                ++n2;
            }
            sourceViewer.setHyperlinkDetectors(null, sourceViewerConfiguration.getHyperlinkStateMask((ISourceViewer)sourceViewer));
        }
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration(SourceViewer sourceViewer, IEditorInput editorInput) {
        Object sourceViewerConfiguration = null;
        if (editorInput != null && this.getEditor((ISourceViewer)sourceViewer) != null) {
            DefaultMergeEditor mergeEditor = this.getEditor((ISourceViewer)sourceViewer);
            sourceViewerConfiguration = mergeEditor.getXtextSourceViewerConfiguration();
            try {
                mergeEditor.init((IEditorSite)mergeEditor.getSite(), editorInput);
                mergeEditor.createActions();
            }
            catch (PartInitException partInitException) {
                throw new WrappedException((Exception)((Object)partInitException));
            }
        } else {
            sourceViewerConfiguration = (SourceViewerConfiguration)this.sourceViewerConfigurationProvider.get();
        }
        return sourceViewerConfiguration;
    }

    protected void setEditable(ISourceViewer sourceViewer, boolean state) {
        super.setEditable(sourceViewer, state);
        DefaultMergeEditor mergeEditor = this.getEditor(sourceViewer);
        if (mergeEditor != null) {
            mergeEditor.setEditable(state);
        }
    }

    protected void setActionsActivated(SourceViewer sourceViewer, boolean state) {
        DefaultMergeEditor mergeEditor = this.getEditor((ISourceViewer)sourceViewer);
        if (mergeEditor != null) {
            mergeEditor.setActionsActivated(state);
            IAction saveAction = mergeEditor.getAction(ITextEditorActionConstants.SAVE);
            if (saveAction instanceof IPageListener) {
                PartEventAction partEventAction = (PartEventAction)saveAction;
                IWorkbenchPart compareEditorPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
                if (state) {
                    partEventAction.partActivated(compareEditorPart);
                } else {
                    partEventAction.partDeactivated(compareEditorPart);
                }
            }
        }
    }

    protected IEditorInput getEditorInput(ISourceViewer sourceViewer) {
        IEditorInput editorInput = super.getEditorInput(sourceViewer);
        if (editorInput == null) {
            return null;
        }
        if (this.getSite() == null) {
            return null;
        }
        if (!(editorInput instanceof IStorageEditorInput)) {
            return null;
        }
        return editorInput;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        if (this.getSite() != null) {
            if (this.sourceViewerEditorMap == null) {
                this.sourceViewerEditorMap = Maps.newHashMapWithExpectedSize((int)3);
            }
            DefaultMergeEditor mergeEditor = this.createMergeEditor();
            mergeEditor.setXtextEditorCallback(new CompoundXtextEditorCallback(null));
            mergeEditor.setTextOrientation(textOrientation);
            mergeEditor.setInternalSite(this.getSite());
            mergeEditor.createPartControl(parent);
            SourceViewer internalSourceViewer = (SourceViewer)mergeEditor.getInternalSourceViewer();
            this.sourceViewerEditorMap.put((ISourceViewer)internalSourceViewer, mergeEditor);
            return internalSourceViewer;
        }
        return super.createSourceViewer(parent, textOrientation);
    }

    protected DefaultMergeEditor createMergeEditor() {
        Provider mergeEditorProvider = (Provider)this.getCompareConfiguration().getProperty(DefaultMergeEditor.PROVIDER);
        DefaultMergeEditor mergeEditor = (DefaultMergeEditor)mergeEditorProvider.get();
        return mergeEditor;
    }

    protected IWorkbenchPartSite getSite() {
        IWorkbenchPart workbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        return workbenchPart != null ? workbenchPart.getSite() : null;
    }

    protected boolean isEditorBacked(ITextViewer textViewer) {
        return this.getSite() != null;
    }

    protected DefaultMergeEditor getEditor(ISourceViewer sourceViewer) {
        DefaultMergeEditor mergeEditor = null;
        if (this.sourceViewerEditorMap != null) {
            mergeEditor = this.sourceViewerEditorMap.get(sourceViewer);
        }
        return mergeEditor;
    }

    protected void setXtextDocumentUtil(XtextDocumentUtil xtextDocumentUtil) {
        this.xtextDocumentUtil = xtextDocumentUtil;
    }
}

