/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;

public class WorkspaceMetamodelRegistryProvider
implements IMetamodelRegistryProvider {
    private ResourceSet resolutionRSet;
    private Map<String, MetamodelRegistry> perProjectRegs;

    public WorkspaceMetamodelRegistryProvider() {
        this((ResourceSet)new ResourceSetImpl());
    }

    public WorkspaceMetamodelRegistryProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException();
        }
        this.resolutionRSet = resourceSet;
    }

    public ResourceSet getResolutionResourceSet() {
        return this.resolutionRSet;
    }

    public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
        IProject project;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        URI uri = context.getURI();
        if (!uri.isPlatformResource()) {
            return this.getDelegateRegistry();
        }
        Path wsLocation = new Path(uri.toPlatformString(true));
        IResource wsResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)wsLocation);
        if (wsResource == null) {
            wsResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)wsLocation);
        }
        if (wsResource != null && MetamodelURIMappingHelper.hasMappingResource((IProject)(project = wsResource.getProject()))) {
            String projectKey;
            MetamodelRegistry reg;
            if (this.perProjectRegs == null) {
                this.perProjectRegs = new HashMap<String, MetamodelRegistry>();
            }
            if ((reg = this.perProjectRegs.get(projectKey = project.getFullPath().toString())) == null) {
                IMetamodelProvider provider = MetamodelURIMappingHelper.createMetamodelProvider((IProject)project, (IMetamodelProvider)this.createDelegateMetamodelProvider(), (ResourceSet)this.resolutionRSet);
                reg = new MetamodelRegistry(provider);
                this.perProjectRegs.put(projectKey, reg);
            }
            return reg;
        }
        return this.getDelegateRegistry();
    }

    private MetamodelRegistry getDelegateRegistry() {
        return new MetamodelRegistry(this.createDelegateMetamodelProvider());
    }

    protected IMetamodelProvider createDelegateMetamodelProvider() {
        return MetamodelRegistry.getDefaultMetamodelProvider();
    }
}

