/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.SafeRunner;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;

public abstract class QvtLaunchConfigurationDelegateBase
extends LaunchConfigurationDelegate {
    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        IFile moduleFile = QvtLaunchConfigurationDelegateBase.getModuleFile(configuration);
        if (moduleFile == null || !moduleFile.exists()) {
            return new IProject[0];
        }
        return new IProject[]{moduleFile.getProject()};
    }

    public static QvtModule getQvtModule(ILaunchConfiguration configuration) throws CoreException {
        try {
            String moduleUri = QvtLaunchUtil.getTransformationURI(configuration);
            return TransformationUtil.getQvtModule(EmfUtil.makeUri((String)moduleUri));
        }
        catch (MdaException e) {
            IStatus errorStatus = MiscUtil.makeErrorStatus(e.getMessage());
            throw new CoreException(errorStatus);
        }
    }

    public static IFile getModuleFile(ILaunchConfiguration configuration) throws CoreException {
        String moduleFileName = QvtLaunchUtil.getTransformationURI(configuration);
        URI moduleUri = EmfUtil.makeUri((String)moduleFileName);
        IFile moduleFile = moduleUri != null ? WorkspaceUtils.getWorkspaceFile((URI)moduleUri) : null;
        return moduleFile;
    }

    public static IStatus validate(QvtTransformation transformation, ILaunchConfiguration configuration) throws CoreException {
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        String traceFile = QvtLaunchUtil.getTraceFileURI(configuration);
        boolean useTraceFile = QvtLaunchUtil.shouldGenerateTraceFile(configuration);
        boolean isIncrementalUpdate = QvtLaunchUtil.isIncrementalUpdate(configuration);
        try {
            return QvtValidator.validateTransformation(transformation, targetUris, traceFile, useTraceFile, isIncrementalUpdate, QvtValidator.ValidationType.FULL_VALIDATION);
        }
        catch (MdaException ex) {
            throw new CoreException(StatusUtil.makeErrorStatus((String)ex.getMessage(), (Exception)((Object)ex)));
        }
    }

    @Deprecated
    public static BaseProcess.IRunnable getSafeRunnable(QvtTransformation transformation, BaseProcess.IRunnable r) throws CoreException {
        return SafeRunner.getSafeRunnable((BaseProcess.IRunnable)r);
    }
}

