/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.wizards.PersistedValuesWizard;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.MetamodelHandlerManager;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.QvtRuntimePluginImages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.QvtRuntimeUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.ApplyTransformationData;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.QvtTransformationConfigurationPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.SelectInterpretedTransformationPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.TransformationParametersPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class RunInterpretedTransformationWizard
extends PersistedValuesWizard
implements IRunnableWithProgress {
    private final SelectInterpretedTransformationPage mySelectTransformationPage;
    private final TransformationParametersPage myTransformationParametersPage;
    private final QvtTransformationConfigurationPage myQvtTransformationConfigurationPage;
    private final ApplyTransformationData myTransformationData;
    private final URI myTransfUri;
    private final List<TargetUriData> myTargetUris;
    private QvtTransformation myTransformation;
    private boolean myIsRunInBackground = true;
    private static final String SOURCE_URI = "SOURCE_URI";

    public RunInterpretedTransformationWizard(URI uriTransf, List<TargetUriData> targetUris) {
        super((AbstractUIPlugin)QvtRuntimeUIPlugin.getDefault());
        this.myTransfUri = uriTransf;
        this.myTargetUris = targetUris != null ? targetUris : Collections.emptyList();
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(Messages.LaunchWorkspaceTransformationWizard_Title);
        ImageDescriptor desc = QvtRuntimePluginImages.getInstance().getImageDescriptor("apply_wizard");
        this.setDefaultPageImageDescriptor(desc);
        this.myTransformationData = new ApplyTransformationData();
        URI selectedTransfUri = null;
        if (!this.myTargetUris.isEmpty()) {
            try {
                PersistedValuesWizard.PreferenceSection section = this.loadValues(SOURCE_URI, this.myTargetUris.get(0).getUriString());
                selectedTransfUri = URI.createURI((String)section.get("org.eclipse.m2m.qvt.oml.interpreter.module", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mySelectTransformationPage = new SelectInterpretedTransformationPage("SelectTransfromationPageId", selectedTransfUri, this.myTargetUris);
        this.mySelectTransformationPage.setTitle(Messages.SelectWorkspaceTransformationPage_Title);
        this.myTransformationParametersPage = new TransformationParametersPage("TransformationParametersPageId", this.myTransformationData);
        this.myTransformationParametersPage.setTitle(Messages.TransformationParametersPage_Title);
        this.myQvtTransformationConfigurationPage = new QvtTransformationConfigurationPage("QvtTransformationConfigurationPage", this.myTransformationData);
        this.myQvtTransformationConfigurationPage.setTitle(Messages.ApplyTransformationWizard_ConfigProperties);
        this.myQvtTransformationConfigurationPage.setDescription(Messages.ApplyTransformationWizard_SetupConfigProperty);
    }

    public void setRunInBackground(boolean isRunInBackground) {
        this.myIsRunInBackground = isRunInBackground;
    }

    public void addPages() {
        QvtInterpretedTransformation transformation = null;
        if (this.myTransfUri != null) {
            try {
                transformation = new QvtInterpretedTransformation(TransformationUtil.getQvtModule((URI)this.myTransfUri));
                if (!TransformationUtil.isRunnable((QvtTransformation)transformation)) {
                    transformation = null;
                }
            }
            catch (Exception e) {
                transformation = null;
            }
        }
        if (transformation == null) {
            this.addPage((IWizardPage)this.mySelectTransformationPage);
        } else {
            this.setQvtTransformation((QvtTransformation)transformation);
        }
        this.addPage((IWizardPage)this.myTransformationParametersPage);
        this.addPage((IWizardPage)this.myQvtTransformationConfigurationPage);
        super.addPages();
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).addPageChangingListener(new IPageChangingListener(){

                public void handlePageChanging(PageChangingEvent event) {
                    if (event.getTargetPage() == RunInterpretedTransformationWizard.this.mySelectTransformationPage) {
                        RunInterpretedTransformationWizard.this.myTransformation = null;
                    }
                    if (event.getCurrentPage() == RunInterpretedTransformationWizard.this.mySelectTransformationPage && event.getTargetPage() == RunInterpretedTransformationWizard.this.myTransformationParametersPage) {
                        RunInterpretedTransformationWizard.this.setQvtTransformation(RunInterpretedTransformationWizard.this.mySelectTransformationPage.getTransformation());
                    }
                }
            });
        }
    }

    protected void saveValues() {
        try {
            if (!this.myTargetUris.isEmpty()) {
                PersistedValuesWizard.PreferenceSection section = this.loadValues(SOURCE_URI, this.myTargetUris.get(0).getUriString());
                section.put("org.eclipse.m2m.qvt.oml.interpreter.module", this.myTransformation.getURI().toString());
                section.save();
            }
            if (!this.myTargetUris.isEmpty()) {
                ILaunchConfigurationWorkingCopy launchConfig = this.createLaunchConfiguration((IProgressMonitor)new NullProgressMonitor());
                PersistedValuesWizard.PreferenceSection section = this.loadValues(SOURCE_URI, this.myTargetUris.get(0).getUriString(), "org.eclipse.m2m.qvt.oml.interpreter.module", this.myTransformation.getURI().toString());
                section.put("org.eclipse.m2m.qvt.oml.interpreter.traceFile", QvtLaunchUtil.getTraceFileURI((ILaunchConfiguration)launchConfig));
                section.put("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)launchConfig));
                section.put("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", QvtLaunchUtil.isIncrementalUpdate((ILaunchConfiguration)launchConfig));
                section.put("org.eclipse.m2m.qvt.oml.interpreter.doneAction", this.myTransformationData.isOpenResult());
                section.put("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", this.myTransformationData.getConfiguration());
                List targetUris = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)launchConfig);
                if (targetUris.size() > 1) {
                    section.put("org.eclipse.m2m.qvt.oml.interpreter.elemCount", (long)targetUris.size());
                    int i = 1;
                    while (i < targetUris.size()) {
                        section.put("org.eclipse.m2m.qvt.oml.interpreter.targetType" + i, ((TargetUriData)targetUris.get(i)).getTargetType().name());
                        section.put("org.eclipse.m2m.qvt.oml.interpreter.targetModel" + i, ((TargetUriData)targetUris.get(i)).getUriString());
                        section.put("org.eclipse.m2m.qvt.oml.interpreter.featureName" + i, ((TargetUriData)targetUris.get(i)).getFeature());
                        section.put("org.eclipse.m2m.qvt.oml.interpreter.clearContents" + i, ((TargetUriData)targetUris.get(i)).isClearContents());
                        ++i;
                    }
                }
                section.save();
            }
        }
        catch (Exception e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to save preferences", e);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.myTransformation != null) {
            this.myTransformation.cleanup();
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.myTransformationParametersPage) {
            try {
                if (this.myTransformation.getConfigurationProperties().size() <= 0) {
                    return null;
                }
            }
            catch (MdaException e) {
                return null;
            }
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return super.canFinish() && this.myTransformation != null;
    }

    protected boolean performFinishBody() {
        try {
            if (this.myIsRunInBackground) {
                ILaunchConfigurationWorkingCopy workingCopy = this.createLaunchConfiguration(null);
                DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)"run");
            } else {
                this.getContainer().run(true, true, (IRunnableWithProgress)this);
            }
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.LaunchWorkspaceTransformationWizard_FailedToLaunch, (Object)TransformationUtil.getTransformationFqn((QvtTransformation)this.myTransformation));
            Logger.getLogger().log(Logger.SEVERE, message, e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LaunchWorkspaceTransformationWizard_Error, (String)message);
        }
        return true;
    }

    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        WorkbenchJob updateJob = new WorkbenchJob(Messages.LaunchWorkspaceTransformationWizard_Title){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                ProgressMonitorWrapper wrappedMonitor = new ProgressMonitorWrapper(monitor){

                    public boolean isCanceled() {
                        RunInterpretedTransformationWizard.this.getContainer().getShell().getDisplay().readAndDispatch();
                        return super.isCanceled();
                    }
                };
                wrappedMonitor.beginTask(NLS.bind((String)Messages.LaunchWorkspaceTransformationWizard_runningTransformation, (Object)TransformationUtil.getTransformationFqn((QvtTransformation)RunInterpretedTransformationWizard.this.myTransformation)), -1);
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = RunInterpretedTransformationWizard.this.createLaunchConfiguration((IProgressMonitor)wrappedMonitor);
                    DebugUITools.buildAndLaunch((ILaunchConfiguration)workingCopy, (String)"run", (IProgressMonitor)wrappedMonitor);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.m2m.qvt.oml.runtime.ui", 0, Messages.LaunchWorkspaceTransformationWizard_Error, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
        updateJob.join();
    }

    private ILaunchConfigurationWorkingCopy createLaunchConfiguration(IProgressMonitor monitor) throws Exception {
        ILaunchConfigurationWorkingCopy workingCopy = QvtLaunchUtil.getInMemoryLaunchConfigurationType().newInstance(null, Messages.LaunchWorkspaceTransformationWizard_launchConfigName);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", this.myIsRunInBackground);
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.launchInBackground", String.valueOf(this.myIsRunInBackground));
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", String.valueOf(this.myTransformation.getURI()));
        this.myTransformationParametersPage.applyConfiguration(workingCopy);
        if (this.myTransformationData.isOpenResult()) {
            List targetUris = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)workingCopy);
            LinkedHashMap<String, Runnable> attributes = new LinkedHashMap<String, Runnable>(workingCopy.getAttributes());
            attributes.put("org.eclipse.m2m.qvt.oml.interpreter.doneAction", this.createShowResultAction(targetUris));
            workingCopy.setAttributes(attributes);
        }
        if (monitor != null) {
            LinkedHashMap<String, IProgressMonitor> attributes = new LinkedHashMap<String, IProgressMonitor>(workingCopy.getAttributes());
            attributes.put("org.eclipse.m2m.qvt.oml.interpreter.monitor", monitor);
            workingCopy.setAttributes(attributes);
        }
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", this.myTransformationData.getConfiguration());
        return workingCopy;
    }

    private Runnable createShowResultAction(final List<TargetUriData> targetUris) {
        if (this.myTransformation == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = QvtRuntimeUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                Iterator itrTargetData = targetUris.iterator();
                try {
                    for (QvtTransformation.TransformationParameter transfParam : RunInterpretedTransformationWizard.this.myTransformation.getParameters()) {
                        if (itrTargetData.hasNext()) {
                            TargetUriData targetData = (TargetUriData)itrTargetData.next();
                            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) continue;
                            IMetamodelHandler handler = MetamodelHandlerManager.getInstance().getHandler(String.valueOf(targetData.getUri()));
                            ModelContent result = EmfUtil.loadModel((URI)targetData.getUri());
                            if (result == null || result.getContent().isEmpty()) {
                                return;
                            }
                            try {
                                handler.getSaver().select((EObject)result.getContent().get(0), page);
                            }
                            catch (Exception e) {
                                Logger.getLogger().log(Logger.SEVERE, Messages.LaunchWorkspaceTransformationWizard_ShowResultError, e);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (MdaException e) {
                    Logger.getLogger().log(Logger.SEVERE, Messages.LaunchWorkspaceTransformationWizard_ShowResultError, e);
                }
            }
        };
    }

    private void setQvtTransformation(QvtTransformation transformation) {
        if (!this.myTargetUris.isEmpty()) {
            try {
                PersistedValuesWizard.PreferenceSection section = this.loadValues(SOURCE_URI, this.myTargetUris.get(0).getUriString(), "org.eclipse.m2m.qvt.oml.interpreter.module", transformation.getURI().toString());
                Map configProps = section.getStringMap("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties");
                this.myTransformationData.getConfiguration().clear();
                this.myTransformationData.getConfiguration().putAll(configProps);
                this.myTransformationData.setUseTraceFile(section.getBoolean("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false));
                this.myTransformationData.setIncrementalUpdate(section.getBoolean("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", false));
                this.myTransformationData.setTraceFile(section.get("org.eclipse.m2m.qvt.oml.interpreter.traceFile", ""));
                this.myTransformationData.setOpenResult(section.getBoolean("org.eclipse.m2m.qvt.oml.interpreter.doneAction", false));
                int targetDataCount = Integer.valueOf(section.get("org.eclipse.m2m.qvt.oml.interpreter.elemCount", new Integer(0).toString()));
                int i = 1;
                while (i < targetDataCount) {
                    if (this.myTargetUris.size() <= i) {
                        this.myTargetUris.add(new TargetUriData(TargetUriData.TargetType.valueOf((String)section.get("org.eclipse.m2m.qvt.oml.interpreter.targetType" + i)), section.get("org.eclipse.m2m.qvt.oml.interpreter.targetModel" + i), section.get("org.eclipse.m2m.qvt.oml.interpreter.featureName" + i), Boolean.valueOf(section.get("org.eclipse.m2m.qvt.oml.interpreter.clearContents" + i)).booleanValue()));
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myTransformation = transformation;
        this.myTransformationParametersPage.setTransformation(this.myTransformation, this.myTargetUris);
        this.myTransformationData.setTransformation(this.myTransformation);
    }
}

