/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.CallTreeBuilder;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ScheduleAnalysis {
    protected final @NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ConnectionManager connectionManager;
    protected final @NonNull RootPartitionAnalysis rootPartitionAnalysis;
    protected final @NonNull List<@NonNull PartitionAnalysis> allPartitionAnalyses;
    private final @NonNull LoadingPartition loadingPartition;
    private final @NonNull Map<@NonNull Partition, @NonNull List<@NonNull Connection>> partition2incomingConnections = new HashMap<Partition, List<Connection>>();
    private final @NonNull Map<@NonNull Partition, @NonNull List<@NonNull Connection>> partition2loopingConnections = new HashMap<Partition, List<Connection>>();
    private final @NonNull Map<@NonNull Partition, @NonNull List<@NonNull Connection>> partition2outgoingConnections = new HashMap<Partition, List<Connection>>();
    private final @NonNull Map<@NonNull Connection, @NonNull List<@NonNull Partition>> connection2sourcePartitions = new HashMap<Connection, List<Partition>>();
    private final @NonNull Map<@NonNull Connection, @NonNull List<@NonNull Partition>> connection2targetPartitions = new HashMap<Connection, List<Partition>>();

    public ScheduleAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull ConnectionManager connectionManager, @NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        this.partitionedTransformationAnalysis = partitionedTransformationAnalysis;
        this.scheduleManager = connectionManager.getScheduleManager();
        this.rootPartitionAnalysis = rootPartitionAnalysis;
        this.connectionManager = connectionManager;
        this.allPartitionAnalyses = CompilerUtil.gatherPartitionAnalyses(rootPartitionAnalysis, new ArrayList<PartitionAnalysis>());
        Collections.sort(this.allPartitionAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        LoadingPartition loadingPartition = null;
        for (PartitionAnalysis partitionAnalysis : this.allPartitionAnalyses) {
            this.analyzeConnections(partitionAnalysis);
            Partition partition = partitionAnalysis.getPartition();
            if (!(partition instanceof LoadingPartition)) continue;
            assert (loadingPartition == null);
            loadingPartition = (LoadingPartition)partition;
        }
        assert (loadingPartition != null);
        this.loadingPartition = loadingPartition;
        for (PartitionAnalysis partitionAnalysis : this.allPartitionAnalyses) {
            this.analyzeSourcesAndTargets(partitionAnalysis.getPartition());
        }
    }

    private void analyzeConnections(@NonNull PartitionAnalysis partitionAnalysis) {
        Partition partition = partitionAnalysis.getPartition();
        ArrayList<@NonNull Connection> incomingConnections = new ArrayList<Connection>();
        ArrayList<@NonNull Connection> loopingConnections = new ArrayList<Connection>();
        ArrayList<@NonNull Connection> outgoingConnections = new ArrayList<Connection>();
        for (Connection connection : this.connectionManager.getIncomingConnections(partitionAnalysis)) {
            for (Partition sourcePartition : connection.getSourcePartitions()) {
                if (partition == sourcePartition) {
                    if (loopingConnections.contains(connection)) continue;
                    loopingConnections.add(connection);
                    continue;
                }
                if (incomingConnections.contains(connection)) continue;
                incomingConnections.add(connection);
            }
        }
        for (Connection connection : this.connectionManager.getNextConnections(partition)) {
            for (Partition targetPartition : connection.getTargetPartitions()) {
                if (partition == targetPartition) {
                    assert (loopingConnections.contains(connection));
                    loopingConnections.add(connection);
                    continue;
                }
                if (outgoingConnections.contains(connection)) continue;
                outgoingConnections.add(connection);
            }
        }
        if (outgoingConnections.size() > 1) {
            Collections.sort(outgoingConnections, NameUtil.NAMEABLE_COMPARATOR);
        }
        this.partition2incomingConnections.put(partition, incomingConnections);
        this.partition2loopingConnections.put(partition, loopingConnections);
        this.partition2outgoingConnections.put(partition, outgoingConnections);
    }

    private void analyzeSourcesAndTargets(@NonNull Partition partition) {
        for (Connection connection : this.getIncomingConnections(partition)) {
            List<Partition> targetPartitions;
            List<@NonNull Partition> sourcePartitions = this.connection2sourcePartitions.get(connection);
            if (sourcePartitions == null) {
                sourcePartitions = new ArrayList<Partition>();
                for (Partition sourcePartition : connection.getSourcePartitions()) {
                    if (sourcePartitions.contains(sourcePartition)) continue;
                    sourcePartitions.add(sourcePartition);
                }
                this.connection2sourcePartitions.put(connection, sourcePartitions);
            }
            if ((targetPartitions = this.connection2targetPartitions.get(connection)) != null) continue;
            targetPartitions = new ArrayList<Partition>();
            for (Partition targetPartition : connection.getTargetPartitions()) {
                if (targetPartitions.contains(targetPartition)) continue;
                targetPartitions.add(targetPartition);
            }
            this.connection2targetPartitions.put(connection, targetPartitions);
        }
    }

    protected void buildCallTree(@NonNull Iterable<@NonNull Concurrency> partitionSchedule) {
        CallTreeBuilder callTreeBuilder = new CallTreeBuilder(this, (RootPartition)this.rootPartitionAnalysis.getPartition(), this.loadingPartition);
        callTreeBuilder.buildTree(partitionSchedule);
    }

    private void checkPassNumbers(@NonNull Connection connection) {
        int firstPass = connection.getFirstPass();
        int lastPass = connection.getLastPass();
        for (Partition sourcePartition : connection.getSourcePartitions()) {
            assert (sourcePartition.getLastPass() <= lastPass);
        }
        for (Partition targetPartition : connection.getTargetPartitions()) {
            assert (lastPass <= targetPartition.getLastPass());
        }
    }

    public @NonNull ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected @NonNull Iterable<? extends @NonNull Connection> getConnections() {
        return this.connection2targetPartitions.keySet();
    }

    protected @NonNull Iterable<@NonNull Connection> getIncomingConnections(@NonNull Partition partition) {
        List<@NonNull Connection> incomingConnections = this.partition2incomingConnections.get(partition);
        assert (incomingConnections != null);
        return incomingConnections;
    }

    public @NonNull Partition getLoadingPartition() {
        return this.loadingPartition;
    }

    protected @NonNull Iterable<@NonNull Connection> getLoopingConnections(@NonNull Partition partition) {
        List<@NonNull Connection> loopingConnections = this.partition2loopingConnections.get(partition);
        assert (loopingConnections != null);
        return loopingConnections;
    }

    protected @NonNull Iterable<@NonNull Connection> getOutgoingConnections(@NonNull Partition partition) {
        List<@NonNull Connection> outgoingConnections = this.partition2outgoingConnections.get(partition);
        assert (outgoingConnections != null);
        return outgoingConnections;
    }

    public @NonNull RootPartition getRootPartition() {
        return (RootPartition)this.rootPartitionAnalysis.getPartition();
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    protected @NonNull Iterable<@NonNull Partition> getSourcePartitions(@NonNull Connection connection) {
        List<@NonNull Partition> sourceRegions = this.connection2sourcePartitions.get(connection);
        assert (sourceRegions != null);
        return sourceRegions;
    }

    protected @NonNull Iterable<@NonNull Partition> getTargetPartitions(@NonNull Connection connection) {
        List<@NonNull Partition> targetPartitions = this.connection2targetPartitions.get(connection);
        assert (targetPartitions != null);
        return targetPartitions;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void propagatePassNumbers(@NonNull Partition sourcePartition, @NonNull Set<@NonNull Connection> changedConnections) {
        @NonNull Iterable sourcePasses = QVTscheduleUtil.getPasses((Partition)sourcePartition);
        for (Connection outgoingConnection : this.getOutgoingConnections(sourcePartition)) {
            boolean isChanged = false;
            Iterator iterator = sourcePasses.iterator();
            while (iterator.hasNext()) {
                int sourcePass = (Integer)iterator.next();
                if (!outgoingConnection.addPass(sourcePass)) continue;
                isChanged = true;
            }
            if (!isChanged) continue;
            changedConnections.add(outgoingConnection);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void propagatePassNumbers(@NonNull Connection incomingConnection, @NonNull Set<@NonNull Partition> changedPartitions) {
        @NonNull List connectionPasses = incomingConnection.getPasses();
        for (Partition targetPartition : this.getTargetPartitions(incomingConnection)) {
            boolean isChanged = false;
            int lastPass = targetPartition.getLastPass();
            Iterator iterator = connectionPasses.iterator();
            while (iterator.hasNext()) {
                int connectionPass = (Integer)iterator.next();
                if (connectionPass <= lastPass || !targetPartition.addPass(connectionPass)) continue;
                isChanged = true;
            }
            if (!isChanged) continue;
            changedPartitions.add(targetPartition);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void schedule(@NonNull RootPartition rootPartition, @NonNull List<@NonNull Concurrency> partitionSchedule) {
        int passNumber = 0;
        int cycleDepth = 0;
        int cycleStart = 0;
        HashSet<@NonNull Partition> changedPartitions = new HashSet<Partition>();
        for (Concurrency concurrency : partitionSchedule) {
            concurrency.setPass(passNumber);
            if (concurrency.isCycleStart() && ++cycleDepth == 1) {
                cycleStart = passNumber;
            }
            for (PartitionAnalysis partitionAnalysis : concurrency) {
                Partition partition = partitionAnalysis.getPartition();
                changedPartitions.add(partition);
                Iterable<@NonNull Connection> loopingConnections = this.getLoopingConnections(partition);
                assert (loopingConnections != null);
                for (Connection loopingConnection : loopingConnections) {
                    loopingConnection.addPass(passNumber);
                }
            }
            if (concurrency.isCycleEnd() && --cycleDepth == 0) {
                int cyclePass = cycleStart;
                while (cyclePass < passNumber) {
                    partitionSchedule.get(cyclePass).addPass(passNumber);
                    ++cyclePass;
                }
            }
            ++passNumber;
        }
        assert (cycleDepth == 0);
        this.scheduleManager.writeDebugGraphs("6-pass", false, true, false);
        for (Connection connection : this.getConnections()) {
            for (Partition sourcePartition : this.getSourcePartitions(connection)) {
                Iterator iterator = sourcePartition.getPasses().iterator();
                while (iterator.hasNext()) {
                    int sourcePass = (Integer)iterator.next();
                    connection.addPass(sourcePass);
                }
            }
        }
        @NonNull HashSet hashSet = Sets.newHashSet(this.getConnections());
        while (!changedPartitions.isEmpty()) {
            for (Partition partition : changedPartitions) {
                this.propagatePassNumbers(partition, hashSet);
            }
            changedPartitions.clear();
            for (Connection connection : hashSet) {
                this.propagatePassNumbers(connection, changedPartitions);
            }
            hashSet.clear();
        }
        this.scheduleManager.writeDebugGraphs("7-passes", false, true, false);
        for (Connection connection : this.getConnections()) {
            this.checkPassNumbers(connection);
        }
        this.buildCallTree(partitionSchedule);
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull PartitionAnalysis> list = new ArrayList<PartitionAnalysis>(this.allPartitionAnalyses);
        Collections.sort(list, NameUtil.NAMEABLE_COMPARATOR);
        for (PartitionAnalysis entry : list) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(String.valueOf(entry.getPartition().getPassRangeText()) + " : " + entry.getName());
        }
        return s.toString();
    }
}

