/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.cst.ASTOutlinePage;
import org.eclipse.qvt.declarative.editor.ui.cst.CSTOutlinePage;
import org.eclipse.qvt.declarative.editor.ui.cst.ICSTOutlinePage;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonPropertySheetPage;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditingDomainFactory;
import org.eclipse.qvt.declarative.editor.ui.text.ITextEditorWithUndoContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTextEditor
extends UniversalEditor
implements ITextEditorWithUndoContext {
    protected TransactionalEditingDomainImpl editingDomain;
    protected IPropertySheetPage propertySheetPage = null;
    protected IContentOutlinePage astOutlinePage = null;
    protected ICSTOutlinePage cstOutlinePage = null;
    protected IShowInTargetList showInTargetList = null;

    public CommonTextEditor() {
        this.initializeEditingDomain();
    }

    protected IContentOutlinePage createASTOutlinePage() {
        return new ASTOutlinePage(this);
    }

    protected ICSTOutlinePage createCSTOutlinePage() {
        return new CSTOutlinePage(this);
    }

    protected IPropertySheetPage createPropertySheetPage() {
        CommonPropertySheetPage page = new CommonPropertySheetPage(this);
        page.setPropertySourceProvider((IPropertySourceProvider)new TransactionalAdapterFactoryContentProvider(this.getTransactionalEditingDomain(), this.getAdapterFactory()));
        return page;
    }

    protected IShowInTargetList createShowInTargetList() {
        return new IShowInTargetList(){

            public String[] getShowInTargetIds() {
                return new String[]{"org.eclipse.ui.views.PropertySheet", "org.eclipse.ui.views.ContentOutline", "org.eclipse.qvt.declarative.editor.ui.cst"};
            }
        };
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentUndoManager documentUndoManager;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document != null && (documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document)) != null) {
            documentUndoManager.commit();
        }
        super.doSave(progressMonitor);
    }

    protected Object getASTNode(ISelection selection, ICommonParseResult parseResult) {
        Resource ast = parseResult.getAST();
        Object node = this.getCSTNode((TextSelection)selection, parseResult);
        if (node instanceof CSTNode) {
            Object cstNode = node;
            while (cstNode instanceof CSTNode) {
                node = ((CSTNode)cstNode).getAst();
                if (node != null && node instanceof EObject && ((EObject)node).eResource() == ast) break;
                cstNode = ((EObject)cstNode).eContainer();
            }
        }
        return node;
    }

    protected List<Object> getASTNodes(ISelection selection, ICommonParseResult parseResult) {
        ArrayList<Object> unwrappedSelections = new ArrayList<Object>(((IStructuredSelection)selection).size());
        Iterator i = ((IStructuredSelection)selection).iterator();
        while (i.hasNext()) {
            Object node = parseResult.getASTNode(i.next());
            if (node == null) continue;
            unwrappedSelections.add(node);
        }
        return unwrappedSelections;
    }

    public ISelection getASTSelection(ISelection selection, ICommonParseResult parseResult) {
        if (selection instanceof TextSelection) {
            Object node = this.getASTNode(selection, parseResult);
            selection = node != null ? new StructuredSelection(node) : StructuredSelection.EMPTY;
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            List<Object> unwrappedSelections = this.getASTNodes(selection, parseResult);
            selection = new StructuredSelection(unwrappedSelections);
        }
        return selection;
    }

    protected List<Object> getASTorCSTNodes(ISelection selection, ICommonParseResult parseResult) {
        ArrayList<Object> unwrappedSelections = new ArrayList<Object>(((IStructuredSelection)selection).size());
        Iterator i = ((IStructuredSelection)selection).iterator();
        while (i.hasNext()) {
            Object node = parseResult.getASTorCSTNode(i.next());
            if (node == null) continue;
            unwrappedSelections.add(node);
        }
        return unwrappedSelections;
    }

    protected ISelection getASTorCSTSelection(ISelection selection, ICommonParseResult parseResult) {
        if (selection instanceof TextSelection) {
            Object node = this.getASTNode(selection, parseResult);
            selection = node != null ? new StructuredSelection(node) : StructuredSelection.EMPTY;
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            List<Object> unwrappedSelections = this.getASTorCSTNodes(selection, parseResult);
            selection = new StructuredSelection(unwrappedSelections);
        }
        return selection;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
    }

    public Annotation[] getAnnotations() {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        Iterator i = annotationModel.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation annotation = (Annotation)i.next();
            if (!"org.eclipse.imp.editor.parseAnnotation".equals(annotation.getType())) continue;
            annotationList.add(annotation);
        }
        return annotationList.toArray(new Annotation[annotationList.size()]);
    }

    protected Object getCSTNode(TextSelection selection, ICommonParseResult parseResult) {
        int length = selection.getLength();
        int offset = selection.getOffset();
        ISourcePositionLocator nodeLocator = parseResult.getSourcePositionLocator();
        return nodeLocator.findNode((Object)parseResult.getCST(), offset, offset + length);
    }

    protected List<CSTNode> getCSTNodes(ISelection selection, ICommonParseResult parseResult) {
        ArrayList<CSTNode> unwrappedSelections = new ArrayList<CSTNode>(((IStructuredSelection)selection).size());
        Iterator i = ((IStructuredSelection)selection).iterator();
        while (i.hasNext()) {
            CSTNode node = parseResult.getCSTNode(i.next());
            if (node == null) continue;
            unwrappedSelections.add(node);
        }
        return unwrappedSelections;
    }

    public ISelection getCSTSelection(ISelection selection, ICommonParseResult parseResult) {
        if (selection instanceof TextSelection) {
            Object node = this.getCSTNode((TextSelection)selection, parseResult);
            selection = node != null ? new StructuredSelection(node) : StructuredSelection.EMPTY;
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            List<CSTNode> unwrappedSelections = this.getCSTNodes(selection, parseResult);
            selection = new StructuredSelection(unwrappedSelections);
        }
        return selection;
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return this.getEditorSite().getActionBarContributor();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.createPropertySheetPage();
            }
            return this.propertySheetPage;
        }
        if (key.equals(IContentOutlinePage.class)) {
            if (this.astOutlinePage == null) {
                this.astOutlinePage = this.createASTOutlinePage();
            }
            return this.astOutlinePage;
        }
        if (key.equals(ICSTOutlinePage.class)) {
            if (this.cstOutlinePage == null) {
                this.cstOutlinePage = this.createCSTOutlinePage();
            }
            return this.cstOutlinePage;
        }
        if (key.equals(IShowInTargetList.class)) {
            if (this.showInTargetList == null) {
                this.showInTargetList = this.createShowInTargetList();
            }
            return this.showInTargetList;
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        return this.editingDomain.getAdapterFactory();
    }

    public AdapterFactoryEditingDomain getAdapterFactoryEditingDomain() {
        return this.editingDomain;
    }

    public ICreationFactory getCreationFactory() {
        return this.getParseController().getCreationFactory();
    }

    public Display getDisplay() {
        return this.getShell().getDisplay();
    }

    protected Collection<AdapterFactory> getDomainAdapterFactories() {
        ArrayList<AdapterFactory> domainAdapterFactories = new ArrayList<AdapterFactory>();
        domainAdapterFactories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        domainAdapterFactories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return domainAdapterFactories;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public String getEditingDomainID() {
        return "org.eclipse.qvt.declarative.editingDomainID";
    }

    public LanguageServiceManager getLanguageServiceManager() {
        return this.fLanguageServiceManager;
    }

    public IOperationHistory getOperationHistory() {
        return this.getWorkspaceCommandStack().getOperationHistory();
    }

    public ICommonParseController getParseController() {
        return (ICommonParseController)super.getParseController();
    }

    public ISelectionChangedListener getSelectionListener() {
        return this.getSelectionChangedListener();
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    @Override
    public IUndoContext getUndoContext() {
        IUndoManager undoManager;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)sourceViewer).getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public IWorkspaceCommandStack getWorkspaceCommandStack() {
        return (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
    }

    protected void initializeEditingDomain() {
        this.editingDomain = (TransactionalEditingDomainImpl)new PagedEditingDomainFactory().createEditingDomain();
        this.editingDomain.setID(this.getEditingDomainID());
        ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        for (AdapterFactory domainAdapterFactory : this.getDomainAdapterFactories()) {
            adapterFactory.addAdapterFactory(domainAdapterFactory);
        }
    }

    public boolean refresh() {
        ICommonParseController parseController = this.getParseController();
        ICommonParseResult parseResult = parseController.getCurrentResult();
        int i = 0;
        while (i < 50) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (parseController.getCurrentResult() != parseResult) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void refreshMarkerAnnotations(String problemMarkerType) {
        IAnnotationModel annotationModel;
        IDocumentProvider documentProvider;
        if (QVTEditorPlugin.ANNOTATION_UPDATE.isActive()) {
            QVTEditorPlugin.ANNOTATION_UPDATE.println("Updating '" + problemMarkerType + "' for '" + this.getEditorInput().getName() + "'");
        }
        if ((documentProvider = this.getDocumentProvider()) != null && (annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput())) != null) {
            try {
                Iterator annotationIterator;
                Iterator annIter = annotationIterator = annotationModel.getAnnotationIterator();
                while (annIter.hasNext()) {
                    Annotation ann = (Annotation)annIter.next();
                    if (!(ann instanceof MarkerAnnotation)) continue;
                    if (QVTEditorPlugin.ANNOTATION_DELETE.isActive()) {
                        IMarker marker = ((MarkerAnnotation)ann).getMarker();
                        String lineNumber = String.valueOf(marker.getAttribute("lineNumber"));
                        String charStart = String.valueOf(marker.getAttribute("charStart"));
                        String charEnd = String.valueOf(marker.getAttribute("charEnd"));
                        String message = String.valueOf(marker.getAttribute("message"));
                        QVTEditorPlugin.ANNOTATION_DELETE.println("Lose '" + lineNumber + ":" + charStart + "-" + charEnd + ": " + message);
                    }
                    annotationModel.removeAnnotation(ann);
                }
            }
            catch (CoreException coreException) {}
        }
        super.refreshMarkerAnnotations(problemMarkerType);
    }
}

