/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.parser;

import java.util.Iterator;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.Monitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.parser.ILexer;
import org.eclipse.imp.parser.IParser;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.LPGSourcePositionLocator;
import org.eclipse.imp.parser.MessageHandlerAdapter;
import org.eclipse.imp.parser.ParseControllerBase;
import org.eclipse.imp.parser.SimpleAnnotationTypeInfo;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleLPGParseController
extends ParseControllerBase {
    private char[][] fKeywords;
    private boolean[] fIsKeyword;
    protected IParser fParser;
    protected ILexer fLexer;
    private ISourcePositionLocator fSourcePositionLocator;
    private final SimpleAnnotationTypeInfo fSimpleAnnotationTypeInfo = new SimpleAnnotationTypeInfo();

    public SimpleLPGParseController(String languageID) {
        super(languageID);
    }

    public IParser getParser() {
        return this.fParser;
    }

    public ILexer getLexer() {
        return this.fLexer;
    }

    @Override
    public ISourcePositionLocator getSourcePositionLocator() {
        if (this.fSourcePositionLocator == null) {
            this.fSourcePositionLocator = new LPGSourcePositionLocator(this);
        }
        return this.fSourcePositionLocator;
    }

    @Override
    public Object parse(String contents, IProgressMonitor monitor) {
        PMMonitor my_monitor = new PMMonitor(monitor);
        char[] contentsArray = contents.toCharArray();
        this.fLexer.reset(contentsArray, this.fFilePath != null ? this.fFilePath.toPortableString() : null);
        this.fParser.reset(this.fLexer.getILexStream());
        this.fParser.getIPrsStream().setMessageHandler((IMessageHandler)new MessageHandlerAdapter(this.handler));
        this.fLexer.lexer(my_monitor, this.fParser.getIPrsStream());
        if (my_monitor.isCancelled()) {
            return this.fCurrentAst;
        }
        this.fCurrentAst = this.fParser.parser(my_monitor, 0);
        this.cacheKeywordsOnce();
        return this.fCurrentAst;
    }

    @Override
    public Iterator<IToken> getTokenIterator(IRegion region) {
        int regionOffset = region.getOffset();
        int regionLength = region.getLength();
        int regionEnd = regionOffset + regionLength - 1;
        return new Iterator<IToken>(regionOffset, regionEnd){
            final IPrsStream stream;
            final int firstTokIdx;
            final int lastTokIdx;
            int curTokIdx;
            IToken[][] precedingAdjuncts;
            int[] nextPrecedingAdjunct;
            IToken[] followingAdjuncts;
            int nextFollowingAdjunct;
            private boolean finalTokenReturned;
            private boolean finalAdjunctsReturned;
            {
                this.stream = SimpleLPGParseController.this.getParser().getIPrsStream();
                this.firstTokIdx = this.getTokenIndexAtCharacter(n);
                int endIdx = this.getTokenIndexAtCharacter(n2);
                char[] streamChars = this.stream.getInputChars();
                int streamLen = streamChars.length;
                try {
                    if (n2 >= 1 && n2 < streamLen && streamChars[n2] == '\uffff') {
                        --endIdx;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ErrorHandler.logError("SimpleLPGParseController.getTokenIterator(IRegion):  error initializing lastTokIdx", e);
                }
                this.lastTokIdx = endIdx;
                this.curTokIdx = Math.max(1, this.firstTokIdx);
                this.precedingAdjuncts = new IToken[this.lastTokIdx + 1][];
                this.stream.setStreamLength();
                int i = 0;
                while (i < this.precedingAdjuncts.length) {
                    this.precedingAdjuncts[i] = this.stream.getPrecedingAdjuncts(i);
                    ++i;
                }
                this.nextPrecedingAdjunct = new int[this.lastTokIdx + 1];
                i = 0;
                while (i < this.nextPrecedingAdjunct.length) {
                    this.nextPrecedingAdjunct[i] = this.precedingAdjuncts[i].length == 0 ? -1 : 0;
                    ++i;
                }
                this.followingAdjuncts = this.lastTokIdx <= 0 ? new IToken[0] : this.stream.getFollowingAdjuncts(this.lastTokIdx);
                this.nextFollowingAdjunct = this.followingAdjuncts.length == 0 ? -1 : 0;
                this.finalTokenReturned = n2 < 1 || this.lastTokIdx <= 0;
                this.finalAdjunctsReturned = this.followingAdjuncts.length <= 0;
            }

            private int getTokenIndexAtCharacter(int offset) {
                int result = this.stream.getTokenIndexAtCharacter(offset);
                if (result < 0) {
                    result = -result + 1;
                }
                if (result >= this.stream.getTokens().size()) {
                    result = this.stream.getTokens().size() - 1;
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return !this.finalTokenReturned || !this.finalAdjunctsReturned;
            }

            @Override
            public IToken next() {
                int next = -1;
                if (this.curTokIdx <= this.lastTokIdx) {
                    next = this.nextPrecedingAdjunct[this.curTokIdx];
                    if (next >= 0 && next < this.precedingAdjuncts[this.curTokIdx].length) {
                        int n = this.curTokIdx;
                        int n2 = this.nextPrecedingAdjunct[n];
                        this.nextPrecedingAdjunct[n] = n2 + 1;
                        return this.precedingAdjuncts[this.curTokIdx][n2];
                    }
                    this.finalTokenReturned = this.curTokIdx >= this.lastTokIdx;
                    return this.stream.getIToken(this.curTokIdx++);
                }
                if (this.nextFollowingAdjunct >= 0 && this.nextFollowingAdjunct < this.followingAdjuncts.length) {
                    this.finalAdjunctsReturned = this.nextFollowingAdjunct + 1 >= this.followingAdjuncts.length;
                    return this.followingAdjuncts[this.nextFollowingAdjunct++];
                }
                return null;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Unimplemented");
            }
        };
    }

    @Override
    public IAnnotationTypeInfo getAnnotationTypeInfo() {
        return this.fSimpleAnnotationTypeInfo;
    }

    public boolean isKeyword(int kind) {
        return kind < this.getParser().numTokenKinds() && this.fIsKeyword[kind];
    }

    protected void cacheKeywordsOnce() {
        if (this.fKeywords == null) {
            try {
                IParser parser = this.getParser();
                String[] tokenKindNames = parser.orderedTerminalSymbols();
                this.fIsKeyword = new boolean[tokenKindNames.length];
                this.fKeywords = new char[tokenKindNames.length][];
                int[] keywordKinds = this.getLexer().getKeywordKinds();
                int i = 1;
                while (i < keywordKinds.length) {
                    int index = parser.getIPrsStream().mapKind(keywordKinds[i]);
                    this.fIsKeyword[index] = true;
                    this.fKeywords[index] = parser.orderedTerminalSymbols()[index].toCharArray();
                    ++i;
                }
            }
            catch (NullPointerException nullPointerException) {
                RuntimePlugin.getInstance().writeErrorMsg("SimpleLPGParseController.cacheKeywordsOnce(): NullPointerException; trapped and discarded");
            }
        }
    }

    protected class PMMonitor
    implements Monitor {
        private IProgressMonitor monitor;
        private boolean wasCancelled = false;

        public PMMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean isCancelled() {
            if (!this.wasCancelled) {
                this.wasCancelled = this.monitor.isCanceled();
            }
            return this.wasCancelled;
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }
    }
}

