/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.LanguageValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Language {
    public static final String LANGUAGE_ID_ATTR = "language";
    private String fLanguage;
    public static final String DERIVED_FROM_ATTR = "derivedFrom";
    private String fDerivedFrom;
    public static final String EXTENSIONS_ATTR = "extensions";
    private Collection<String> fFilenameExtensions;
    public static final String VALIDATOR_ATTR = "validator";
    private LanguageValidator fValidator;
    public static final String DESCRIPTION_ATTR = "description";
    private String fDescription;
    public static final String NATURE_ID_ATTR = "natureID";
    private String fNatureId;
    public static final String SYNONYMS_ATTR = "synonyms";
    private Collection<String> fSynonyms;
    public static final String ICON_ATTR = "icon";
    private String fIconPath;
    public static final String URL_ATTR = "url";
    private String fURL;
    private String fBundleID;

    Language(IConfigurationElement element) {
        try {
            this.fLanguage = element.getAttribute(LANGUAGE_ID_ATTR);
            this.fNatureId = element.getAttribute(NATURE_ID_ATTR);
            this.fDescription = element.getAttribute(DESCRIPTION_ATTR);
            this.fDerivedFrom = element.getAttribute(DERIVED_FROM_ATTR);
            this.fIconPath = element.getAttribute(ICON_ATTR);
            this.fBundleID = element.getNamespaceIdentifier();
            this.fURL = element.getAttribute(URL_ATTR);
            this.fFilenameExtensions = this.parseList(element.getAttribute(EXTENSIONS_ATTR));
            this.fSynonyms = this.parseList(element.getAttribute(SYNONYMS_ATTR));
            this.fValidator = (LanguageValidator)element.createExecutableExtension(VALIDATOR_ATTR);
        }
        catch (CoreException coreException) {
            this.fValidator = null;
        }
    }

    public Language(String language, String natureId, String description, String derivedFrom, String iconPath, String url, String bundleID, String fileNameExtensions, String synonyms, LanguageValidator validator) {
        this.fLanguage = language;
        this.fNatureId = natureId;
        this.fDescription = description;
        this.fDerivedFrom = derivedFrom;
        this.fIconPath = iconPath;
        this.fBundleID = bundleID;
        this.fURL = url;
        this.fFilenameExtensions = this.parseList(fileNameExtensions);
        this.fSynonyms = this.parseList(synonyms);
        this.fValidator = validator;
    }

    public String getName() {
        return this.fLanguage;
    }

    public String getNatureID() {
        return this.fNatureId;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getDerivedFrom() {
        return this.fDerivedFrom;
    }

    public String getIconPath() {
        return this.fIconPath;
    }

    public String getBundleID() {
        return this.fBundleID;
    }

    public String getUrl() {
        return this.fURL;
    }

    public boolean hasExtension(String extension) {
        return this.fFilenameExtensions.contains(extension);
    }

    public Collection<String> getFilenameExtensions() {
        return this.fFilenameExtensions;
    }

    @Deprecated
    public Collection<String> getSynonyms() {
        return this.fSynonyms;
    }

    public Language getBaseLanguage() {
        String baseLangName = this.getDerivedFrom();
        if (baseLangName != null) {
            return LanguageRegistry.findLanguage(baseLangName);
        }
        return null;
    }

    public LanguageValidator getValidator() {
        return this.fValidator;
    }

    protected Collection<String> parseList(String list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, ",");
            int n = 0;
            while (st.hasMoreElements()) {
                String exten = st.nextToken().trim();
                if (exten.startsWith(".")) {
                    ErrorHandler.logMessage("Ignoring leading '.' in file-name extension " + exten + " for language '" + this.getName() + "'.", null);
                    exten = exten.substring(1);
                }
                result.add(exten);
                ++n;
            }
        }
        return result;
    }

    public String toString() {
        return "Language[name=" + this.getName() + ",description=" + this.getDescription() + ",filename extensions=" + this.getFilenameExtensions() + "]";
    }
}

