/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NonPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class NonPartitionFactory
extends AbstractSimplePartitionFactory {
    public NonPartitionFactory(@NonNull MappingPartitioner mappingPartitioner) {
        super(mappingPartitioner);
    }

    @Override
    public @NonNull NonPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        MappingRegion region = this.mappingPartitioner.getRegion();
        NonPartition nonPartition = this.createNonPartition(QVTscheduleUtil.getName((Nameable)region));
        NonPartitionAnalysis nonPartitionAnalysis = new NonPartitionAnalysis(partitionedTransformationAnalysis, nonPartition, reachabilityForest);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)nonPartition, null);
        }
        return nonPartitionAnalysis;
    }

    @Override
    protected @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges() {
        HashSet<@NonNull NavigableEdge> oldEdges = new HashSet<NavigableEdge>();
        MappingRegion region = this.mappingPartitioner.getRegion();
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)region)) {
            assert (!edge.isCast());
            Role edgeRole = edge.getEdgeRole();
            assert (edgeRole != null);
            if (!edgeRole.isOld() || !edge.isNavigation()) continue;
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Role sourceNodeRole = sourceNode.getNodeRole();
            assert (sourceNodeRole != null);
            if (!sourceNodeRole.isOld()) continue;
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            Role targetNodeRole = targetNode.getNodeRole();
            assert (targetNodeRole != null);
            if (!targetNodeRole.isOld()) continue;
            oldEdges.add((NavigableEdge)edge);
        }
        return oldEdges;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        MappingRegion region = this.mappingPartitioner.getRegion();
        @NonNull ArrayList zeroCostNodes = Lists.newArrayList((Iterable)QVTscheduleUtil.getHeadNodes((Region)region));
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)region)) {
            if (!node.isOperation() || !node.isConstant()) continue;
            boolean hasNoComputationInputs = true;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isComputation()) continue;
                hasNoComputationInputs = false;
                break;
            }
            if (!hasNoComputationInputs) continue;
            zeroCostNodes.add(node);
        }
        return zeroCostNodes;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        throw new UnsupportedOperationException();
    }
}

