/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;

public class AtlModelAnalyser {
    public static final int NULL_CONTEXT = 0;
    public static final int MODULE_CONTEXT = 1;
    public static final int HELPER_CONTEXT = 2;
    public static final int RULE_CONTEXT = 3;
    public static final int FROM_CONTEXT = 4;
    public static final int TO_CONTEXT = 5;
    public static final int DO_CONTEXT = 6;
    public static final int USING_CONTEXT = 7;
    private static final String[] NORMAL_TYPES = new String[]{"OclModel", "Helper", "Module", "MatchedRule", "CalledRule", "Rule", "LazyRule"};
    private AtlCompletionHelper fHelper;
    private EObject emfRoot = null;
    private int modelOffset;
    private int context;

    public AtlModelAnalyser(AtlCompletionHelper fHelper, EObject emfRoot, int modelOffset, String lastKeyword, int userOffset) {
        this.fHelper = fHelper;
        this.modelOffset = modelOffset;
        this.emfRoot = emfRoot;
        try {
            this.context = this.getContext(lastKeyword, userOffset);
        }
        catch (BadLocationException e) {
            AtlUIPlugin.log(e);
        }
    }

    public EObject getRootElement() throws BadLocationException {
        return this.emfRoot;
    }

    public EObject getLocatedElement(int offset) throws BadLocationException {
        EObject res = null;
        if (this.emfRoot != null) {
            TreeIterator ti = this.emfRoot.eResource().getAllContents();
            int maxDebOffset = -1;
            while (ti.hasNext()) {
                EObject object = (EObject)ti.next();
                int[] elementOffsets = this.fHelper.getElementOffsets(object, this.modelOffset);
                if (elementOffsets == null || elementOffsets[0] > offset || elementOffsets[1] < offset || elementOffsets[0] <= maxDebOffset) continue;
                maxDebOffset = elementOffsets[0];
                res = object;
            }
        }
        return res;
    }

    public EObject getLostType(String type) {
        if (this.emfRoot != null) {
            EList ti = this.emfRoot.eResource().getContents();
            for (EObject object : ti) {
                String currentType = object.eClass().getName();
                boolean isnormal = false;
                int i = 0;
                while (i < NORMAL_TYPES.length) {
                    isnormal = isnormal || NORMAL_TYPES[i].equals(currentType);
                    ++i;
                }
                if (isnormal || !type.equals(currentType)) continue;
                return object;
            }
        }
        return null;
    }

    public int getContext() {
        return this.context;
    }

    private int getContext(String keyword, int offset) throws BadLocationException {
        if (keyword == null) {
            return 0;
        }
        if (keyword.equalsIgnoreCase("module")) {
            return 1;
        }
        if (keyword.equalsIgnoreCase("helper")) {
            if (this.getLocatedElement(offset) == null) {
                return 1;
            }
            return 2;
        }
        if (keyword.equalsIgnoreCase("rule")) {
            return 3;
        }
        if (keyword.equalsIgnoreCase("from")) {
            if (this.emfRoot == null) {
                return 1;
            }
            return 4;
        }
        if (keyword.equalsIgnoreCase("to")) {
            return 5;
        }
        if (keyword.equalsIgnoreCase("do")) {
            if (this.getLocatedElement(offset) == null) {
                return 1;
            }
            return 6;
        }
        if (keyword.equalsIgnoreCase("using")) {
            return 7;
        }
        return 0;
    }

    public static String getContextName(int id) {
        switch (id) {
            case 0: {
                return "NULL_CONTEXT";
            }
            case 1: {
                return "MODULE_CONTEXT";
            }
            case 2: {
                return "HELPER_CONTEXT";
            }
            case 3: {
                return "RULE_CONTEXT";
            }
            case 4: {
                return "FROM_CONTEXT";
            }
            case 5: {
                return "TO_CONTEXT";
            }
            case 6: {
                return "DO_CONTEXT";
            }
            case 7: {
                return "USING_CONTEXT";
            }
        }
        return "NULL_CONTEXT";
    }
}

