/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlEMFModelHandler
extends AtlModelHandler {
    protected ASMEMFModel mofmm;
    protected ASMEMFModel atlmm;
    protected EMFModelLoader ml;
    protected boolean useIDs = false;
    protected boolean removeIDs = false;
    protected String encoding = "ISO-8859-1";
    private Map bimm = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void saveModel(ASMModel model, IProject project) {
        this.saveModel(model, String.valueOf(model.getName()) + ".ecore", project);
    }

    public void saveModel(ASMModel model, String fileName, IProject project) {
        String uri = String.valueOf(project.getFullPath().toString()) + "/" + fileName;
        this.saveModel(model, uri);
    }

    public void saveModel(ASMModel model, String uri) {
        this.saveModel(model, URI.createURI((String)uri), null);
    }

    public void saveModel(ASMModel model, OutputStream out) {
        this.saveModel(model, null, out);
    }

    public void saveModel(ASMModel model, String path, boolean outputFileIsInWorkspace) {
        URI uri = null;
        uri = outputFileIsInWorkspace ? URI.createURI((String)path) : URI.createFileURI((String)path);
        Resource r = ((ASMEMFModel)model).getExtent();
        r.setURI(uri);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", this.encoding);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        if ((this.useIDs || this.removeIDs) && r instanceof XMIResource) {
            XMIResource xr = (XMIResource)r;
            int id = 1;
            HashSet<EObject> alreadySet = new HashSet<EObject>();
            TreeIterator i = r.getAllContents();
            while (i.hasNext()) {
                EObject eo = (EObject)i.next();
                if (alreadySet.contains(eo)) continue;
                xr.setID(eo, this.removeIDs ? null : "a" + id++);
                alreadySet.add(eo);
            }
        }
        try {
            r.save(options);
            if (outputFileIsInWorkspace) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.path()));
                file.setDerived(true);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected void saveModel(ASMModel model, URI uri, OutputStream out) {
        Resource r = ((ASMEMFModel)model).getExtent();
        if (uri != null) {
            r.setURI(uri);
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", this.encoding);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        if ((this.useIDs || this.removeIDs) && r instanceof XMIResource) {
            XMIResource xr = (XMIResource)r;
            int id = 1;
            HashSet<EObject> alreadySet = new HashSet<EObject>();
            TreeIterator i = r.getAllContents();
            while (i.hasNext()) {
                EObject eo = (EObject)i.next();
                if (alreadySet.contains(eo)) continue;
                xr.setID(eo, this.removeIDs ? null : "a" + id++);
                alreadySet.add(eo);
            }
        }
        try {
            if (out != null) {
                r.save(out, options);
            } else {
                r.save(options);
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.path()));
            file.setDerived(true);
        }
        catch (IOException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected AtlEMFModelHandler() {
        IExtensionRegistry registry;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.m2m.atl.engine.AtlEMFModelHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL atlurl = clazz.getResource("resources/ATL-0.2.ecore");
        this.ml = new EMFModelLoader();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.m2m.atl.engine.injectors.xml.XMLInjector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ml.addInjector("xml", (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.atl.engine.injectors.ebnf.EBNFInjector2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ml.addInjector("ebnf2", (Class)clazz3);
        if (Platform.isRunning() && (registry = Platform.getExtensionRegistry()) != null) {
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.injector");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        this.ml.addInjector(elements[j].getAttribute("name"), elements[j].createExecutableExtension("class").getClass());
                    }
                    catch (CoreException e) {
                        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.mofmm = (ASMEMFModel)this.ml.getMOF();
        try {
            this.atlmm = ASMEMFModel.loadASMEMFModel((String)"ATL", (ASMEMFModel)this.mofmm, (URL)atlurl, (ModelLoader)this.ml);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public ASMModel getMof() {
        return this.mofmm;
    }

    public ASMModel getAtl() {
        return this.atlmm;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, InputStream in) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.loadASMEMFModel((String)name, (ASMEMFModel)((ASMEMFModel)metamodel), (InputStream)in, (ModelLoader)this.ml);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, URI uri) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.loadASMEMFModel((String)name, (ASMEMFModel)((ASMEMFModel)metamodel), (URI)uri, (ModelLoader)this.ml);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, String uri) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.loadASMEMFModel((String)name, (ASMEMFModel)((ASMEMFModel)metamodel), (String)uri, (ModelLoader)this.ml);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel newModel(String name, ASMModel metamodel) {
        ASMEMFModel ret = null;
        try {
            ret = ASMEMFModel.newASMEMFModel((String)name, (ASMEMFModel)((ASMEMFModel)metamodel), (ModelLoader)this.ml);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel newModel(String name, String uri, ASMModel metamodel) {
        ASMEMFModel ret = null;
        if (uri == null) {
            uri = name;
        }
        try {
            ret = ASMEMFModel.newASMEMFModel((String)name, (String)uri, (ASMEMFModel)((ASMEMFModel)metamodel), (ModelLoader)this.ml);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel getBuiltInMetaModel(String name) {
        ASMModel ret = (ASMModel)this.bimm.get(name);
        if (ret == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.m2m.atl.engine.AtlParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL mmurl = clazz.getResource("resources/" + name + ".ecore");
            try {
                ret = this.loadModel(name, (ASMModel)this.mofmm, mmurl.openStream());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            this.bimm.put(name, ret);
        }
        return ret;
    }

    public boolean isHandling(ASMModel model) {
        return model instanceof ASMEMFModel;
    }

    public void disposeOfModel(ASMModel model) {
        ((ASMEMFModel)model).dispose();
    }

    public static ResourceSet getResourceSet() {
        return ASMEMFModel.getResourceSet();
    }
}

