/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.OperationLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;

public class OperationLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    @Override
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        Operation operation = this.getUMLElement();
        if (operation == null) {
            return;
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.getDiagramEventBroker().addNotificationListener((EObject)parameter, (NotificationListener)this);
            if (parameter.getType() == null) continue;
            this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
        }
    }

    @Override
    public Collection<String> getDefaultDisplayValue() {
        return ICustomAppearance.DEFAULT_UML_OPERATION;
    }

    public Map<String, String> getMasks() {
        return OperationLabelHelper.getInstance().getMasks();
    }

    public Operation getUMLElement() {
        if (this.hostSemanticElement instanceof Operation) {
            return (Operation)this.hostSemanticElement;
        }
        return null;
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Operation operation = this.getUMLElement();
        if (object == null) {
            return;
        }
        if (object.equals(operation)) {
            this.notifyOperationChanged(operation, notification);
        } else if (this.isParameter(object)) {
            this.notifyParameterChanged(notification);
        } else if (this.isParameterType(object)) {
            this.notifyParameterTypeChanged(notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected boolean isParameterType(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        for (Parameter parameter : this.getUMLElement().getOwnedParameters()) {
            if (!object.equals(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isParameter(Object object) {
        if (!(object instanceof Parameter)) {
            return false;
        }
        return this.getUMLElement().getOwnedParameters().contains(object);
    }

    protected void notifyParameterChanged(Notification notification) {
        switch (notification.getFeatureID(Parameter.class)) {
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: {
                this.refreshDisplay();
                break;
            }
            case 10: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    protected void notifyParameterTypeChanged(Notification notification) {
        switch (notification.getFeatureID(notification.getNotifier().getClass())) {
            case 5: 
            case 9: 
            case 11: {
                this.refreshDisplay();
                break;
            }
        }
    }

    protected void notifyOperationChanged(Operation operation, Notification notification) {
        switch (notification.getFeatureID(Operation.class)) {
            case 5: 
            case 9: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: {
                this.refreshDisplay();
                break;
            }
            case 24: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    @Override
    public void refreshDisplay() {
        OperationLabelHelper.getInstance().refreshEditPartDisplay(this.getHost());
    }

    @Override
    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Operation operation = this.getUMLElement();
        if (operation == null) {
            return;
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)parameter, (NotificationListener)this);
            if (parameter.getType() == null) continue;
            this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
        }
    }
}

