/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.textedit.editpart;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.sirius.uml.diagram.textedit.Activator;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.model.business.internal.spec.DNodeSpec;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DirectEditCommandBuilder;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ToolBasedLabelDirectEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode3EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusEditPartFactory;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusTextSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusParserProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.ViewNodeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class XtextSiriusDNode3EditPart
extends DNode3EditPart
implements ITextAwareEditPart {
    protected IParser parser;
    protected DirectEditManager manager;
    protected IDirectEditorConfiguration configuration;

    public XtextSiriusDNode3EditPart(View view) {
        super(view);
    }

    protected void performDirectEditRequest(Request request) {
        EObject resolveSemanticElement = this.resolveSemanticElement();
        if (resolveSemanticElement instanceof DNodeSpec) {
            EObject target = ((DNodeSpec)resolveSemanticElement).getTarget();
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + target.eClass().getInstanceClassName());
            if (languagePreferred != null && !languagePreferred.equals("")) {
                this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (Object)target, (Object)((Object)this));
            } else {
                super.performDirectEditRequest(request);
                this.configuration = DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (Object)target, (Object)((Object)this));
            }
            this.configuration.preEditAction((Object)target);
        }
        if (this.configuration instanceof ICustomDirectEditorConfiguration) {
            this.setManager(((ICustomDirectEditorConfiguration)this.configuration).createDirectEditManager((ITextAwareEditPart)this));
            this.initializeDirectEditManager(request);
        }
    }

    protected void initializeDirectEditManager(final Request request) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (XtextSiriusDNode3EditPart.this.isActive() && XtextSiriusDNode3EditPart.this.isEditModeEnabled()) {
                        if (request.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)request.getExtendedData().get("directedit_extendeddata_initial_char");
                            XtextSiriusDNode3EditPart.this.performDirectEdit(initialChar.charValue());
                        } else {
                            XtextSiriusDNode3EditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                XtextSiriusDNode3EditPart.this.getManager().show();
            }
        });
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.resolveSemanticElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.resolveSemanticElement()));
    }

    public String getEditText() {
        if (this.resolveSemanticElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.resolveSemanticElement()), this.getParserOptions().intValue());
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = XtextSiriusDNode3EditPart.this.resolveSemanticElement();
                    final IParser validationParser = XtextSiriusDNode3EditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)XtextSiriusDNode3EditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(validationParser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IParser getParser() {
        if (this.parser == null) {
            String parserHint = Integer.toString(5002);
            SiriusParserProvider.HintAdapter hintAdapter = new SiriusParserProvider.HintAdapter(SiriusElementTypes.DNode_2001, this.resolveSemanticElement(), parserHint);
            this.parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        }
        return this.parser;
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public void setLabelText(String text) {
        this.setLabelTextHelper(this.getContentPane(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof SiriusTextSelectionEditPolicy) {
            ((SiriusTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof SiriusWrapLabel) {
            ((SiriusWrapLabel)figure).setText(text);
        } else if (figure instanceof ViewNodeFigure) {
            SiriusWrapLabel nodeLabel = ((ViewNodeFigure)figure).getNodeLabel();
            this.setLabelTextHelper((IFigure)nodeLabel, text);
        } else if (figure instanceof Label) {
            ((Label)figure).setText(text);
        }
    }

    public Object getAdapter(Class key) {
        if (key == EObject.class) {
            return this.resolveTargetSemanticElement();
        }
        return super.getAdapter(key);
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new TextDirectEditManager((GraphicalEditPart)this, SiriusEditPartFactory.getTextCellEditorClass((GraphicalEditPart)this), SiriusEditPartFactory.getTextCellEditorLocator((ITextAwareEditPart)this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void createDefaultEditPolicies() {
        this.removeEditPolicy("DirectEditPolicy");
        if (this.isDirectEditEnabled()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ToolBasedLabelDirectEditPolicy(this.getEditingDomain()));
        }
        super.createDefaultEditPolicies();
    }

    protected boolean isDirectEditEnabled() {
        DMappingBased mappingBasedObject;
        boolean directEditEnabled = false;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DMappingBased && (mappingBasedObject = (DMappingBased)eObj).getMapping() != null && mappingBasedObject instanceof DDiagramElement && ((DDiagramElement)mappingBasedObject).getDiagramElementMapping().getLabelDirectEdit() != null) {
            DirectEditLabel labelDirectEdit = ((DDiagramElement)mappingBasedObject).getDiagramElementMapping().getLabelDirectEdit();
            DirectEditCommandBuilder builder = new DirectEditCommandBuilder((DRepresentationElement)((DDiagramElement)mappingBasedObject), labelDirectEdit, null);
            directEditEnabled = builder.canDirectEdit();
        }
        return directEditEnabled;
    }
}

