/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class HideViewRule
extends TestWatcher {
    private final String viewID;
    private IWorkbenchPage page;

    public HideViewRule(String viewID) {
        this.viewID = viewID;
    }

    protected void starting(Description description) {
        IWorkbenchPage page;
        IViewPart viewPart;
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null) {
            window = bench.getWorkbenchWindows()[0];
        }
        if ((viewPart = (page = window.getActivePage()).findView(this.viewID)) != null) {
            this.page = page;
            page.hideView(viewPart);
        }
    }

    protected void finished(Description description) {
        if (this.page != null) {
            try {
                this.page.showView(this.viewID);
            }
            catch (PartInitException e) {
                Assert.fail((String)String.format("Failed to restore view %s: %s", this.viewID, e.getLocalizedMessage()));
            }
        }
        this.page = null;
    }
}

