/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.welcome.internal.modelelements;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.welcome.internal.util.UISafeAdapter;
import org.eclipse.papyrus.infra.gmfdiag.welcome.internal.util.ViewUtil;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.infra.tools.databinding.TouchableValue;

public class NotationObservable
extends ReferenceCountedObservable.Abstract {
    private ViewAdapter viewAdapter;
    private ContextAdapter contextAdapter;
    private final TouchableValue<EObject> viewValue;
    private final TouchableValue<EObject> contextValue;

    public NotationObservable(EObject view) {
        this(Realm.getDefault(), view);
    }

    public NotationObservable(Realm realm, EObject view) {
        super(realm);
        EObject context = ViewUtil.getContext(view);
        this.viewValue = new TouchableValue(realm, EObject.class, (Object)view);
        this.contextValue = new TouchableValue(realm, EObject.class, (Object)context);
        this.viewAdapter = new ViewAdapter(view);
        this.handleContextChanged(null, context);
        IChangeListener rollup = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NotationObservable.this.fireChange();
            }
        };
        this.viewValue.addChangeListener(rollup);
        this.contextValue.addChangeListener(rollup);
    }

    public synchronized void dispose() {
        if (this.viewAdapter != null) {
            this.viewAdapter.dispose();
        }
        if (this.contextAdapter != null) {
            this.contextAdapter.dispose();
        }
        this.viewValue.dispose();
        this.contextValue.dispose();
        super.dispose();
    }

    public IObservableValue<EObject> getView() {
        return this.viewValue;
    }

    public IObservableValue<EObject> getContext() {
        return this.contextValue;
    }

    public boolean isStale() {
        return false;
    }

    void handleContextChanged(EObject oldContext, EObject newContext) {
        ContextAdapter adapter = this.contextAdapter;
        if (oldContext != null) {
            oldContext.eAdapters().remove((Object)this.contextAdapter);
        }
        if (newContext != null) {
            if (adapter == null) {
                this.contextAdapter = new ContextAdapter(newContext);
            } else {
                newContext.eAdapters().add((Object)adapter);
                this.contextAdapter = adapter;
            }
        }
        this.contextValue.setValue((Object)newContext);
    }

    private class ContextAdapter
    extends UISafeAdapter {
        ContextAdapter(EObject context) {
            context.eAdapters().add((Object)this);
        }

        void dispose() {
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (this.target == oldTarget) {
                NotationObservable.this.contextAdapter = null;
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void doNotifyChanged(Notification msg) {
            if (!msg.isTouch()) {
                NotationObservable.this.contextValue.touch();
            }
        }
    }

    private class ViewAdapter
    extends UISafeAdapter {
        ViewAdapter(EObject view) {
            view.eAdapters().add((Object)this);
        }

        void dispose() {
            if (this.target != null) {
                this.target.eAdapters().remove((Object)this);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (this.target == oldTarget) {
                NotationObservable.this.viewAdapter = null;
            }
            super.unsetTarget(oldTarget);
        }

        @Override
        protected void doNotifyChanged(Notification msg) {
            if (!msg.isTouch()) {
                Object notifier = msg.getNotifier();
                if (notifier instanceof Diagram) {
                    switch (msg.getFeatureID(Diagram.class)) {
                        case 2: 
                        case 11: {
                            NotationObservable.this.viewValue.touch();
                            break;
                        }
                        case 8: {
                            NotationObservable.this.handleContextChanged((EObject)msg.getOldValue(), (EObject)msg.getNewValue());
                        }
                    }
                } else if (notifier instanceof Table) {
                    switch (msg.getFeatureID(Diagram.class)) {
                        case 3: 
                        case 7: {
                            NotationObservable.this.viewValue.touch();
                            break;
                        }
                        case 4: {
                            NotationObservable.this.handleContextChanged((EObject)msg.getOldValue(), (EObject)msg.getNewValue());
                        }
                    }
                }
            }
        }
    }
}

