/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.infra.constraints.CompositeConstraint;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.ConstraintsFactory;
import org.eclipse.papyrus.infra.constraints.ConstraintsPackage;
import org.eclipse.papyrus.infra.constraints.ReferenceProperty;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.constraints.util.ConstraintsSwitch;
import org.eclipse.papyrus.infra.properties.contexts.AbstractSection;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextContentTreeIterator;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextsSwitch;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.UiPackage;
import org.eclipse.papyrus.infra.properties.ui.Widget;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.util.UiSwitch;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.infra.tools.util.RecursionGuard;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;

abstract class SwitchingSourceTraceHelper
extends ComposedSwitch<EObject>
implements SourceTraceHelper {
    SwitchingSourceTraceHelper() {
        this.addSwitch(this.createContextsSwitch());
        this.addSwitch(this.createConstraintsSwitch());
    }

    protected final EObject composedSwitch(EObject object) {
        return (EObject)super.doSwitch(object);
    }

    @Override
    public final EObject getSourceElement(EObject propertiesElement) {
        return this.composedSwitch(propertiesElement);
    }

    protected Switch<EObject> createContextsSwitch() {
        return new ContextsDelegate();
    }

    protected Switch<EObject> createConstraintsSwitch() {
        return new ConstraintsDelegate();
    }

    protected ValueProperty getProperty(SimpleConstraint constraint, String propertyName) {
        return (ValueProperty)constraint.getProperties(propertyName, false, ConstraintsPackage.Literals.VALUE_PROPERTY);
    }

    protected String getValue(SimpleConstraint constraint, String propertyName) {
        ValueProperty result = this.getProperty(constraint, propertyName);
        return result != null ? result.getValue() : null;
    }

    protected void setValue(SimpleConstraint constraint, String propertyName, String value) {
        ValueProperty property = ConstraintsFactory.eINSTANCE.createValueProperty();
        property.setName(propertyName);
        property.setValue(value);
        constraint.getProperties().add((Object)property);
    }

    protected EObject getReference(SimpleConstraint constraint, String propertyName) {
        ReferenceProperty result = (ReferenceProperty)constraint.getProperties(propertyName, false, ConstraintsPackage.Literals.REFERENCE_PROPERTY);
        return result != null ? result.getValue() : null;
    }

    protected void setReference(SimpleConstraint constraint, String propertyName, EObject reference) {
        ReferenceProperty property = ConstraintsFactory.eINSTANCE.createReferenceProperty();
        property.setName(propertyName);
        property.setValue(reference);
        constraint.getProperties().add((Object)property);
    }

    protected Optional<ConstraintType> getConstraintType(String className) {
        return Optional.ofNullable((Context)Iterables.getFirst((Iterable)PropertiesRuntime.getConfigurationManager().getContexts(), null)).map(context -> PropertiesCache.getInstance((Notifier)context).getConstraintTypes((Context)context)).flatMap(constraintTypes -> constraintTypes.stream().filter(type -> className.equals(type.getConstraintClass())).findAny());
    }

    protected Optional<ConstraintType> getConstraintType(ConstraintDescriptor constraint) {
        ConstraintType result = null;
        if (constraint instanceof SimpleConstraint) {
            SimpleConstraint simple = (SimpleConstraint)constraint;
            result = simple.getConstraintType();
        }
        return Optional.ofNullable(result);
    }

    protected Optional<SimpleConstraint> asSimpleConstraint(ConstraintDescriptor constraint) {
        return Optional.ofNullable(constraint).filter(SimpleConstraint.class::isInstance).map(SimpleConstraint.class::cast);
    }

    protected abstract EObject getOwningPackage(EObject var1);

    protected abstract EObject getClass(EObject var1, DataContextElement var2);

    protected abstract EObject getProperty(EObject var1, Property var2);

    protected EObject drillDown(Iterable<? extends EObject> nested) {
        EObject result = null;
        Iterator<? extends EObject> iter = nested.iterator();
        while (result == null && iter.hasNext()) {
            result = this.composedSwitch(iter.next());
        }
        return result;
    }

    protected EObject drillDown(Iterable<? extends EObject> nested, Function<? super EObject, ? extends EObject> resultFunction) {
        EObject result = null;
        Iterator<? extends EObject> iter = nested.iterator();
        while (result == null && iter.hasNext()) {
            EObject next = this.composedSwitch(iter.next());
            if (next == null) continue;
            result = resultFunction.apply((EObject)next);
        }
        return result;
    }

    protected class ConstraintsDelegate
    extends ConstraintsSwitch<EObject> {
        protected ConstraintsDelegate() {
        }

        public EObject caseCompositeConstraint(CompositeConstraint object) {
            return SwitchingSourceTraceHelper.this.drillDown((Iterable<? extends EObject>)object.getConstraints());
        }

        public EObject caseSimpleConstraint(SimpleConstraint object) {
            EObject result = null;
            ConstraintType type = object.getConstraintType();
            if (type.getConstraintClass() != null) {
                result = this.constraintSwitch(object, type.getConstraintClass());
            }
            return result;
        }

        protected EObject constraintSwitch(SimpleConstraint constraint, String constraintClass) {
            return null;
        }
    }

    protected class ContextsDelegate
    extends ContextsSwitch<EObject> {
        private final RecursionGuard<EObject> upwardRecursionGuard = new RecursionGuard();

        protected ContextsDelegate() {
        }

        public EObject caseAbstractSection(AbstractSection object) {
            return SwitchingSourceTraceHelper.this.drillDown((Iterable<? extends EObject>)object.getConstraints());
        }

        public EObject caseSection(Section object) {
            EObject result = this.caseAbstractSection((AbstractSection)object);
            if (result == null) {
                result = SwitchingSourceTraceHelper.this.drillDown((Iterable<? extends EObject>)object.getViews());
            }
            return result;
        }

        public EObject caseView(View object) {
            return SwitchingSourceTraceHelper.this.drillDown((Iterable<? extends EObject>)object.getConstraints());
        }

        public EObject caseDataContextPackage(DataContextPackage object) {
            return SwitchingSourceTraceHelper.this.drillDown((Iterable<? extends EObject>)object.getElements(), SwitchingSourceTraceHelper.this::getOwningPackage);
        }

        public EObject caseDataContextElement(DataContextElement object) {
            EObject result = null;
            PropertiesCache cache = PropertiesCache.getInstance((Notifier)object);
            if (!object.getProperties().isEmpty()) {
                for (Property property : object.getProperties()) {
                    result = cache.getViews(object).stream().filter(view -> this.hasEditor((View)view, property)).map(SwitchingSourceTraceHelper.this::getSourceElement).filter(Objects::nonNull).filter(sourceClass -> Objects.equals(SwitchingSourceTraceHelper.this.getName((EObject)sourceClass), object.getName())).findAny().orElse(null);
                    if (result != null) break;
                }
            }
            if (result == null) {
                EObject container = object.eContainer();
                Object object2 = null;
                Object var6_7 = null;
                try (RecursionGuard.Gate gate = this.upwardRecursionGuard.guardIfAny(DataContextPackage.class::isInstance, (Object[])new EObject[]{container});){
                    EObject sourcePackage;
                    if (gate.isOpen() && !(container instanceof Context) && (sourcePackage = SwitchingSourceTraceHelper.this.composedSwitch(container)) != null) {
                        result = SwitchingSourceTraceHelper.this.getClass(sourcePackage, object);
                    }
                }
                catch (Throwable throwable) {
                    if (object2 == null) {
                        object2 = throwable;
                    } else if (object2 != throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    throw object2;
                }
            }
            return result;
        }

        private boolean hasEditor(View view, Property property) {
            boolean result = false;
            TreeIterator editors = Iterators2.filter((TreeIterator)new ContextContentTreeIterator((Collection)view.getSections()), PropertyEditor.class);
            while (!result && editors.hasNext()) {
                boolean bl = result = ((PropertyEditor)editors.next()).getProperty() == property;
            }
            return result;
        }

        public EObject caseProperty(Property object) {
            EObject sourceClass;
            DataContextElement owner = object.getContextElement();
            if (owner == null) {
                return null;
            }
            EObject result = null;
            PropertiesCache cache = PropertiesCache.getInstance((Notifier)object);
            Iterator iter = cache.getReferencers((EObject)object, UiPackage.Literals.PROPERTY_EDITOR__PROPERTY).iterator();
            while (result == null && iter.hasNext()) {
                Widget rootWidget = this.getRootWidget((Widget)iter.next());
                Section section = this.getSection(rootWidget);
                if (section == null || (sourceClass = SwitchingSourceTraceHelper.this.composedSwitch((EObject)section)) == null || !Objects.equals(SwitchingSourceTraceHelper.this.getName(sourceClass), owner.getName())) continue;
                result = SwitchingSourceTraceHelper.this.getProperty(sourceClass, object);
            }
            if (result == null) {
                Throwable throwable = null;
                Object var6_7 = null;
                try (RecursionGuard.Gate gate = this.upwardRecursionGuard.guard((Object[])new EObject[]{owner});){
                    if (gate.isOpen() && (sourceClass = SwitchingSourceTraceHelper.this.composedSwitch((EObject)owner)) != null) {
                        result = SwitchingSourceTraceHelper.this.getProperty(sourceClass, object);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return result;
        }

        Widget getRootWidget(Widget widget) {
            Widget result = widget;
            while (result != null && result.eContainer() instanceof Widget) {
                result = (Widget)result.eContainer();
            }
            return result;
        }

        Section getSection(Widget widget) {
            PropertiesCache cache = PropertiesCache.getInstance((Notifier)widget);
            EList sections = cache.getReferencers((EObject)widget, ContextsPackage.Literals.SECTION__WIDGET);
            return sections.isEmpty() ? null : (Section)sections.get(0);
        }
    }

    protected class UIDelegate
    extends UiSwitch<EObject> {
        protected UIDelegate() {
        }

        public EObject caseCompositeWidget(CompositeWidget object) {
            return SwitchingSourceTraceHelper.this.drillDown((Iterable<? extends EObject>)object.getWidgets());
        }

        public EObject casePropertyEditor(PropertyEditor object) {
            return (EObject)super.casePropertyEditor(object);
        }
    }
}

