/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.util;

import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class StringUtils {
    private static Function<String, String> STRING_VARIABLE_SUBSTITUTOR;
    private static final Pattern STRING_EXPANSION_PATTERN;

    static {
        Function<Object, Object> stringSubstitutor = Function.identity();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.variables");
        if (bundle != null) {
            try {
                Class variablesPluginClass = bundle.loadClass("org.eclipse.core.variables.VariablesPlugin");
                Object variablesPlugin = variablesPluginClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                Object stringVariableManager = variablesPluginClass.getMethod("getStringVariableManager", new Class[0]).invoke(variablesPlugin, new Object[0]);
                Method performStringSubsitutionMethod = stringVariableManager.getClass().getMethod("performStringSubstitution", String.class, Boolean.TYPE);
                stringSubstitutor = it -> {
                    try {
                        return (String)performStringSubsitutionMethod.invoke(stringVariableManager, it, false);
                    }
                    catch (Exception exception) {
                        return it;
                    }
                };
            }
            catch (Exception exception) {}
        }
        STRING_VARIABLE_SUBSTITUTOR = stringSubstitutor;
        STRING_EXPANSION_PATTERN = Pattern.compile("\\$\\{([^${}|/]+)\\}");
    }

    public static String performStringSubstitution(String str) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = STRING_EXPANSION_PATTERN.matcher(str);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String replacement = System.getProperty(propertyName);
            if (replacement != null) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
                continue;
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group()));
        }
        matcher.appendTail(result);
        return STRING_VARIABLE_SUBSTITUTOR.apply(result.toString());
    }

    public static String trimmedOrNull(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        return str;
    }

    public static String trimRight(String str) {
        if (str == null) {
            return null;
        }
        int pos = str.length();
        while (pos > 0 && Character.isWhitespace(str.charAt(pos - 1))) {
            --pos;
        }
        return str.substring(0, pos);
    }
}

