/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.validator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.validator.AbstractValidator;

public class UnlimitedNaturalValidator
extends AbstractValidator {
    public static final String INFINITE_STAR = "*";
    public static final String INFINITE_MINUS_ONE = "-1";

    public String isValid(String newText) {
        if (INFINITE_STAR.equals(newText) || INFINITE_MINUS_ONE.equals(newText)) {
            return null;
        }
        boolean isValid = true;
        try {
            Integer myUnlimitedNatural = Integer.valueOf(newText);
            if (myUnlimitedNatural < -1) {
                isValid = false;
            }
        }
        catch (NumberFormatException e) {
            isValid = false;
        }
        if (!isValid) {
            return Messages.UnlimitedNaturalInputValidator_NotAnUnlimitedNaturalMessage;
        }
        return null;
    }

    public IStatus validate(Object newValue) {
        int value;
        if (newValue instanceof Integer && ((value = ((Integer)newValue).intValue()) == -1 || value >= 0)) {
            return Status.OK_STATUS;
        }
        if (newValue instanceof String) {
            String newText = (String)newValue;
            if (INFINITE_STAR.equals(newText) || INFINITE_MINUS_ONE.equals(newText)) {
                return Status.OK_STATUS;
            }
            boolean isValid = true;
            try {
                Integer myUnlimitedNatural = Integer.parseInt(newText);
                if (myUnlimitedNatural < -1) {
                    isValid = false;
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
            if (isValid) {
                return Status.OK_STATUS;
            }
        }
        return this.error(Messages.UnlimitedNaturalInputValidator_NotAnUnlimitedNaturalMessage);
    }
}

